/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.modmenu.gui;

import com.terraformersmc.modmenu.ModMenu;
import com.terraformersmc.modmenu.config.BetterModListConfig;
import com.terraformersmc.modmenu.gui.ModsScreen;
import com.terraformersmc.modmenu.gui.widget.BadgeToogleButton;
import com.terraformersmc.modmenu.gui.widget.LegacyTexturedButtonWidget;
import com.terraformersmc.modmenu.util.DrawingUtil;
import com.terraformersmc.modmenu.util.mod.Mod;
import com.terraformersmc.modmenu.util.mod.ModBadge;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import org.jetbrains.annotations.Nullable;

public class BadgeScreen
extends Screen {
    @Nullable
    private AbstractWidget badgeButton;
    private final Mod mod;
    private final int posX;

    protected BadgeScreen(Mod mod, int paneWidth, int searchBoxWidth) {
        super(CommonComponents.EMPTY);
        this.mod = mod;
        this.posX = paneWidth / 2 + searchBoxWidth / 2 - 10 + 26;
    }

    public void onClose() {
        ModMenu.getConfig().save();
        super.onClose();
    }

    protected void renderBlurredBackground(GuiGraphics p_420069_) {
    }

    protected void init() {
        this.badgeButton = LegacyTexturedButtonWidget.legacyTexturedBuilder(CommonComponents.EMPTY, button -> this.onClose()).position(this.posX, 22).size(20, 20).uv(0, 0, 20).texture(ModsScreen.BADGE_BUTTON_LOCATION, 32, 64).build();
        this.addRenderableWidget((GuiEventListener)this.badgeButton);
        int i = 0;
        int buttonX = this.posX - 11;
        for (Map<String, ModBadge> badgeMap : ModBadge.BADGES) {
            for (Map.Entry<String, ModBadge> badgeEntry : badgeMap.entrySet()) {
                ModBadge badge = badgeEntry.getValue();
                this.addRenderableWidget((GuiEventListener)BadgeToogleButton.badgeButtonBuilder(CommonComponents.EMPTY, button -> {
                    BetterModListConfig config = ModMenu.getConfig();
                    if (this.mod.getBadges().contains(badge)) {
                        this.mod.getBadges().remove(badge);
                        config.mod_badges.get(this.mod.getId()).remove(badgeEntry.getKey());
                        if (this.mod.getBadgeNames().contains(badgeEntry.getKey())) {
                            config.disabled_mod_badges.computeIfAbsent(this.mod.getId(), v -> new LinkedHashSet()).add((String)badgeEntry.getKey());
                        }
                    } else {
                        this.mod.getBadges().add(badge);
                        Set<String> disabled_badges = config.disabled_mod_badges.get(this.mod.getId());
                        if (disabled_badges != null && disabled_badges.contains(badgeEntry.getKey())) {
                            disabled_badges.remove(badgeEntry.getKey());
                        } else {
                            config.mod_badges.get(this.mod.getId()).add((String)badgeEntry.getKey());
                        }
                    }
                    ((BadgeToogleButton)button).toggle();
                }, this.mod.getBadges().contains(badge)).position(buttonX, 43 + 11 * i).size(11, 11).uv(0, 0, 11).build());
                ++i;
            }
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        int i = 0;
        for (Map<String, ModBadge> badges : ModBadge.BADGES) {
            for (Map.Entry<String, ModBadge> mapEntry : badges.entrySet()) {
                ModBadge badge = mapEntry.getValue();
                int badgeWidth = this.minecraft.font.width(badge.getComponent().getVisualOrderText()) + 6;
                DrawingUtil.drawBadge(guiGraphics, this.posX, 43 + 11 * i, badgeWidth, badge.getComponent().getVisualOrderText(), badge.getOutlineColor(), badge.getFillColor(), badge.getTextColor());
                ++i;
            }
        }
    }
}

