/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.modmenu.gui;

import com.google.common.base.Joiner;
import com.terraformersmc.modmenu.ModMenu;
import com.terraformersmc.modmenu.config.BetterModListConfig;
import com.terraformersmc.modmenu.gui.BadgeScreen;
import com.terraformersmc.modmenu.gui.widget.DescriptionListWidget;
import com.terraformersmc.modmenu.gui.widget.LegacyTexturedButtonWidget;
import com.terraformersmc.modmenu.gui.widget.ModListWidget;
import com.terraformersmc.modmenu.gui.widget.entries.ModListEntry;
import com.terraformersmc.modmenu.util.DrawingUtil;
import com.terraformersmc.modmenu.util.ModMenuScreenTexts;
import com.terraformersmc.modmenu.util.TranslationUtil;
import com.terraformersmc.modmenu.util.mod.Mod;
import com.terraformersmc.modmenu.util.mod.ModBadge;
import com.terraformersmc.modmenu.util.mod.ModBadgeRenderer;
import java.awt.Dimension;
import java.io.IOException;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.ToastManager;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.CharacterEvent;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.CommonLinks;
import net.minecraft.util.Tuple;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModsScreen
extends Screen {
    private static final ResourceLocation FILTERS_BUTTON_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"modmenu", (String)"textures/gui/filters_button.png");
    private static final ResourceLocation CONFIGURE_BUTTON_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"modmenu", (String)"textures/gui/configure_button.png");
    public static final ResourceLocation BADGE_BUTTON_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"modmenu", (String)"textures/gui/badge_button.png");
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Better ModList | ModsScreen");
    private final Screen previousScreen;
    private ModListEntry selected;
    private ModBadgeRenderer modBadgeRenderer;
    private double scrollPercent = 0.0;
    private boolean keepFilterOptionsShown = false;
    private boolean init = false;
    private boolean filterOptionsShown = false;
    protected static final int RIGHT_PANE_Y = 48;
    private int paneWidth;
    private int rightPaneX;
    private int searchBoxX;
    private int filtersX;
    private int filtersWidth;
    private int searchRowWidth;
    public final Set<String> showModChildren = new HashSet<String>();
    private EditBox searchBox;
    @Nullable
    private AbstractWidget filtersButton;
    private AbstractWidget sortingButton;
    private AbstractWidget librariesButton;
    private ModListWidget modList;
    @Nullable
    private AbstractWidget configureButton;
    @Nullable
    private AbstractWidget badgeButton;
    private AbstractWidget websiteButton;
    private AbstractWidget issuesButton;
    private DescriptionListWidget descriptionListWidget;
    private AbstractWidget modsFolderButton;
    private AbstractWidget doneButton;
    public final Map<ModContainer, Boolean> modHasConfigScreen = new HashMap<ModContainer, Boolean>();
    public final Map<String, Throwable> modScreenErrors = new HashMap<String, Throwable>();
    private static final Component SEND_FEEDBACK_TEXT = Component.translatable((String)"menu.sendFeedback");
    private static final Component REPORT_BUGS_TEXT = Component.translatable((String)"menu.reportBugs");

    public ModsScreen(Screen previousScreen) {
        super(ModMenuScreenTexts.TITLE);
        this.previousScreen = previousScreen;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (this.modList.isMouseOver(mouseX, mouseY)) {
            return this.modList.mouseScrolled(mouseX, mouseY, horizontalAmount, verticalAmount);
        }
        if (this.descriptionListWidget.isMouseOver(mouseX, mouseY)) {
            return this.descriptionListWidget.mouseScrolled(mouseX, mouseY, horizontalAmount, verticalAmount);
        }
        return false;
    }

    protected void init() {
        int rightPaneY;
        int paneY;
        boolean hideTop = (Boolean)ModMenu.getConfig().HIDE_SCREEN_TOP.get();
        if (hideTop) {
            paneY = 30;
            rightPaneY = 5;
        } else {
            paneY = (Boolean)ModMenu.getConfig().CONFIG_MODE.get() != false ? 48 : 67;
            rightPaneY = 48;
        }
        this.paneWidth = this.width / 2 - 8;
        this.rightPaneX = this.width - this.paneWidth;
        this.modList = new ModListWidget(this.minecraft, this.paneWidth, this.height - paneY - 36, paneY, (Boolean)ModMenu.getConfig().COMPACT_LIST.get() != false ? 23 : 36, this.modList, this);
        this.modList.setX(0);
        int filtersButtonSize = (Boolean)ModMenu.getConfig().CONFIG_MODE.get() != false ? 0 : 22;
        int searchWidthMax = this.paneWidth - 32 - filtersButtonSize;
        int searchBoxWidth = (Boolean)ModMenu.getConfig().CONFIG_MODE.get() != false ? Math.min(200, searchWidthMax) : searchWidthMax;
        this.searchBoxX = this.paneWidth / 2 - searchBoxWidth / 2 - filtersButtonSize / 2;
        this.searchBox = new EditBox(this.font, this.searchBoxX, 22, searchBoxWidth, 20, this.searchBox, ModMenuScreenTexts.SEARCH);
        if (((Boolean)ModMenu.getConfig().HIDE_SCREEN_TOP.get()).booleanValue()) {
            this.searchBox.visible = false;
            this.searchBox.active = false;
        }
        this.searchBox.setResponder(text -> this.modList.filter((String)text, false));
        Component sortingText = ModMenuScreenTexts.getSortingComponent();
        Component librariesText = ModMenuScreenTexts.getLibrariesComponent();
        int sortingWidth = this.font.width((FormattedText)sortingText) + 20;
        int librariesWidth = this.font.width((FormattedText)librariesText) + 20;
        this.filtersWidth = librariesWidth + sortingWidth + 2;
        this.searchRowWidth = this.searchBoxX + searchBoxWidth + 22;
        this.updateFiltersX(true);
        if (!((Boolean)ModMenu.getConfig().CONFIG_MODE.get()).booleanValue()) {
            this.filtersButton = LegacyTexturedButtonWidget.legacyTexturedBuilder(ModMenuScreenTexts.TOGGLE_FILTER_OPTIONS, button -> this.setFilterOptionsShown(!this.filterOptionsShown)).position(this.paneWidth / 2 + searchBoxWidth / 2 - 10 + 2, 22).size(20, 20).uv(0, 0, 20).texture(FILTERS_BUTTON_LOCATION, 32, 64).build();
            this.filtersButton.setTooltip(Tooltip.create((Component)ModMenuScreenTexts.TOGGLE_FILTER_OPTIONS));
            if (((Boolean)ModMenu.getConfig().HIDE_SCREEN_TOP.get()).booleanValue()) {
                this.filtersButton.visible = false;
                this.filtersButton.active = false;
            }
        }
        this.sortingButton = Button.builder((Component)sortingText, button -> {
            ((BetterModListConfig.Sorting)((Object)((Object)ModMenu.getConfig().SORTING.get()))).cycleValue();
            ((ModConfigSpec)ModMenu.CONFIG.getRight()).save();
            this.modList.reloadFilters();
            button.setMessage(ModMenuScreenTexts.getSortingComponent());
        }).pos(this.filtersX, 45).size(sortingWidth, 20).build();
        this.librariesButton = Button.builder((Component)librariesText, button -> {
            ModMenu.getConfig().SHOW_LIBRARIES.set((Object)((Boolean)ModMenu.getConfig().SHOW_LIBRARIES.get() == false ? 1 : 0));
            ((ModConfigSpec)ModMenu.CONFIG.getRight()).save();
            this.modList.reloadFilters();
            button.setMessage(ModMenuScreenTexts.getLibrariesComponent());
        }).pos(this.filtersX + sortingWidth + 2, 45).size(librariesWidth, 20).build();
        if (!((Boolean)ModMenu.getConfig().HIDE_CONFIG_BUTTONS.get()).booleanValue()) {
            this.configureButton = LegacyTexturedButtonWidget.legacyTexturedBuilder(CommonComponents.EMPTY, button -> {
                Mod mod = Objects.requireNonNull(this.selected).getMod();
                if (this.getModHasConfigScreen(mod.getContainer())) {
                    this.safelyOpenConfigScreen(mod.getContainer().get());
                } else {
                    button.active = false;
                }
            }).position(this.width - 24, rightPaneY).size(20, 20).uv(0, 0, 20).texture(CONFIGURE_BUTTON_LOCATION, 32, 64).build();
        }
        if (!((Boolean)ModMenu.getConfig().HIDE_BADGE_BUTTONS.get()).booleanValue()) {
            this.badgeButton = LegacyTexturedButtonWidget.legacyTexturedBuilder(CommonComponents.EMPTY, button -> this.minecraft.pushGuiLayer((Screen)new BadgeScreen(this.selected.mod, this.paneWidth, searchBoxWidth))).position(this.paneWidth / 2 + searchBoxWidth / 2 - 10 + 26, 22).size(20, 20).uv(0, 0, 20).texture(BADGE_BUTTON_LOCATION, 32, 64).build();
        }
        int urlButtonWidths = this.paneWidth / 2 - 2;
        int cappedButtonWidth = Math.min(urlButtonWidths, 200);
        this.websiteButton = Button.builder((Component)ModMenuScreenTexts.WEBSITE, button -> {
            Mod mod = Objects.requireNonNull(this.selected).getMod();
            boolean isMinecraft = this.selected.getMod().getId().equals("minecraft");
            if (isMinecraft) {
                URI url = SharedConstants.getCurrentVersion().stable() ? CommonLinks.RELEASE_FEEDBACK : CommonLinks.SNAPSHOT_FEEDBACK;
                ConfirmLinkScreen.confirmLinkNow((Screen)this, (URI)url, (boolean)true);
            } else {
                String url = mod.getWebsite();
                if (url != null) {
                    ConfirmLinkScreen.confirmLinkNow((Screen)this, (String)url, (boolean)false);
                }
            }
        }).pos(this.rightPaneX + urlButtonWidths / 2 - cappedButtonWidth / 2, rightPaneY + 36).size(Math.min(urlButtonWidths, 200), 20).build();
        this.issuesButton = Button.builder((Component)ModMenuScreenTexts.ISSUES, button -> {
            Mod mod = Objects.requireNonNull(this.selected).getMod();
            boolean isMinecraft = this.selected.getMod().getId().equals("minecraft");
            if (isMinecraft) {
                ConfirmLinkScreen.confirmLinkNow((Screen)this, (URI)CommonLinks.SNAPSHOT_BUGS_FEEDBACK, (boolean)true);
            } else {
                String url = mod.getIssueTracker();
                if (url != null) {
                    ConfirmLinkScreen.confirmLinkNow((Screen)this, (String)url, (boolean)false);
                }
            }
        }).pos(this.rightPaneX + urlButtonWidths + 4 + urlButtonWidths / 2 - cappedButtonWidth / 2, rightPaneY + 36).size(Math.min(urlButtonWidths, 200), 20).build();
        Objects.requireNonNull(this.font);
        this.descriptionListWidget = new DescriptionListWidget(this.minecraft, this.paneWidth, this.height - rightPaneY - 96, rightPaneY + 60, 9 + 1, this.descriptionListWidget, this);
        this.descriptionListWidget.setX(this.rightPaneX);
        this.modsFolderButton = Button.builder((Component)ModMenuScreenTexts.MODS_FOLDER, button -> Util.getPlatform().openUri(FMLPaths.MODSDIR.get().toUri())).pos(this.width / 2 - 154, this.height - 28).size(150, 20).build();
        this.doneButton = Button.builder((Component)CommonComponents.GUI_DONE, button -> this.minecraft.setScreen(this.previousScreen)).pos(this.width / 2 + 4, this.height - 28).size(150, 20).build();
        this.modList.finalizeInit();
        this.setFilterOptionsShown(this.keepFilterOptionsShown && this.filterOptionsShown);
        this.addWidget((GuiEventListener)this.searchBox);
        this.setInitialFocus((GuiEventListener)this.searchBox);
        if (this.filtersButton != null) {
            this.addRenderableWidget((GuiEventListener)this.filtersButton);
        }
        this.addRenderableWidget((GuiEventListener)this.sortingButton);
        this.addRenderableWidget((GuiEventListener)this.librariesButton);
        this.addWidget((GuiEventListener)this.modList);
        if (this.configureButton != null) {
            this.addRenderableWidget((GuiEventListener)this.configureButton);
        }
        if (this.badgeButton != null) {
            this.addRenderableWidget((GuiEventListener)this.badgeButton);
        }
        this.addRenderableWidget((GuiEventListener)this.websiteButton);
        this.addRenderableWidget((GuiEventListener)this.issuesButton);
        this.addWidget((GuiEventListener)this.descriptionListWidget);
        this.addRenderableWidget((GuiEventListener)this.modsFolderButton);
        this.addRenderableWidget((GuiEventListener)this.doneButton);
        this.init = true;
        this.keepFilterOptionsShown = true;
    }

    public boolean keyPressed(KeyEvent event) {
        return super.keyPressed(event) || this.searchBox.keyPressed(event);
    }

    public boolean charTyped(CharacterEvent event) {
        return this.searchBox.charTyped(event);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        super.render(guiGraphics, mouseX, mouseY, delta);
        boolean hideTop = (Boolean)ModMenu.getConfig().HIDE_SCREEN_TOP.get();
        int rightPaneY = hideTop ? 5 : 48;
        ModListEntry selectedEntry = this.selected;
        if (selectedEntry != null) {
            this.descriptionListWidget.render(guiGraphics, mouseX, mouseY, delta);
        }
        this.modList.render(guiGraphics, mouseX, mouseY, delta);
        this.searchBox.render(guiGraphics, mouseX, mouseY, delta);
        if (!hideTop) {
            guiGraphics.drawCenteredString(this.font, this.title, this.modList.getWidth() / 2, 8, 0xFFFFFF);
        }
        assert (this.minecraft != null);
        int grayColor = -5592406;
        if (!((Boolean)ModMenu.getConfig().DISABLE_DRAG_AND_DROP.get()).booleanValue() && !hideTop) {
            int n = this.width - this.modList.getWidth() / 2;
            Objects.requireNonNull(this.minecraft.font);
            guiGraphics.drawCenteredString(this.font, ModMenuScreenTexts.DROP_INFO_LINE_1, n, 24 - 9 - 1, grayColor);
            guiGraphics.drawCenteredString(this.font, ModMenuScreenTexts.DROP_INFO_LINE_2, this.width - this.modList.getWidth() / 2, 25, grayColor);
        }
        if (!((Boolean)ModMenu.getConfig().CONFIG_MODE.get()).booleanValue()) {
            Component fullModCount = this.computeModCountText(true, false);
            if (!((Boolean)ModMenu.getConfig().CONFIG_MODE.get()).booleanValue() && this.updateFiltersX(false)) {
                int showingModTextY = hideTop ? 6 : 46;
                if (!((Boolean)ModMenu.getConfig().SHOW_LIBRARIES.get()).booleanValue() || this.font.width((FormattedText)fullModCount) <= (this.filterOptionsShown ? this.filtersX : this.modList.getWidth()) - 5) {
                    guiGraphics.drawString(this.font, fullModCount.getVisualOrderText(), this.searchBoxX, showingModTextY + 6, -1, true);
                } else {
                    guiGraphics.drawString(this.font, this.computeModCountText(false, false).getVisualOrderText(), this.searchBoxX, showingModTextY, -1, true);
                    guiGraphics.drawString(this.font, this.computeLibraryCountText(false).getVisualOrderText(), this.searchBoxX, showingModTextY + 11, -1, true);
                }
            }
        }
        if (selectedEntry != null) {
            List<String> names;
            MutableComponent name;
            Mod mod = selectedEntry.getMod();
            int x = this.rightPaneX;
            if ("java".equals(mod.getId())) {
                DrawingUtil.drawRandomVersionBackground(mod, guiGraphics, x, rightPaneY, 32, 32);
            }
            Tuple<ResourceLocation, Dimension> iconProperties = selectedEntry.getIconTexture();
            int imageOffset = ((Dimension)iconProperties.getB()).width;
            int imageHeight = ((Dimension)iconProperties.getB()).height;
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, (ResourceLocation)iconProperties.getA(), x, rightPaneY, 0.0f, 0.0f, imageOffset, imageHeight, imageOffset, imageHeight);
            Objects.requireNonNull(this.font);
            int lineSpacing = 9 + 1;
            MutableComponent trimmedName = name = Component.literal((String)mod.getTranslatedName());
            int maxNameWidth = this.width - (x + (imageOffset += 4));
            if (this.font.width((FormattedText)name) > maxNameWidth) {
                FormattedText ellipsis = FormattedText.of((String)"...");
                trimmedName = FormattedText.composite((FormattedText[])new FormattedText[]{this.font.substrByWidth((FormattedText)name, maxNameWidth - this.font.width(ellipsis)), ellipsis});
            }
            guiGraphics.drawString(this.font, Language.getInstance().getVisualOrder((FormattedText)trimmedName), x + imageOffset, rightPaneY + 1, -1, true);
            if (mouseX > x + imageOffset && mouseY > rightPaneY + 1) {
                Objects.requireNonNull(this.font);
                if (mouseY < rightPaneY + 1 + 9 && mouseX < x + imageOffset + this.font.width((FormattedText)trimmedName)) {
                    guiGraphics.setTooltipForNextFrame(ModMenuScreenTexts.modIdTooltip(mod.getId()), mouseX, mouseY);
                }
            }
            if (this.init || this.modBadgeRenderer == null || this.modBadgeRenderer.getMod() != mod) {
                this.modBadgeRenderer = new ModBadgeRenderer(x + imageOffset + this.minecraft.font.width((FormattedText)trimmedName) + 2, rightPaneY, this.width - 28, selectedEntry.mod, this);
                this.init = false;
            }
            if (!((Boolean)ModMenu.getConfig().HIDE_BADGES.get()).booleanValue()) {
                this.modBadgeRenderer.draw(guiGraphics);
            }
            if (mod.isReal()) {
                guiGraphics.drawString(this.font, mod.getPrefixedVersion(), x + imageOffset, rightPaneY + 2 + lineSpacing, -5592406, true);
            }
            if (!(names = mod.getAuthors()).isEmpty()) {
                String authors = names.size() > 1 ? Joiner.on((String)", ").join(names) : names.getFirst();
                DrawingUtil.drawWrappedString(guiGraphics, I18n.get((String)"modmenu.authorPrefix", (Object[])new Object[]{authors}), x + imageOffset, rightPaneY + 2 + lineSpacing * 2, this.paneWidth - imageOffset - 4, 1, 0x808080);
            }
        }
    }

    private Component computeModCountText(boolean includeLibs, boolean onInit) {
        int[] rootMods = this.formatModCount(ModMenu.ROOT_MODS.values().stream().filter(mod -> !mod.isHidden() && !mod.getBadges().contains(ModBadge.LIBRARY)).map(Mod::getId).collect(Collectors.toSet()), onInit);
        if (includeLibs && ((Boolean)ModMenu.getConfig().SHOW_LIBRARIES.get()).booleanValue() && !onInit) {
            int[] rootLibs = this.formatModCount(ModMenu.ROOT_MODS.values().stream().filter(mod -> !mod.isHidden() && mod.getBadges().contains(ModBadge.LIBRARY)).map(Mod::getId).collect(Collectors.toSet()), false);
            return TranslationUtil.translateNumeric("modmenu.showingModsLibraries", rootMods, rootLibs);
        }
        return TranslationUtil.translateNumeric("modmenu.showingMods", new int[][]{rootMods});
    }

    private Component computeLibraryCountText(boolean onInit) {
        if (((Boolean)ModMenu.getConfig().SHOW_LIBRARIES.get()).booleanValue() && !onInit) {
            int[] rootLibs = this.formatModCount(ModMenu.ROOT_MODS.values().stream().filter(mod -> !mod.isHidden() && mod.getBadges().contains(ModBadge.LIBRARY)).map(Mod::getId).collect(Collectors.toSet()), false);
            return TranslationUtil.translateNumeric("modmenu.showingLibraries", new int[][]{rootLibs});
        }
        return Component.empty();
    }

    private int[] formatModCount(Set<String> set, boolean allVisible) {
        int total;
        int visible = this.modList.getDisplayedCountFor(set);
        if (visible == (total = set.size()) || allVisible) {
            return new int[]{total};
        }
        return new int[]{visible, total};
    }

    public void onClose() {
        this.modList.close();
        this.minecraft.setScreen(this.previousScreen);
    }

    private void setFilterOptionsShown(boolean filterOptionsShown) {
        this.filterOptionsShown = filterOptionsShown;
        this.sortingButton.visible = filterOptionsShown;
        this.librariesButton.visible = filterOptionsShown;
    }

    public ModListEntry getSelectedEntry() {
        return this.selected;
    }

    public void updateSelectedEntry(ModListEntry entry) {
        boolean isMinecraft;
        if (entry == null) {
            return;
        }
        this.selected = entry;
        String modId = this.selected.getMod().getId();
        this.descriptionListWidget.updateSelectedMod(this.selected.getMod());
        if (this.configureButton != null) {
            this.configureButton.active = this.getModHasConfigScreen(this.selected.mod.getContainer());
            boolean bl = this.configureButton.visible = this.selected != null && this.getModHasConfigScreen(this.selected.mod.getContainer()) || this.modScreenErrors.containsKey(modId);
            if (this.modScreenErrors.containsKey(modId)) {
                Throwable e = this.modScreenErrors.get(modId);
                this.configureButton.setTooltip(Tooltip.create((Component)ModMenuScreenTexts.configureError(modId, e)));
            } else {
                this.configureButton.setTooltip(Tooltip.create((Component)ModMenuScreenTexts.CONFIGURE));
            }
        }
        this.websiteButton.setMessage((isMinecraft = modId.equals("minecraft")) ? SEND_FEEDBACK_TEXT : ModMenuScreenTexts.WEBSITE);
        this.issuesButton.setMessage(isMinecraft ? REPORT_BUGS_TEXT : ModMenuScreenTexts.ISSUES);
        this.websiteButton.visible = true;
        this.websiteButton.active = isMinecraft || this.selected.getMod().getWebsite() != null;
        this.issuesButton.visible = true;
        this.issuesButton.active = isMinecraft || this.selected.getMod().getIssueTracker() != null;
    }

    public double getScrollPercent() {
        return this.scrollPercent;
    }

    public void updateScrollPercent(double scrollPercent) {
        this.scrollPercent = scrollPercent;
    }

    public String getSearchInput() {
        return this.searchBox.getValue();
    }

    private boolean updateFiltersX(boolean onInit) {
        if (this.filtersWidth + this.font.width((FormattedText)this.computeModCountText(true, onInit)) + 20 >= this.searchRowWidth && (this.filtersWidth + this.font.width((FormattedText)this.computeModCountText(false, onInit)) + 20 >= this.searchRowWidth || this.filtersWidth + this.font.width((FormattedText)this.computeLibraryCountText(onInit)) + 20 >= this.searchRowWidth)) {
            this.filtersX = this.paneWidth / 2 - this.filtersWidth / 2;
            return !this.filterOptionsShown;
        }
        this.filtersX = this.searchRowWidth - this.filtersWidth + 1;
        return true;
    }

    public void onFilesDrop(List<Path> paths) {
        Path modsDirectory = FMLPaths.MODSDIR.get();
        List<Path> mods = paths.stream().filter(ModsScreen::isValidMod).toList();
        if (mods.isEmpty()) {
            return;
        }
        String modList = mods.stream().map(Path::getFileName).map(Path::toString).collect(Collectors.joining(", "));
        this.minecraft.setScreen((Screen)new ConfirmScreen(value -> {
            if (value) {
                boolean allSuccessful = true;
                for (Path path : mods) {
                    try {
                        Files.copy(path, modsDirectory.resolve(path.getFileName()), new CopyOption[0]);
                    }
                    catch (IOException e) {
                        LOGGER.warn("Failed to copy mod from {} to {}", (Object)path, (Object)modsDirectory.resolve(path.getFileName()));
                        SystemToast.onPackCopyFailure((Minecraft)this.minecraft, (String)path.toString());
                        allSuccessful = false;
                        break;
                    }
                }
                if (allSuccessful) {
                    SystemToast.add((ToastManager)this.minecraft.getToastManager(), (SystemToast.SystemToastId)SystemToast.SystemToastId.PERIODIC_NOTIFICATION, (Component)ModMenuScreenTexts.DROP_SUCCESSFUL_LINE_1, (Component)ModMenuScreenTexts.DROP_SUCCESSFUL_LINE_2);
                }
            }
            this.minecraft.setScreen((Screen)this);
        }, ModMenuScreenTexts.DROP_CONFIRM, (Component)Component.literal((String)modList)));
    }

    private static boolean isFabricMod(Path mod) {
        boolean bl;
        JarFile jarFile = new JarFile(mod.toFile());
        try {
            bl = jarFile.getEntry("fabric.mod.json") != null;
        }
        catch (Throwable throwable) {
            try {
                try {
                    jarFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | UnsupportedOperationException e) {
                return false;
            }
        }
        jarFile.close();
        return bl;
    }

    private static boolean isValidMod(Path mod) {
        return ModsScreen.isFabricMod(mod) || ModsScreen.isNeoforgeMod(mod);
    }

    private static boolean isNeoforgeMod(Path mod) {
        boolean bl;
        JarFile jarFile = new JarFile(mod.toFile());
        try {
            bl = jarFile.getEntry("META-INF/neoforge.mods.toml") != null;
        }
        catch (Throwable throwable) {
            try {
                try {
                    jarFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | UnsupportedOperationException e) {
                return false;
            }
        }
        jarFile.close();
        return bl;
    }

    public boolean getModHasConfigScreen(Optional<ModContainer> containerOptional) {
        if (containerOptional.isEmpty()) {
            return false;
        }
        ModContainer container = containerOptional.get();
        if (this.modScreenErrors.containsKey(container.getModId())) {
            return false;
        }
        return this.modHasConfigScreen.computeIfAbsent(container, ModMenu::hasConfigScreen);
    }

    public void safelyOpenConfigScreen(ModContainer modId) {
        try {
            Screen screen = ModMenu.getConfigScreen(modId, this);
            if (screen != null) {
                this.minecraft.setScreen(screen);
            }
        }
        catch (NoClassDefFoundError e) {
            LOGGER.warn("The '" + String.valueOf(modId) + "' mod config screen is not available because " + e.getLocalizedMessage() + " is missing.");
            this.modScreenErrors.put(modId.getModId(), e);
        }
        catch (Throwable e) {
            LOGGER.error("Error from mod '" + String.valueOf(modId) + "'", e);
            this.modScreenErrors.put(modId.getModId(), e);
        }
    }
}

