/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.modmenu.gui.widget;

import com.terraformersmc.modmenu.ModMenu;
import com.terraformersmc.modmenu.gui.ModsScreen;
import com.terraformersmc.modmenu.gui.widget.UpdateAvailableBadge;
import com.terraformersmc.modmenu.util.mod.Mod;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.CreditsAndAttributionScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;

public class DescriptionListWidget
extends AbstractSelectionList<DescriptionEntry> {
    private static final Component HAS_UPDATE_TEXT = Component.translatable((String)"modmenu.hasUpdate");
    private static final Component EXPERIMENTAL_TEXT = Component.translatable((String)"modmenu.experimental").withStyle(ChatFormatting.GOLD);
    private static final Component DOWNLOAD_TEXT = Component.translatable((String)"modmenu.downloadLink").withStyle(ChatFormatting.BLUE).withStyle(ChatFormatting.UNDERLINE);
    private static final Component CHILD_HAS_UPDATE_TEXT = Component.translatable((String)"modmenu.childHasUpdate");
    private static final Component LINKS_TEXT = Component.translatable((String)"modmenu.links");
    private static final Component SOURCE_TEXT = Component.translatable((String)"modmenu.source").withStyle(ChatFormatting.BLUE).withStyle(ChatFormatting.UNDERLINE);
    private static final Component LICENSE_TEXT = Component.translatable((String)"modmenu.license");
    private static final Component VIEW_CREDITS_TEXT = Component.translatable((String)"modmenu.viewCredits").withStyle(ChatFormatting.BLUE).withStyle(ChatFormatting.UNDERLINE);
    private static final Component CREDITS_TEXT = Component.translatable((String)"modmenu.credits");
    private final ModsScreen parent;
    private final Font textRenderer;
    private Mod selectedMod = null;

    public DescriptionListWidget(Minecraft client, int width, int height, int y, int itemHeight, DescriptionListWidget copyFrom, ModsScreen parent) {
        super(client, width, height, y, itemHeight);
        this.parent = parent;
        this.textRenderer = client.font;
        if (copyFrom != null) {
            this.updateSelectedMod(copyFrom.selectedMod);
            this.setScrollAmount(copyFrom.scrollAmount());
        }
        if (parent.getSelectedEntry() != null) {
            this.updateSelectedMod(parent.getSelectedEntry().getMod());
        }
    }

    public DescriptionEntry getSelected() {
        return null;
    }

    public int getRowWidth() {
        return this.width - 10;
    }

    protected int scrollBarX() {
        return this.width - 6 + this.getX();
    }

    public void updateWidgetNarration(NarrationElementOutput builder) {
        if (this.selectedMod != null) {
            builder.add(NarratedElementType.TITLE, this.selectedMod.getTranslatedName() + " " + this.selectedMod.getPrefixedVersion());
        }
    }

    private void rebuildUI() {
        block17: {
            SortedMap<String, Set<String>> credits;
            Mod mod;
            int wrapWidth;
            DescriptionEntry emptyEntry;
            block18: {
                if (this.selectedMod == null) {
                    return;
                }
                emptyEntry = new DescriptionEntry(FormattedCharSequence.EMPTY);
                wrapWidth = this.getRowWidth() - 5;
                mod = this.selectedMod;
                Component description = mod.getFormattedDescription();
                if (!description.getString().isEmpty()) {
                    for (FormattedCharSequence line : this.textRenderer.split((FormattedText)description, wrapWidth)) {
                        this.addEntry((AbstractSelectionList.Entry)new DescriptionEntry(line));
                    }
                }
                Map<String, String> links = mod.getLinks();
                String sourceLink = mod.getSource();
                if (!(links.isEmpty() && sourceLink == null || ((Boolean)ModMenu.getConfig().HIDE_MOD_LINKS.get()).booleanValue())) {
                    this.addEntry((AbstractSelectionList.Entry)emptyEntry);
                    for (Object line : this.textRenderer.split((FormattedText)LINKS_TEXT, wrapWidth)) {
                        this.addEntry((AbstractSelectionList.Entry)new DescriptionEntry((FormattedCharSequence)line));
                    }
                    if (sourceLink != null) {
                        int indent = 8;
                        for (Object line : this.textRenderer.split((FormattedText)SOURCE_TEXT, wrapWidth - 16)) {
                            this.addEntry((AbstractSelectionList.Entry)new LinkEntry((FormattedCharSequence)line, sourceLink, indent));
                            indent = 16;
                        }
                    }
                    links.forEach((key, value) -> {
                        int indent = 8;
                        for (FormattedCharSequence line : this.textRenderer.split((FormattedText)Component.translatable((String)key).withStyle(ChatFormatting.BLUE).withStyle(ChatFormatting.UNDERLINE), wrapWidth - 16)) {
                            this.addEntry((AbstractSelectionList.Entry)new LinkEntry(line, (String)value, indent));
                            indent = 16;
                        }
                    });
                }
                Set<String> licenses = mod.getLicense();
                if (!((Boolean)ModMenu.getConfig().HIDE_MOD_LICENSE.get()).booleanValue() && !licenses.isEmpty()) {
                    this.addEntry((AbstractSelectionList.Entry)emptyEntry);
                    for (Object line : this.textRenderer.split((FormattedText)LICENSE_TEXT, wrapWidth)) {
                        this.addEntry((AbstractSelectionList.Entry)new DescriptionEntry((FormattedCharSequence)line));
                    }
                    for (String license : licenses) {
                        int indent = 8;
                        for (FormattedCharSequence line : this.textRenderer.split((FormattedText)Component.literal((String)license), wrapWidth - 16)) {
                            this.addEntry((AbstractSelectionList.Entry)new DescriptionEntry(line, indent));
                            indent = 16;
                        }
                    }
                }
                if (((Boolean)ModMenu.getConfig().HIDE_MOD_CREDITS.get()).booleanValue()) break block17;
                if (!"minecraft".equals(mod.getId())) break block18;
                this.addEntry((AbstractSelectionList.Entry)emptyEntry);
                for (Object line : this.textRenderer.split((FormattedText)VIEW_CREDITS_TEXT, wrapWidth)) {
                    this.addEntry((AbstractSelectionList.Entry)new MojangCreditsEntry((FormattedCharSequence)line));
                }
                break block17;
            }
            if ("java".equals(mod.getId()) || (credits = mod.getCredits()).isEmpty()) break block17;
            this.addEntry((AbstractSelectionList.Entry)emptyEntry);
            for (FormattedCharSequence line : this.textRenderer.split((FormattedText)CREDITS_TEXT, wrapWidth)) {
                this.addEntry((AbstractSelectionList.Entry)new DescriptionEntry(line));
            }
            Iterator<Map.Entry<String, Set<String>>> iterator = credits.entrySet().iterator();
            while (iterator.hasNext()) {
                int indent = 8;
                Map.Entry<String, Set<String>> role = iterator.next();
                String roleName = role.getKey();
                for (FormattedCharSequence line : this.textRenderer.split((FormattedText)this.creditsRoleText(roleName), wrapWidth - 16)) {
                    this.addEntry((AbstractSelectionList.Entry)new DescriptionEntry(line, indent));
                    indent = 16;
                }
                for (String contributor : role.getValue()) {
                    indent = 16;
                    for (FormattedCharSequence line : this.textRenderer.split((FormattedText)Component.literal((String)contributor), wrapWidth - 24)) {
                        this.addEntry((AbstractSelectionList.Entry)new DescriptionEntry(line, indent));
                        indent = 24;
                    }
                }
                if (!iterator.hasNext()) continue;
                this.addEntry((AbstractSelectionList.Entry)emptyEntry);
            }
        }
    }

    public void updateSelectedMod(Mod mod) {
        this.selectedMod = mod;
        this.clearEntries();
        this.setScrollAmount(-1.7976931348623157E308);
        this.rebuildUI();
    }

    public void renderListItems(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        this.enableScissor(guiGraphics);
        super.renderListItems(guiGraphics, mouseX, mouseY, delta);
        guiGraphics.disableScissor();
    }

    private Component creditsRoleText(String roleName) {
        String translationKey = roleName.replaceAll("[ -]", "_").toLowerCase();
        Object fallback = roleName.endsWith("r") ? roleName + "s" : roleName;
        return Component.translatableWithFallback((String)("modmenu.credits.role." + translationKey), (String)fallback).append((Component)Component.literal((String)":"));
    }

    protected class DescriptionEntry
    extends ContainerObjectSelectionList.Entry<DescriptionEntry> {
        protected FormattedCharSequence text;
        protected int indent;
        public boolean updateTextEntry = false;

        public DescriptionEntry(FormattedCharSequence text, int indent) {
            this.text = text;
            this.indent = indent;
        }

        public DescriptionEntry(FormattedCharSequence text) {
            this(text, 0);
        }

        public DescriptionEntry setUpdateTextEntry() {
            this.updateTextEntry = true;
            return this;
        }

        public void renderContent(GuiGraphics guiGraphics, int mouseX, int mouseY, boolean isSelected, float delta) {
            int x = this.getX();
            int y = this.getContentY();
            if (this.updateTextEntry) {
                UpdateAvailableBadge.renderBadge(guiGraphics, x + this.indent, y);
                x += 11;
            }
            guiGraphics.drawString(DescriptionListWidget.this.textRenderer, this.text, x + this.indent, y, -5592406);
        }

        public boolean isMouseOver(double mouseX, double mouseY) {
            double relativeX;
            if (!super.isMouseOver(mouseX, mouseY)) {
                return false;
            }
            int width = DescriptionListWidget.this.textRenderer.width(this.text);
            if (this.updateTextEntry) {
                width += 11;
            }
            return (relativeX = mouseX - (double)DescriptionListWidget.this.getRowLeft() - (double)this.indent) >= 0.0 && relativeX < (double)width;
        }

        public List<? extends GuiEventListener> children() {
            return Collections.emptyList();
        }

        public List<? extends NarratableEntry> narratables() {
            return Collections.emptyList();
        }
    }

    protected class LinkEntry
    extends DescriptionEntry {
        private final String link;

        public LinkEntry(FormattedCharSequence text, String link, int indent) {
            super(text, indent);
            this.link = link;
        }

        public LinkEntry(FormattedCharSequence text, String link) {
            this(text, link, 0);
        }

        public boolean mouseClicked(MouseButtonEvent event, boolean isDoubleClick) {
            if (this.isMouseOver(event.x(), event.y())) {
                DescriptionListWidget.this.minecraft.setScreen((Screen)new ConfirmLinkScreen(open -> {
                    if (open) {
                        Util.getPlatform().openUri(this.link);
                    }
                    DescriptionListWidget.this.minecraft.setScreen((Screen)DescriptionListWidget.this.parent);
                }, this.link, false));
            }
            return super.mouseClicked(event, isDoubleClick);
        }
    }

    protected class MojangCreditsEntry
    extends DescriptionEntry {
        public MojangCreditsEntry(FormattedCharSequence text) {
            super(text);
        }

        public boolean mouseClicked(MouseButtonEvent event, boolean isDoubleClick) {
            if (this.isMouseOver(event.x(), event.y())) {
                DescriptionListWidget.this.minecraft.setScreen((Screen)new MinecraftCredits(this));
            }
            return super.mouseClicked(event, isDoubleClick);
        }

        class MinecraftCredits
        extends CreditsAndAttributionScreen {
            public MinecraftCredits(MojangCreditsEntry this$1) {
                super((Screen)this$1.DescriptionListWidget.this.parent);
            }
        }
    }
}

