/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.modmenu.gui.widget;

import com.terraformersmc.modmenu.ModMenu;
import com.terraformersmc.modmenu.config.BetterModListConfig;
import com.terraformersmc.modmenu.gui.ModsScreen;
import com.terraformersmc.modmenu.gui.widget.entries.ChildEntry;
import com.terraformersmc.modmenu.gui.widget.entries.ChildParentEntry;
import com.terraformersmc.modmenu.gui.widget.entries.IndependentEntry;
import com.terraformersmc.modmenu.gui.widget.entries.ModListEntry;
import com.terraformersmc.modmenu.gui.widget.entries.ParentEntry;
import com.terraformersmc.modmenu.util.mod.Mod;
import com.terraformersmc.modmenu.util.mod.ModBadge;
import com.terraformersmc.modmenu.util.mod.ModSearch;
import com.terraformersmc.modmenu.util.mod.neoforge.NeoforgeIconHandler;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public class ModListWidget
extends ObjectSelectionList<ModListEntry>
implements AutoCloseable {
    public static final boolean DEBUG = Boolean.getBoolean("modmenu.debug");
    private final ModsScreen parent;
    private List<Mod> mods = null;
    private final Set<Mod> addedMods = new HashSet<Mod>();
    private String selectedModId = null;
    private boolean scrolling;
    private final NeoforgeIconHandler iconHandler = new NeoforgeIconHandler();
    private Double restoreScrollY = null;

    public ModListWidget(Minecraft client, int width, int height, int y, int itemHeight, ModListWidget list, ModsScreen parent) {
        super(client, width, height, y, itemHeight);
        this.parent = parent;
        if (list != null) {
            this.mods = list.mods;
            this.restoreScrollY = list.scrollAmount();
        }
    }

    public void setScrollAmount(double amount) {
        super.setScrollAmount(amount);
        int denominator = Math.max(0, this.contentHeight() - (this.getBottom() - this.getY() - 4));
        if (denominator == 0) {
            this.parent.updateScrollPercent(0.0);
        } else {
            this.parent.updateScrollPercent(this.scrollAmount() / (double)Math.max(0, this.contentHeight() - (this.getBottom() - this.getY() - 4)));
        }
    }

    public boolean isFocused() {
        return this.parent.getFocused() == this;
    }

    public void select(ModListEntry entry) {
        this.setSelected(entry);
        if (entry != null) {
            Mod mod = entry.getMod();
            this.minecraft.getNarrator().saySystemNow((Component)Component.translatable((String)"narrator.select", (Object[])new Object[]{mod.getTranslatedName()}));
        }
    }

    public void setSelected(ModListEntry entry) {
        super.setSelected((AbstractSelectionList.Entry)entry);
        this.selectedModId = entry == null ? null : entry.getMod().getId();
        this.parent.updateSelectedEntry((ModListEntry)this.getSelected());
    }

    protected boolean isSelectedItem(int index) {
        ModListEntry selected = (ModListEntry)this.getSelected();
        ModListEntry entry = this.getEntry(index);
        return selected != null && entry != null && selected.getMod().getId().equals(entry.getMod().getId());
    }

    public int addEntry(ModListEntry entry) {
        if (this.addedMods.contains(entry.mod)) {
            return 0;
        }
        this.addedMods.add(entry.mod);
        int i = super.addEntry((AbstractSelectionList.Entry)entry);
        if (entry.getMod().getId().equals(this.selectedModId)) {
            this.setSelected(entry);
        }
        return i;
    }

    @Nullable
    public ModListEntry getEntry(int index) {
        if (this.children().size() > index) {
            return (ModListEntry)((Object)this.children().get(index));
        }
        return null;
    }

    protected void removeEntry(ModListEntry entry) {
        this.addedMods.remove(entry.mod);
        super.removeEntry((AbstractSelectionList.Entry)entry);
    }

    public void clearEntries() {
        this.setSelected((ModListEntry)null);
        this.addedMods.clear();
        super.clearEntries();
    }

    protected void remove(int index) {
        ModListEntry entry = (ModListEntry)((Object)this.children().get(index));
        this.addedMods.remove(entry.mod);
        super.removeEntry((AbstractSelectionList.Entry)entry);
    }

    public void finalizeInit() {
        this.reloadFilters();
        if (this.restoreScrollY != null) {
            this.setScrollAmount(this.restoreScrollY);
            this.restoreScrollY = null;
        }
    }

    public void reloadFilters() {
        this.filter(this.parent.getSearchInput(), true, false);
    }

    public void filter(String searchTerm, boolean refresh) {
        this.filter(searchTerm, refresh, true);
    }

    private boolean hasVisibleChildMods(Mod parent) {
        List children = ModMenu.PARENT_MAP.get((Object)parent);
        boolean hideLibraries = (Boolean)ModMenu.getConfig().SHOW_LIBRARIES.get() == false;
        return !children.stream().allMatch(child -> child.isHidden() || hideLibraries && child.getBadges().contains(ModBadge.LIBRARY));
    }

    private void filter(String searchTerm, boolean refresh, boolean search) {
        this.clearEntries();
        this.addedMods.clear();
        ArrayList mods = (ArrayList)((Object)ModMenu.MODS.values().stream().filter(mod -> {
            if (((Boolean)ModMenu.getConfig().CONFIG_MODE.get()).booleanValue()) {
                return !this.parent.getModHasConfigScreen(mod.getContainer());
            }
            return !mod.isHidden();
        }).collect(Collectors.toSet()));
        if (DEBUG) {
            mods = new ArrayList(mods);
        }
        if (this.mods == null || refresh) {
            this.mods = new ArrayList<Mod>();
            this.mods.addAll(mods);
            this.mods.sort(((BetterModListConfig.Sorting)((Object)ModMenu.getConfig().SORTING.get())).getComparator());
        }
        for (Mod mod2 : ModSearch.search(this.parent, searchTerm, this.mods)) {
            String modId = mod2.getId();
            if (mod2.getBadges().contains(ModBadge.LIBRARY) && !((Boolean)ModMenu.getConfig().SHOW_LIBRARIES.get()).booleanValue() || ModMenu.PARENT_MAP.values().contains(mod2)) continue;
            if (ModMenu.PARENT_MAP.keySet().contains(mod2) && this.hasVisibleChildMods(mod2)) {
                List children = ModMenu.PARENT_MAP.get((Object)mod2);
                children.sort(((BetterModListConfig.Sorting)((Object)ModMenu.getConfig().SORTING.get())).getComparator());
                ParentEntry parent = new ParentEntry(mod2, children, this);
                this.addEntry(parent);
                if (!this.parent.showModChildren.contains(modId)) continue;
                List<Mod> validChildren = ModSearch.search(this.parent, searchTerm, children);
                for (Mod child : validChildren) {
                    this.addChildMod(child, validChildren, parent, List.of(parent), searchTerm, 1);
                }
                continue;
            }
            this.addEntry(new IndependentEntry(mod2, this));
        }
        if (this.parent.getSelectedEntry() != null && !this.children().isEmpty() || this.getSelected() != null && ((ModListEntry)this.getSelected()).getMod() != this.parent.getSelectedEntry().getMod()) {
            for (ModListEntry entry : this.children()) {
                if (!entry.getMod().equals(this.parent.getSelectedEntry().getMod())) continue;
                this.setSelected(entry);
            }
        } else if (this.getSelected() == null && !this.children().isEmpty() && this.getEntry(0) != null) {
            this.setSelected(this.getEntry(0));
        }
        if (this.scrollAmount() > (double)Math.max(0, this.contentHeight() - (this.getBottom() - this.getY() - 4))) {
            this.setScrollAmount(Math.max(0, this.contentHeight() - (this.getBottom() - this.getY() - 4)));
        }
    }

    public void addChildMod(Mod child, List<Mod> validChildren, ParentEntry parent, List<ModListEntry> parents, String searchTerm, int parentCount) {
        if (ModMenu.PARENT_MAP.keySet().contains(child) && this.hasVisibleChildMods(child)) {
            List childChildren = ModMenu.PARENT_MAP.get((Object)child);
            childChildren.sort(((BetterModListConfig.Sorting)((Object)ModMenu.getConfig().SORTING.get())).getComparator());
            ChildParentEntry childParentEntry = new ChildParentEntry(child, parent, parents, childChildren, this, validChildren.indexOf(child) == validChildren.size() - 1);
            this.addEntry(childParentEntry);
            if (this.parent.showModChildren.contains(child.getId())) {
                List<Mod> validChildChildren = ModSearch.search(this.parent, searchTerm, childChildren);
                for (Mod childChild : validChildChildren) {
                    ArrayList<ModListEntry> childParents = new ArrayList<ModListEntry>(parents);
                    childParents.add(childParentEntry);
                    this.addChildMod(childChild, validChildChildren, parent, childParents, searchTerm, parentCount + 1);
                }
            }
        } else {
            this.addEntry(new ChildEntry(child, parent, parents, this, validChildren.indexOf(child) == validChildren.size() - 1));
        }
    }

    protected void renderListItems(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        int entryLeft = this.getRowLeft();
        int entryWidth = this.getRowWidth();
        int entryHeight = this.defaultEntryHeight - 4;
        int x = this.getX();
        int y = this.getY();
        int yOffset = 2;
        int entryCount = this.getItemCount();
        for (int index = 0; index < entryCount; ++index) {
            ModListEntry entry;
            int entryTop = this.getRowTop(index) + 2;
            int entryBottom = this.getRowBottom(index);
            if (entryBottom < y || entryTop > this.getBottom() || (entry = this.getEntry(index)) == null) continue;
            if (this.isSelectedItem(index)) {
                int entryContentLeft = entryLeft + entry.getXOffset() - 2;
                int entryContentWidth = entryWidth - entry.getXOffset() + 4;
                this.renderSelection(guiGraphics, entryContentLeft, entryTop + yOffset, entryContentWidth, entryHeight, this.isFocused() ? -1 : -8355712, -16777216);
            }
            entry.setYOffset(yOffset);
            entry.renderContent(guiGraphics, mouseX, mouseY, this.isMouseOver(mouseX, mouseY) && Objects.equals((Object)this.getEntryAtPos(mouseX, mouseY), (Object)entry), delta);
        }
    }

    protected void renderSelection(GuiGraphics context, int x, int y, int width, int height, int borderColor, int fillColor) {
        context.fill(x, y - 2, x + width, y + height + 2, borderColor);
        context.fill(x + 1, y - 1, x + width - 1, y + height + 1, fillColor);
    }

    public void ensureVisible(ModListEntry entry) {
        int k;
        int i = this.getRowTop(this.children().indexOf((Object)entry));
        int j = i - this.getY() - 4 - this.defaultEntryHeight;
        if (j < 0) {
            this.setScrollAmount(this.scrollAmount() + (double)j);
        }
        if ((k = this.getBottom() - i - this.defaultEntryHeight * 2) < 0) {
            this.setScrollAmount(this.scrollAmount() - (double)k);
        }
    }

    public boolean keyPressed(KeyEvent event) {
        if (event.isUp() || event.isDown()) {
            return super.keyPressed(event);
        }
        if (this.getSelected() != null) {
            return ((ModListEntry)this.getSelected()).keyPressed(event);
        }
        return false;
    }

    public final ModListEntry getEntryAtPos(double x, double y) {
        int int_5 = Mth.floor((double)(y - (double)this.getY())) + (int)this.scrollAmount() - 4;
        int index = int_5 / this.defaultEntryHeight;
        return x < (double)this.scrollBarX() && x >= (double)this.getRowLeft() && x <= (double)(this.getRowLeft() + this.getRowWidth()) && index >= 0 && int_5 >= 0 && index < this.getItemCount() ? (ModListEntry)((Object)this.children().get(index)) : null;
    }

    protected int scrollBarX() {
        return this.width - 6;
    }

    public int getRowWidth() {
        return this.width - (Math.max(0, this.contentHeight() - (this.getBottom() - this.getY() - 4)) > 0 ? 18 : 12);
    }

    public int getRowLeft() {
        return this.getX() + 6;
    }

    public ModsScreen getParent() {
        return this.parent;
    }

    protected int contentHeight() {
        return super.contentHeight() + 4;
    }

    public int getDisplayedCountFor(Set<String> set) {
        int count = 0;
        for (ModListEntry c : this.children()) {
            if (!set.contains(c.getMod().getId())) continue;
            ++count;
        }
        return count;
    }

    @Override
    public void close() {
        this.iconHandler.close();
    }

    public NeoforgeIconHandler getNeoforgeIconHandler() {
        return this.iconHandler;
    }
}

