/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.modmenu.gui.widget.entries;

import com.terraformersmc.modmenu.gui.widget.ModListWidget;
import com.terraformersmc.modmenu.gui.widget.entries.ChildParentEntry;
import com.terraformersmc.modmenu.gui.widget.entries.ModListEntry;
import com.terraformersmc.modmenu.gui.widget.entries.ParentEntry;
import com.terraformersmc.modmenu.util.mod.Mod;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.input.KeyEvent;

public class ChildEntry
extends ModListEntry {
    protected final boolean bottomChild;
    protected final ParentEntry parent;
    protected final List<ModListEntry> parents;

    public ChildEntry(Mod mod, ParentEntry parent, List<ModListEntry> parents, ModListWidget list, boolean bottomChild) {
        super(mod, list);
        this.bottomChild = bottomChild;
        this.parent = parent;
        this.parents = parents;
    }

    @Override
    public void renderContent(GuiGraphics guiGraphics, int mouseX, int mouseY, boolean isSelected, float delta) {
        super.renderContent(guiGraphics, mouseX, mouseY, isSelected, delta);
        int x = this.getContentX() - 15;
        int y = this.getContentY() + this.getYOffset();
        int rowHeight = this.getContentHeight();
        int color = -6250336;
        for (int i = 1; i < this.parents.size(); ++i) {
            ModListEntry modListEntry = this.parents.get(i);
            if (!(modListEntry instanceof ChildParentEntry)) continue;
            ChildParentEntry childParent = (ChildParentEntry)modListEntry;
            if (childParent.bottomChild) continue;
            guiGraphics.fill(x + childParent.getXOffset(), y - 2, x + 1 + childParent.getXOffset(), y + rowHeight + 2, color);
        }
        guiGraphics.fill(x += this.getXOffset(), y - 2, x + 1, y + (this.bottomChild ? rowHeight / 2 : rowHeight + 2), color);
        guiGraphics.fill(x, y + rowHeight / 2, x + 7, y + rowHeight / 2 + 1, color);
    }

    public boolean keyPressed(KeyEvent event) {
        if (event.isLeft()) {
            this.list.setSelected(this.parent);
            this.list.ensureVisible(this.parent);
            return true;
        }
        return false;
    }

    @Override
    public int getXOffset() {
        return 13 * this.parents.size();
    }
}

