/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.modmenu.gui.widget.entries;

import com.terraformersmc.modmenu.ModMenu;
import com.terraformersmc.modmenu.gui.widget.ModListWidget;
import com.terraformersmc.modmenu.gui.widget.entries.ModListEntry;
import com.terraformersmc.modmenu.util.mod.Mod;
import com.terraformersmc.modmenu.util.mod.ModBadge;
import com.terraformersmc.modmenu.util.mod.ModSearch;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class ParentEntry
extends ModListEntry {
    private static final ResourceLocation PARENT_MOD_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"modmenu", (String)"textures/gui/parent_mod.png");
    protected List<Mod> children;
    protected ModListWidget list;
    protected boolean hoveringIcon = false;

    public ParentEntry(Mod parent, List<Mod> children, ModListWidget list) {
        super(parent, list);
        this.children = children;
        this.list = list;
    }

    @Override
    public void renderContent(GuiGraphics guiGraphics, int mouseX, int mouseY, boolean isSelected, float delta) {
        super.renderContent(guiGraphics, mouseX, mouseY, isSelected, delta);
        Font font = this.client.font;
        int x = this.getContentX() - 2;
        int y = this.getContentY() + this.getYOffset();
        Objects.requireNonNull(font);
        int childrenBadgeHeight = 9;
        Objects.requireNonNull(font);
        int childrenBadgeWidth = 9;
        int shownChildren = ModSearch.search(this.list.getParent(), this.list.getParent().getSearchInput(), this.getChildren()).size();
        int allChildren = this.children.stream().filter(child -> !child.isHidden() && ((Boolean)ModMenu.getConfig().SHOW_LIBRARIES.get() != false || !child.getBadges().contains(ModBadge.LIBRARY))).toList().size();
        MutableComponent str = shownChildren == allChildren ? Component.literal((String)String.valueOf(shownChildren)) : Component.literal((String)(shownChildren + "/" + allChildren));
        int childrenWidth = font.width((FormattedText)str) - 1;
        if (childrenBadgeWidth < childrenWidth + 4) {
            childrenBadgeWidth = childrenWidth + 4;
        }
        int iconSize = (Boolean)ModMenu.getConfig().COMPACT_LIST.get() != false ? 19 : 32;
        int childrenBadgeX = x + iconSize - childrenBadgeWidth;
        int childrenBadgeY = y + iconSize - childrenBadgeHeight;
        int childrenOutlineColor = -15698860;
        int childrenFillColor = -16172759;
        guiGraphics.fill(childrenBadgeX + 1, childrenBadgeY, childrenBadgeX + childrenBadgeWidth - 1, childrenBadgeY + 1, childrenOutlineColor);
        guiGraphics.fill(childrenBadgeX, childrenBadgeY + 1, childrenBadgeX + 1, childrenBadgeY + childrenBadgeHeight - 1, childrenOutlineColor);
        guiGraphics.fill(childrenBadgeX + childrenBadgeWidth - 1, childrenBadgeY + 1, childrenBadgeX + childrenBadgeWidth, childrenBadgeY + childrenBadgeHeight - 1, childrenOutlineColor);
        guiGraphics.fill(childrenBadgeX + 1, childrenBadgeY + 1, childrenBadgeX + childrenBadgeWidth - 1, childrenBadgeY + childrenBadgeHeight - 1, childrenFillColor);
        guiGraphics.fill(childrenBadgeX + 1, childrenBadgeY + childrenBadgeHeight - 1, childrenBadgeX + childrenBadgeWidth - 1, childrenBadgeY + childrenBadgeHeight, childrenOutlineColor);
        guiGraphics.drawString(font, str.getVisualOrderText(), (int)((float)childrenBadgeX + (float)childrenBadgeWidth / 2.0f - (float)childrenWidth / 2.0f), childrenBadgeY + 1, -3487030, false);
        boolean bl = this.hoveringIcon = mouseX >= x - 1 && mouseX <= x - 1 + iconSize && mouseY >= y - 1 && mouseY <= y - 1 + iconSize;
        if (this.isMouseOver(mouseX, mouseY)) {
            guiGraphics.fill(x, y, x + iconSize, y + iconSize, -1601138544);
            int xOffset = this.list.getParent().showModChildren.contains(this.getMod().getId()) ? iconSize : 0;
            int yOffset = this.hoveringIcon ? iconSize : 0;
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, PARENT_MOD_TEXTURE, x, y, (float)xOffset, (float)yOffset, iconSize + xOffset, iconSize + yOffset, (Boolean)ModMenu.getConfig().COMPACT_LIST.get() != false ? 152 : 256, (Boolean)ModMenu.getConfig().COMPACT_LIST.get() != false ? 152 : 256, -1);
        }
    }

    @Override
    public boolean mouseClicked(MouseButtonEvent click, boolean doubleClick) {
        int iconSize = (Boolean)ModMenu.getConfig().COMPACT_LIST.get() != false ? 19 : 32;
        boolean quickConfigure = (Boolean)ModMenu.getConfig().QUICK_CONFIGURE.get();
        if (click.x() - (double)this.list.getRowLeft() <= (double)iconSize) {
            this.toggleChildren();
            return true;
        }
        if (!quickConfigure && Util.getMillis() - this.sinceLastClick < 250L) {
            this.toggleChildren();
            return true;
        }
        return super.mouseClicked(click, doubleClick);
    }

    private void toggleChildren() {
        String id = this.getMod().getId();
        if (this.list.getParent().showModChildren.contains(id)) {
            this.list.getParent().showModChildren.remove(id);
        } else {
            this.list.getParent().showModChildren.add(id);
        }
        this.list.filter(this.list.getParent().getSearchInput(), false);
    }

    public boolean keyPressed(KeyEvent event) {
        String modId = this.getMod().getId();
        if (event.isSelection()) {
            if (this.list.getParent().showModChildren.contains(modId)) {
                this.list.getParent().showModChildren.remove(modId);
            } else {
                this.list.getParent().showModChildren.add(modId);
            }
            this.list.filter(this.list.getParent().getSearchInput(), false);
            return true;
        }
        if (event.isLeft()) {
            if (this.list.getParent().showModChildren.contains(modId)) {
                this.list.getParent().showModChildren.remove(modId);
                this.list.filter(this.list.getParent().getSearchInput(), false);
            }
            return true;
        }
        if (event.isRight()) {
            if (!this.list.getParent().showModChildren.contains(modId)) {
                this.list.getParent().showModChildren.add(modId);
                this.list.filter(this.list.getParent().getSearchInput(), false);
                return true;
            }
            return this.list.keyPressed(new KeyEvent(264, 0, 0));
        }
        return super.keyPressed(event);
    }

    public void setChildren(List<Mod> children) {
        this.children = children;
    }

    public void addChildren(List<Mod> children) {
        this.children.addAll(children);
    }

    public void addChildren(Mod ... children) {
        this.children.addAll(Arrays.asList(children));
    }

    public List<Mod> getChildren() {
        return this.children;
    }

    public boolean isMouseOver(double double_1, double double_2) {
        return Objects.equals((Object)this.list.getEntryAtPos(double_1, double_2), (Object)this);
    }
}

