/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.modmenu.util.mod;

import com.terraformersmc.modmenu.ModMenu;
import com.terraformersmc.modmenu.gui.ModsScreen;
import com.terraformersmc.modmenu.util.mod.Mod;
import com.terraformersmc.modmenu.util.mod.ModBadge;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.util.Tuple;

public class ModSearch {
    public static boolean validSearchQuery(String query) {
        return query != null && !query.isEmpty();
    }

    public static List<Mod> search(ModsScreen screen, String query, List<Mod> candidates) {
        if (!ModSearch.validSearchQuery(query)) {
            return candidates.stream().filter(child -> !child.isHidden() && ((Boolean)ModMenu.getConfig().SHOW_LIBRARIES.get() != false || !child.getBadges().contains(ModBadge.LIBRARY))).toList();
        }
        return candidates.stream().map(modContainer -> new Tuple(modContainer, (Object)ModSearch.passesFilters(screen, modContainer, query.toLowerCase(Locale.ROOT)))).filter(pair -> (Integer)pair.getB() > 0).sorted((a, b) -> (Integer)b.getB() - (Integer)a.getB()).map(Tuple::getA).collect(Collectors.toList());
    }

    private static int passesFilters(ModsScreen screen, Mod mod, String query) {
        String modId = mod.getId();
        String modName = mod.getName();
        String modTranslatedName = mod.getTranslatedName();
        String modDescription = mod.getDescription();
        String modSummary = mod.getSummary();
        boolean hasCustomBadge = false;
        for (Map.Entry<String, ModBadge> badgeEntry : ModBadge.CUSTOM_BADGES.entrySet()) {
            String searchTerms = badgeEntry.getValue().getComponent().getString();
            if (I18n.exists((String)("modmenu.searchTerms." + badgeEntry.getKey()))) {
                searchTerms = I18n.get((String)("modmenu.searchTerms." + badgeEntry.getKey()), (Object[])new Object[0]);
            }
            if (!searchTerms.contains(query) || !mod.getBadges().contains(badgeEntry.getValue())) continue;
            hasCustomBadge = true;
            break;
        }
        String library = I18n.get((String)"modmenu.searchTerms.library", (Object[])new Object[0]);
        String sinytra = I18n.get((String)"modmenu.searchTerms.sinytra", (Object[])new Object[0]);
        String modpack = I18n.get((String)"modmenu.searchTerms.modpack", (Object[])new Object[0]);
        String deprecated = I18n.get((String)"modmenu.searchTerms.deprecated", (Object[])new Object[0]);
        String clientside = I18n.get((String)"modmenu.searchTerms.clientside", (Object[])new Object[0]);
        String neoforge = I18n.get((String)"modmenu.searchTerms.neoforge", (Object[])new Object[0]);
        String configurable = I18n.get((String)"modmenu.searchTerms.configurable", (Object[])new Object[0]);
        if (mod.isHidden() || !((Boolean)ModMenu.getConfig().SHOW_LIBRARIES.get()).booleanValue() && mod.getBadges().contains(ModBadge.LIBRARY)) {
            return 0;
        }
        if (modName.toLowerCase(Locale.ROOT).contains(query) || modTranslatedName.toLowerCase(Locale.ROOT).contains(query) || modId.toLowerCase(Locale.ROOT).contains(query)) {
            return query.length() >= 3 ? 2 : 1;
        }
        if (modDescription.toLowerCase(Locale.ROOT).contains(query) || modSummary.toLowerCase(Locale.ROOT).contains(query) || ModSearch.authorMatches(mod, query) || library.contains(query) && mod.getBadges().contains(ModBadge.LIBRARY) || sinytra.contains(query) && mod.getBadges().contains(ModBadge.DEFAULT_BADGES.get("sinytra_fabric")) || modpack.contains(query) && mod.getBadges().contains(ModBadge.DEFAULT_BADGES.get("modpack")) || deprecated.contains(query) && mod.getBadges().contains(ModBadge.DEFAULT_BADGES.get("deprecated")) || deprecated.contains(query) && mod.getBadges().contains(ModBadge.DEFAULT_BADGES.get("deprecated")) || clientside.contains(query) && mod.getBadges().contains(ModBadge.DEFAULT_BADGES.get("client")) || neoforge.contains(query) && mod.getBadges().contains(ModBadge.DEFAULT_BADGES.get("sinytra_neoforge")) || hasCustomBadge || configurable.contains(query) && screen.getModHasConfigScreen(mod.getContainer())) {
            return 1;
        }
        if (ModMenu.PARENT_MAP.keySet().contains(mod)) {
            for (Mod child : ModMenu.PARENT_MAP.get((Object)mod)) {
                int result = ModSearch.passesFilters(screen, child, query);
                if (result <= 0) continue;
                return result;
            }
        }
        return 0;
    }

    private static boolean authorMatches(Mod mod, String query) {
        return mod.getAuthors().stream().map(s -> s.toLowerCase(Locale.ROOT)).anyMatch(s -> s.contains(query.toLowerCase(Locale.ROOT)));
    }
}

