/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.modmenu.util.mod.neoforge;

import com.mojang.blaze3d.platform.NativeImage;
import java.awt.Dimension;
import java.io.Closeable;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.neoforged.fml.ModContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NeoforgeIconHandler
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Mod Menu | NeoforgeIconHandler");
    private final Map<ResourceLocation, Tuple<DynamicTexture, Dimension>> modIconCache = new HashMap<ResourceLocation, Tuple<DynamicTexture, Dimension>>();
    public static final Map<String, Tuple<DynamicTexture, Dimension>> modResourceIconCache = new HashMap<String, Tuple<DynamicTexture, Dimension>>();

    public Tuple<DynamicTexture, Dimension> createIcon(ModContainer iconSource, String iconPath) {
        Tuple tuple;
        block11: {
            Tuple<DynamicTexture, Dimension> cachedIcon = this.getCachedModIcon(ResourceLocation.fromNamespaceAndPath((String)iconSource.getModId(), (String)iconPath));
            if (cachedIcon != null) {
                return cachedIcon;
            }
            InputStream inputStream = iconSource.getModInfo().getOwningFile().getFile().getContents().openFile(iconPath);
            try {
                NativeImage image = NativeImage.read((InputStream)Objects.requireNonNull(inputStream));
                Tuple tex = new Tuple((Object)new DynamicTexture(() -> ResourceLocation.fromNamespaceAndPath((String)"better_modlist", (String)iconPath).toString(), image), (Object)new Dimension(image.getWidth(), image.getHeight()));
                this.cacheModIcon(ResourceLocation.fromNamespaceAndPath((String)iconSource.getModId(), (String)iconPath), (Tuple<DynamicTexture, Dimension>)tex);
                tuple = tex;
                if (inputStream == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IllegalStateException e) {
                    return null;
                }
                catch (Throwable t) {
                    if (!(iconPath.equals("assets/" + iconSource.getModId() + "/icon.png") || iconPath.equals("icon.png") || iconPath.contains("_small.png"))) {
                        LOGGER.error("Invalid mod icon for icon source {}: {}", (Object)iconSource.getModId(), (Object)iconPath);
                    }
                    return null;
                }
            }
            inputStream.close();
        }
        return tuple;
    }

    @Override
    public void close() {
        for (Tuple<DynamicTexture, Dimension> tex : this.modIconCache.values()) {
            ((DynamicTexture)tex.getA()).close();
        }
    }

    Tuple<DynamicTexture, Dimension> getCachedModIcon(ResourceLocation path) {
        return this.modIconCache.get(path);
    }

    void cacheModIcon(ResourceLocation path, Tuple<DynamicTexture, Dimension> tex) {
        this.modIconCache.put(path, tex);
    }
}

