/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.modmenu.util.mod.neoforge;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.terraformersmc.modmenu.ModMenu;
import com.terraformersmc.modmenu.util.VersionUtil;
import com.terraformersmc.modmenu.util.mod.Mod;
import com.terraformersmc.modmenu.util.mod.ModBadge;
import com.terraformersmc.modmenu.util.mod.neoforge.NeoforgeIconHandler;
import java.awt.Dimension;
import java.lang.annotation.ElementType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.util.Tuple;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.javafmlmod.AutomaticEventSubscriber;
import net.neoforged.fml.loading.moddiscovery.ModFileInfo;
import net.neoforged.fml.loading.moddiscovery.ModInfo;
import net.neoforged.neoforgespi.language.IModInfo;
import net.neoforged.neoforgespi.language.ModFileScanData;
import net.neoforged.neoforgespi.locating.IModFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NeoforgeMod
implements Mod {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Mod Menu | NeoforgeMod");
    protected final ModContainer container;
    protected final IModInfo modInfo;
    protected final Mod.ModMenuData modMenuData;
    protected final Set<ModBadge> badges;
    protected final LinkedHashSet<String> badgeNames = new LinkedHashSet();
    protected final Map<String, String> links = new HashMap<String, String>();
    protected final List<String> contributors = new ArrayList<String>();
    protected final List<String> authors = new ArrayList<String>();
    protected boolean defaultIconWarning = true;
    protected boolean childHasUpdate = false;
    protected String sources;
    protected String issueTrackerUrl;
    protected String website;

    public NeoforgeMod(ModContainer modContainer) {
        this.container = modContainer;
        this.modInfo = modContainer.getModInfo();
        String id = this.modInfo.getModId();
        ModFileInfo modFileInfo = (ModFileInfo)this.modInfo.getOwningFile();
        this.issueTrackerUrl = this.modInfo.getConfig().getConfigElement(new String[]{"issueTrackerURL"}).orElse(null);
        if (this.issueTrackerUrl == null) {
            this.issueTrackerUrl = modFileInfo.getConfig().getConfigElement(new String[]{"issueTrackerURL"}).orElse(null);
        }
        this.website = this.modInfo.getConfig().getConfigElement(new String[]{"displayURL"}).orElse(null);
        Optional<String> parentId = Optional.empty();
        Mod.ModMenuData.DummyParentData parentData = null;
        Optional modMenuValue = modFileInfo.getConfigElement(new String[]{"modproperties", "modmenu"});
        if (modMenuValue.isPresent()) {
            ArrayList list;
            Object t2;
            String[] modMenuMap = (String[])modMenuValue.get();
            Optional parentValues = modFileInfo.getConfigElement(new String[]{"modproperties", "modmenu_parent"});
            if (parentValues.isPresent() && !((Map)parentValues.get()).isEmpty()) {
                LinkedHashSet<String> parentBadges = new LinkedHashSet<String>();
                Object v = ((Map)parentValues.get()).get("badges");
                if (v instanceof ArrayList) {
                    ArrayList list2 = (ArrayList)v;
                    parentBadges.addAll(list2);
                }
                try {
                    parentId = Optional.of((String)((Map)parentValues.get()).get("id"));
                    parentData = new Mod.ModMenuData.DummyParentData(parentId.orElseThrow(() -> new RuntimeException("Parent object lacks an id")), Optional.of((String)((Map)parentValues.get()).get("name")), Optional.of(String.valueOf(((Map)parentValues.get()).get("description")) + "\n" + String.valueOf(this.modInfo.getConfig().getConfigElement(new String[]{"credits"}).orElse(""))), Optional.of((String)((Map)parentValues.get()).get("icon")), parentBadges);
                    if (parentId.orElse("").equals(id)) {
                        parentId = Optional.empty();
                        parentData = null;
                        throw new RuntimeException("Mod declared itself as its own parent");
                    }
                }
                catch (Throwable t2) {
                    LOGGER.error("Error loading parent data from mod: " + id, t2);
                }
            }
            if ((t2 = modMenuMap.get("badges")) instanceof ArrayList) {
                list = (ArrayList)t2;
                this.badgeNames.addAll(list);
            }
            if ((t2 = modMenuMap.get("links")) instanceof ArrayList) {
                list = (ArrayList)t2;
                list.forEach(string -> {
                    String[] strings = string.toString().split("=");
                    this.links.put(strings[0], strings[1]);
                });
            }
            if ((t2 = modMenuMap.get("contributors")) instanceof ArrayList) {
                list = (ArrayList)t2;
                this.contributors.addAll(list);
            }
            this.sources = modMenuMap.getOrDefault("sources", "");
        }
        for (String string2 : this.modInfo.getConfig().getConfigElement(new String[]{"authors"}).orElse("").toString().split(", ")) {
            if (string2.isEmpty()) continue;
            if (string2.contains(",")) {
                this.authors.addAll(Arrays.stream(string2.split(",")).toList());
            }
            this.authors.add(string2);
        }
        this.modMenuData = new Mod.ModMenuData(parentId, parentData, id);
        if (id.startsWith("fabric")) {
            this.modMenuData.fillParentIfEmpty("fabric-api");
            this.badgeNames.add("library");
        }
        if (id.startsWith("connectorextras") || id.equals("modmenu")) {
            this.modMenuData.fillParentIfEmpty("connector");
            this.badgeNames.add("library");
        }
        this.badges = this.modMenuData.getBadges();
        IModFile parent = modFileInfo.getFile().getDiscoveryAttributes().parent();
        if (parent != null && parent.getType() != IModFile.Type.LIBRARY) {
            this.badgeNames.add("library");
        }
        boolean isClientSide = false;
        for (ModFileScanData.AnnotationData data : modFileInfo.getFile().getScanResult().getAnnotatedBy(net.neoforged.fml.common.Mod.class, ElementType.TYPE).toList()) {
            EnumSet dist = AutomaticEventSubscriber.getSides(data.annotationData().get("dist"));
            if (!dist.contains(Dist.DEDICATED_SERVER)) {
                isClientSide = true;
                continue;
            }
            isClientSide = false;
            break;
        }
        if ("minecraft".equals(id)) {
            this.badgeNames.add("minecraft");
        } else {
            if (ModMenu.HAS_SINYTRA) {
                this.badgeNames.addFirst("sinytra_neoforge");
            }
            if (isClientSide) {
                this.badgeNames.add("client");
            }
        }
    }

    @Override
    public Optional<ModContainer> getContainer() {
        return Optional.ofNullable(this.container);
    }

    @Override
    @NotNull
    public String getId() {
        return this.modInfo.getModId();
    }

    @Override
    @NotNull
    public String getName() {
        return this.modInfo.getDisplayName();
    }

    @Override
    @NotNull
    public Tuple<DynamicTexture, Dimension> getIcon(NeoforgeIconHandler iconHandler, int i, boolean isSmall) {
        String iconSourceId = this.getId();
        String iconResourceId = iconSourceId + (isSmall ? "_small" : "");
        if (NeoforgeIconHandler.modResourceIconCache.containsKey(iconResourceId)) {
            return NeoforgeIconHandler.modResourceIconCache.get(iconResourceId);
        }
        String iconPath = (String)((Object)this.modInfo.getLogoFile().orElse("assets/" + this.getId() + "/icon.png"));
        if (isSmall) {
            String catalogueIcon;
            iconPath = (Boolean)ModMenu.getConfig().USE_CATALOGUE_ICON.get() != false && (catalogueIcon = (String)((ModInfo)this.modInfo).getConfigElement(new String[]{"catalogueImageIcon"}).orElse(null)) != null ? catalogueIcon : iconPath.replace(".png", "_small.png");
        }
        if ("minecraft".equals(this.getId())) {
            iconSourceId = "better_modlist";
            iconPath = "assets/modmenu/minecraft_icon.png";
        } else if ("neoforge".equals(this.getId()) && isSmall) {
            iconSourceId = "better_modlist";
            iconPath = "assets/modmenu/neoforge.png";
        }
        String finalIconSourceId = iconSourceId;
        ModContainer iconSource = (ModContainer)ModList.get().getModContainerById(iconSourceId).orElseThrow(() -> new RuntimeException("Cannot get ModContainer for Neoforge mod with id " + finalIconSourceId));
        Tuple<DynamicTexture, Dimension> icon = iconHandler.createIcon(iconSource, iconPath);
        if (icon == null && !isSmall) {
            if (this.defaultIconWarning) {
                LOGGER.warn("Warning! Mod {} has a broken icon, loading default icon", (Object)this.modInfo.getModId());
                this.defaultIconWarning = false;
            }
            return iconHandler.createIcon((ModContainer)ModList.get().getModContainerById("better_modlist").orElseThrow(() -> new RuntimeException("Cannot get ModContainer for Neoforge mod with id modmenu")), "assets/modmenu/unknown_icon.png");
        }
        return icon;
    }

    @Override
    @NotNull
    public String getDescription() {
        return this.modInfo.getDescription();
    }

    @Override
    @NotNull
    public String getTranslatedDescription() {
        return Mod.super.getTranslatedDescription();
    }

    @Override
    @NotNull
    public String getVersion() {
        return this.modInfo.getVersion().toString();
    }

    @Override
    @NotNull
    public String getPrefixedVersion() {
        return VersionUtil.getPrefixedVersion(this.getVersion());
    }

    @Override
    @NotNull
    public List<String> getAuthors() {
        if (this.authors.isEmpty() && "minecraft".equals(this.getId())) {
            return Lists.newArrayList((Object[])new String[]{"Mojang Studios"});
        }
        return this.authors;
    }

    @Override
    @NotNull
    public Map<String, Collection<String>> getContributors() {
        LinkedHashMap<String, Collection<String>> contributors = new LinkedHashMap<String, Collection<String>>();
        for (String contributor : this.contributors) {
            contributors.put(contributor, List.of("Contributor"));
        }
        return contributors;
    }

    @Override
    @NotNull
    public SortedMap<String, Set<String>> getCredits() {
        TreeMap<String, Set<String>> credits = new TreeMap<String, Set<String>>();
        List<String> authors = this.getAuthors();
        Map<String, Collection<String>> contributors = this.getContributors();
        for (String string : authors) {
            contributors.put(string, List.of("Author"));
        }
        for (Map.Entry entry : contributors.entrySet()) {
            for (String role : (Collection)entry.getValue()) {
                credits.computeIfAbsent(role, key -> new LinkedHashSet());
                ((Set)credits.get(role)).add((String)entry.getKey());
            }
        }
        return credits;
    }

    @Override
    @NotNull
    public Set<ModBadge> getBadges() {
        return this.badges;
    }

    @Override
    @NotNull
    public Set<String> getBadgeNames() {
        return this.badgeNames;
    }

    @Override
    @Nullable
    public String getWebsite() {
        if ("minecraft".equals(this.getId())) {
            return "https://www.minecraft.net/";
        }
        return this.website;
    }

    @Override
    @Nullable
    public String getIssueTracker() {
        if ("minecraft".equals(this.getId())) {
            return "https://aka.ms/snapshotbugs?ref=game";
        }
        return this.issueTrackerUrl;
    }

    @Override
    @Nullable
    public String getSource() {
        return this.sources;
    }

    @Override
    @Nullable
    public String getParent() {
        return this.modMenuData.getParent().orElse(null);
    }

    @Override
    @NotNull
    public Set<String> getLicense() {
        if ("minecraft".equals(this.getId())) {
            return Sets.newHashSet((Object[])new String[]{"Minecraft EULA"});
        }
        return Sets.newHashSet((Object[])new String[]{this.modInfo.getOwningFile().getLicense()});
    }

    @Override
    @NotNull
    public Map<String, String> getLinks() {
        return this.links;
    }

    @Override
    public boolean isReal() {
        return true;
    }

    @Override
    public Mod.ModMenuData getModMenuData() {
        return this.modMenuData;
    }

    @Override
    public boolean getChildHasUpdate() {
        return this.childHasUpdate;
    }

    @Override
    public void setChildHasUpdate() {
        this.childHasUpdate = true;
    }

    @Override
    public boolean isHidden() {
        return ((List)ModMenu.getConfig().HIDDEN_MODS.get()).contains(this.getId());
    }
}

