/*
 * Decompiled with CFR 0.152.
 */
package com.chestlocklite;

import com.chestlocklite.commands.ChestLockCommand;
import com.chestlocklite.gui.LockGUI;
import com.chestlocklite.gui.PasswordInputGUI;
import com.chestlocklite.gui.TrustedPlayersGUI;
import com.chestlocklite.listeners.BlockPlaceListener;
import com.chestlocklite.listeners.ChestListener;
import com.chestlocklite.managers.ConfigManager;
import com.chestlocklite.managers.DatabaseManager;
import com.chestlocklite.managers.LockManager;
import com.chestlocklite.managers.PasswordCooldownManager;
import java.util.logging.Level;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ChestLockLitePlugin
extends JavaPlugin {
    private static ChestLockLitePlugin instance;
    private ConfigManager configManager;
    private DatabaseManager databaseManager;
    private LockManager lockManager;
    private PasswordCooldownManager passwordCooldownManager;
    private ChestListener chestListener;
    private LockGUI lockGUI;
    private PasswordInputGUI passwordInputGUI;
    private TrustedPlayersGUI trustedPlayersGUI;

    public void onEnable() {
        instance = this;
        this.saveDefaultConfig();
        this.configManager = new ConfigManager(this);
        try {
            this.databaseManager = new DatabaseManager(this);
            this.databaseManager.initialize();
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to initialize database", e);
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.lockManager = new LockManager(this);
        this.passwordCooldownManager = new PasswordCooldownManager(this);
        this.chestListener = new ChestListener(this);
        this.getServer().getPluginManager().registerEvents((Listener)this.chestListener, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new BlockPlaceListener(this), (Plugin)this);
        this.lockGUI = new LockGUI(this);
        this.getServer().getPluginManager().registerEvents((Listener)this.lockGUI, (Plugin)this);
        this.passwordInputGUI = new PasswordInputGUI(this);
        this.getServer().getPluginManager().registerEvents((Listener)this.passwordInputGUI, (Plugin)this);
        this.trustedPlayersGUI = new TrustedPlayersGUI(this);
        this.getServer().getPluginManager().registerEvents((Listener)this.trustedPlayersGUI, (Plugin)this);
        ChestLockCommand commandHandler = new ChestLockCommand(this);
        this.getCommand("chestlock").setExecutor((CommandExecutor)commandHandler);
        this.getCommand("chestlock").setTabCompleter((TabCompleter)commandHandler);
        this.getLogger().info("ChestLockLite has been enabled!");
        this.getLogger().info("Database initialized successfully!");
    }

    public void onDisable() {
        if (this.databaseManager != null) {
            this.databaseManager.close();
        }
        this.getLogger().info("ChestLockLite has been disabled!");
    }

    public void reload() {
        this.reloadConfig();
        this.configManager = new ConfigManager(this);
        if (this.databaseManager != null) {
            this.databaseManager.close();
        }
        try {
            this.databaseManager = new DatabaseManager(this);
            this.databaseManager.initialize();
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to reload database", e);
        }
        this.lockManager = new LockManager(this);
        this.getLogger().info("ChestLockLite configuration reloaded!");
    }

    public static ChestLockLitePlugin getInstance() {
        return instance;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public DatabaseManager getDatabaseManager() {
        return this.databaseManager;
    }

    public LockManager getLockManager() {
        return this.lockManager;
    }

    public ChestListener getChestListener() {
        return this.chestListener;
    }

    public LockGUI getLockGUI() {
        return this.lockGUI;
    }

    public PasswordInputGUI getPasswordInputGUI() {
        return this.passwordInputGUI;
    }

    public PasswordCooldownManager getPasswordCooldownManager() {
        return this.passwordCooldownManager;
    }

    public TrustedPlayersGUI getTrustedPlayersGUI() {
        return this.trustedPlayersGUI;
    }
}

