/*
 * Decompiled with CFR 0.152.
 */
package com.chestlocklite.gui;

import com.chestlocklite.ChestLockLitePlugin;
import com.chestlocklite.managers.DatabaseManager;
import com.chestlocklite.utils.MessageUtils;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class LockGUI
implements Listener {
    private final ChestLockLitePlugin plugin;
    private final Map<UUID, Location> openGUIs = new HashMap<UUID, Location>();

    public LockGUI(ChestLockLitePlugin plugin) {
        this.plugin = plugin;
    }

    public void openGUI(Player player, Location chestLocation) {
        DatabaseManager.LockData lock = this.plugin.getLockManager().getLockInfo(chestLocation);
        Inventory gui = Bukkit.createInventory(null, (int)27, (String)MessageUtils.colorize("&6Chest Lock Menu"));
        boolean isLocked = lock != null;
        boolean isOwner = isLocked && lock.getOwnerUUID().equals(player.getUniqueId());
        boolean isAdmin = player.hasPermission("chestlocklite.admin");
        if (isLocked) {
            if (isOwner || isAdmin) {
                gui.setItem(11, this.createItem(Material.TRIPWIRE_HOOK, "&cUnlock Chest", Arrays.asList("&7Click to unlock this chest", "&7Only you can access it")));
            } else {
                gui.setItem(11, this.createItem(Material.BARRIER, "&cChest is Locked", Arrays.asList("&7Owner: &e" + lock.getOwnerName(), "&7You do not have access")));
            }
        } else {
            gui.setItem(11, this.createItem(Material.IRON_BLOCK, "&aLock Chest", Arrays.asList("&7Click to lock this chest", "&7Only you will be able to open it")));
        }
        if (isLocked && isOwner) {
            if (lock.hasPassword()) {
                gui.setItem(13, this.createItem(Material.ENDER_EYE, "&eRemove Password", Arrays.asList("&7Click to remove password", "&7Current: &aSet")));
            } else {
                gui.setItem(13, this.createItem(Material.ENDER_PEARL, "&eSet Password", Arrays.asList("&7Click to set a password", "&7Anyone with password can unlock")));
            }
        } else if (isLocked && !isOwner && lock.hasPassword()) {
            gui.setItem(13, this.createItem(Material.ENDER_EYE, "&eEnter Password", Arrays.asList("&7Click to enter password", "&7to unlock this chest")));
        } else if (!isLocked) {
            gui.setItem(13, this.createItem(Material.GRAY_DYE, "&7Password Protection", Arrays.asList("&7Lock the chest first", "&7to enable passwords")));
        }
        if (isLocked && isOwner) {
            try {
                int trustedCount = this.plugin.getDatabaseManager().getTrustedPlayers(chestLocation).size();
                gui.setItem(14, this.createItem(Material.PLAYER_HEAD, "&eTrusted Players &7(" + trustedCount + ")", Arrays.asList("&7Click to manage trusted players", "&7Trusted players can access this chest", "&7Current: &e" + trustedCount + " player(s)")));
            }
            catch (SQLException e) {
                this.plugin.getLogger().warning("Error loading trusted players count: " + e.getMessage());
                gui.setItem(14, this.createItem(Material.PLAYER_HEAD, "&eTrusted Players", Arrays.asList("&7Click to manage trusted players", "&7Trusted players can access this chest")));
            }
        } else if (isLocked && !isOwner) {
            try {
                boolean isTrusted = this.plugin.getDatabaseManager().isTrustedPlayer(chestLocation, player.getUniqueId());
                if (isTrusted) {
                    gui.setItem(14, this.createItem(Material.PLAYER_HEAD, "&aYou are Trusted", Arrays.asList("&7You have access to this chest", "&7Owner: &e" + lock.getOwnerName())));
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        gui.setItem(15, this.createItem(Material.BOOK, "&bChest Information", Arrays.asList("&7Click to view lock info")));
        if (isAdmin && isLocked && !isOwner) {
            gui.setItem(22, this.createItem(Material.COMMAND_BLOCK, "&cAdmin: Force Unlock", Arrays.asList("&7Click to force unlock", "&7this chest (Admin only)")));
        }
        gui.setItem(18, this.createItem(Material.BARRIER, "&cClose", Arrays.asList("&7Click to close this menu")));
        this.fillEmptySlots(gui);
        player.openInventory(gui);
        this.openGUIs.put(player.getUniqueId(), chestLocation);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        if (!event.getView().getTitle().equals(MessageUtils.colorize("&6Chest Lock Menu"))) {
            return;
        }
        event.setCancelled(true);
        if (!this.openGUIs.containsKey(player.getUniqueId())) {
            return;
        }
        Location chestLocation = this.openGUIs.get(player.getUniqueId());
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null || clicked.getType() == Material.AIR) {
            return;
        }
        Material clickedType = clicked.getType();
        if (clickedType == Material.BARRIER && event.getSlot() == 18) {
            player.closeInventory();
            return;
        }
        DatabaseManager.LockData lock = this.plugin.getLockManager().getLockInfo(chestLocation);
        boolean isLocked = lock != null;
        boolean isOwner = isLocked && lock.getOwnerUUID().equals(player.getUniqueId());
        boolean isAdmin = player.hasPermission("chestlocklite.admin");
        if (clickedType == Material.IRON_BLOCK && event.getSlot() == 11) {
            if (this.plugin.getLockManager().lockChest(chestLocation, player)) {
                player.sendMessage(MessageUtils.colorize(this.plugin.getConfigManager().getLockSuccessMessage()));
                this.refreshGUI(player, chestLocation);
            } else {
                player.sendMessage(MessageUtils.colorize(this.plugin.getConfigManager().getAlreadyLockedMessage()));
            }
            return;
        }
        if (clickedType == Material.TRIPWIRE_HOOK && event.getSlot() == 11) {
            if (isOwner || isAdmin) {
                if (this.plugin.getLockManager().unlockChest(chestLocation, player)) {
                    player.sendMessage(MessageUtils.colorize(this.plugin.getConfigManager().getUnlockSuccessMessage()));
                    this.refreshGUI(player, chestLocation);
                } else {
                    player.sendMessage(MessageUtils.colorize("&cFailed to unlock chest!"));
                }
            }
            return;
        }
        if (clickedType == Material.ENDER_PEARL && event.getSlot() == 13) {
            if (isOwner) {
                player.closeInventory();
                this.plugin.getPasswordInputGUI().openPasswordInput(player, chestLocation);
            }
            return;
        }
        if (clickedType == Material.ENDER_EYE && event.getSlot() == 13) {
            if (isOwner) {
                if (this.plugin.getLockManager().removePassword(chestLocation, player)) {
                    player.sendMessage(MessageUtils.colorize(this.plugin.getConfigManager().getPasswordRemovedMessage()));
                    this.refreshGUI(player, chestLocation);
                } else {
                    player.sendMessage(MessageUtils.colorize("&cFailed to remove password!"));
                }
            } else if (isLocked && lock.hasPassword()) {
                player.closeInventory();
                this.plugin.getPasswordInputGUI().openPasswordInput(player, chestLocation, false);
            }
            return;
        }
        if (clickedType == Material.PLAYER_HEAD && event.getSlot() == 14) {
            if (isOwner && isLocked) {
                player.closeInventory();
                this.plugin.getTrustedPlayersGUI().openTrustedPlayersGUI(player, chestLocation);
            }
            return;
        }
        if (clickedType == Material.BOOK && event.getSlot() == 15) {
            player.closeInventory();
            this.showInfo(player, chestLocation);
            return;
        }
        if (clickedType == Material.COMMAND_BLOCK && event.getSlot() == 22) {
            if (isAdmin && isLocked && !isOwner) {
                player.closeInventory();
                if (this.plugin.getLockManager().unlockChest(chestLocation, player)) {
                    player.sendMessage(MessageUtils.colorize("&a[Admin] Chest lock cleared!"));
                    this.plugin.getLogger().info("Admin " + player.getName() + " cleared lock at " + chestLocation.getWorld().getName() + " " + chestLocation.getBlockX() + "," + chestLocation.getBlockY() + "," + chestLocation.getBlockZ() + " (Owner: " + lock.getOwnerName() + ")");
                } else {
                    player.sendMessage(MessageUtils.colorize("&cFailed to clear chest lock!"));
                }
            }
            return;
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (event.getPlayer() instanceof Player) {
            this.openGUIs.remove(event.getPlayer().getUniqueId());
        }
    }

    private void showInfo(Player player, Location chestLocation) {
        DatabaseManager.LockData lock = this.plugin.getLockManager().getLockInfo(chestLocation);
        if (lock == null) {
            player.sendMessage(MessageUtils.colorize("&7This chest is &aunlocked&7."));
            return;
        }
        player.sendMessage(MessageUtils.colorize("&6=== Chest Lock Info ==="));
        player.sendMessage(MessageUtils.colorize("&eOwner: &f" + lock.getOwnerName()));
        if (lock.getOwnerUUID().equals(player.getUniqueId())) {
            player.sendMessage(MessageUtils.colorize("&7This is your chest."));
            if (lock.hasPassword()) {
                player.sendMessage(MessageUtils.colorize("&7Password: &aSet"));
            } else {
                player.sendMessage(MessageUtils.colorize("&7Password: &cNot set"));
            }
        } else if (lock.hasPassword()) {
            player.sendMessage(MessageUtils.colorize("&7Password Protected: &aYes"));
            player.sendMessage(MessageUtils.colorize("&7Use &e/cl password <password> &7to unlock"));
        } else {
            player.sendMessage(MessageUtils.colorize("&7Password Protected: &cNo"));
            player.sendMessage(MessageUtils.colorize("&cOnly the owner can open this chest."));
        }
    }

    private ItemStack createItem(Material material, String name, List<String> lore) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(MessageUtils.colorize(name));
            meta.setLore(lore.stream().map(MessageUtils::colorize).collect(Collectors.toList()));
            item.setItemMeta(meta);
        }
        return item;
    }

    private void refreshGUI(Player player, Location chestLocation) {
        if (!player.getOpenInventory().getTitle().equals(MessageUtils.colorize("&6Chest Lock Menu"))) {
            return;
        }
        DatabaseManager.LockData lock = this.plugin.getLockManager().getLockInfo(chestLocation);
        boolean isLocked = lock != null;
        boolean isOwner = isLocked && lock.getOwnerUUID().equals(player.getUniqueId());
        boolean isAdmin = player.hasPermission("chestlocklite.admin");
        Inventory gui = player.getOpenInventory().getTopInventory();
        if (isLocked) {
            if (isOwner || isAdmin) {
                gui.setItem(11, this.createItem(Material.TRIPWIRE_HOOK, "&cUnlock Chest", Arrays.asList("&7Click to unlock this chest", "&7Only you can access it")));
            } else {
                gui.setItem(11, this.createItem(Material.BARRIER, "&cChest is Locked", Arrays.asList("&7Owner: &e" + lock.getOwnerName(), "&7You do not have access")));
            }
        } else {
            gui.setItem(11, this.createItem(Material.IRON_BLOCK, "&aLock Chest", Arrays.asList("&7Click to lock this chest", "&7Only you will be able to open it")));
        }
        if (isLocked && isOwner) {
            if (lock.hasPassword()) {
                gui.setItem(13, this.createItem(Material.ENDER_EYE, "&eRemove Password", Arrays.asList("&7Click to remove password", "&7Current: &aSet")));
            } else {
                gui.setItem(13, this.createItem(Material.ENDER_PEARL, "&eSet Password", Arrays.asList("&7Click to set a password", "&7Anyone with password can unlock")));
            }
        } else if (isLocked && !isOwner && lock.hasPassword()) {
            gui.setItem(13, this.createItem(Material.ENDER_EYE, "&eEnter Password", Arrays.asList("&7Click to enter password", "&7to unlock this chest")));
        } else if (!isLocked) {
            gui.setItem(13, this.createItem(Material.GRAY_DYE, "&7Password Protection", Arrays.asList("&7Lock the chest first", "&7to enable passwords")));
        }
        if (isAdmin && isLocked && !isOwner) {
            gui.setItem(22, this.createItem(Material.COMMAND_BLOCK, "&cAdmin: Force Unlock", Arrays.asList("&7Click to force unlock", "&7this chest (Admin only)")));
        } else {
            gui.setItem(22, null);
            this.fillEmptySlots(gui);
        }
    }

    private void fillEmptySlots(Inventory inventory) {
        ItemStack filler = this.createItem(Material.GRAY_STAINED_GLASS_PANE, " ", Arrays.asList(new String[0]));
        for (int i = 0; i < inventory.getSize(); ++i) {
            if (inventory.getItem(i) != null) continue;
            inventory.setItem(i, filler);
        }
    }
}

