/*
 * Decompiled with CFR 0.152.
 */
package com.chestlocklite.managers;

import com.chestlocklite.ChestLockLitePlugin;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class PasswordCooldownManager {
    private final ChestLockLitePlugin plugin;
    private final Map<UUID, Long> passwordCooldowns = new HashMap<UUID, Long>();

    public PasswordCooldownManager(ChestLockLitePlugin plugin) {
        this.plugin = plugin;
    }

    public int checkCooldown(UUID playerId) {
        int cooldownSeconds;
        long lastAttempt;
        if (!this.passwordCooldowns.containsKey(playerId)) {
            return 0;
        }
        long currentTime = System.currentTimeMillis();
        long timeSinceLastAttempt = (currentTime - (lastAttempt = this.passwordCooldowns.get(playerId).longValue())) / 1000L;
        if (timeSinceLastAttempt < (long)(cooldownSeconds = this.plugin.getConfigManager().getPasswordCooldown())) {
            return (int)((long)cooldownSeconds - timeSinceLastAttempt);
        }
        return 0;
    }

    public void setCooldown(UUID playerId) {
        this.passwordCooldowns.put(playerId, System.currentTimeMillis());
    }

    public void clearCooldown(UUID playerId) {
        this.passwordCooldowns.remove(playerId);
    }
}

