/*
 * Decompiled with CFR 0.152.
 */
package com.chestlocklite.gui;

import com.chestlocklite.ChestLockLitePlugin;
import com.chestlocklite.managers.DatabaseManager;
import com.chestlocklite.utils.MessageUtils;
import com.chestlocklite.utils.PasswordHasher;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class PasswordInputGUI
implements Listener {
    private final ChestLockLitePlugin plugin;
    private final Map<UUID, PasswordInputData> passwordInputs = new HashMap<UUID, PasswordInputData>();
    private final Map<UUID, Long> passwordCooldowns = new HashMap<UUID, Long>();

    public PasswordInputGUI(ChestLockLitePlugin plugin) {
        this.plugin = plugin;
    }

    public void openPasswordInput(Player player, Location chestLocation) {
        this.openPasswordInput(player, chestLocation, true);
    }

    public void openPasswordInput(Player player, Location chestLocation, boolean isSettingPassword) {
        String title = isSettingPassword ? "&6Set Password" : "&6Enter Password";
        Inventory gui = Bukkit.createInventory(null, (int)54, (String)MessageUtils.colorize(title));
        this.passwordInputs.put(player.getUniqueId(), new PasswordInputData(chestLocation, isSettingPassword));
        this.updatePasswordDisplay(player, this.passwordInputs.get(player.getUniqueId()), gui);
        player.openInventory(gui);
    }

    private void updatePasswordDisplay(Player player, PasswordInputData data, Inventory gui) {
        String currentPassword = data.passwordBuilder.length() > 0 ? data.passwordBuilder.toString() : "(empty)";
        String titleText = data.isSettingPassword ? "Current Password" : "Enter Password";
        gui.setItem(4, this.createItem(Material.NAME_TAG, "&6&l" + titleText, Arrays.asList("&f&l" + currentPassword, "&7", data.isSettingPassword ? "&7Length: &e" + data.passwordBuilder.length() + " &7/ &e" + this.plugin.getConfigManager().getMaxPasswordLength() + "\n&7Min: &e" + this.plugin.getConfigManager().getMinPasswordLength() + " &7Max: &e" + this.plugin.getConfigManager().getMaxPasswordLength() + " characters" + (data.passwordBuilder.length() >= this.plugin.getConfigManager().getMinPasswordLength() && data.passwordBuilder.length() <= this.plugin.getConfigManager().getMaxPasswordLength() ? "\n&a\u2713 Valid password length" : "\n&c\u2717 Invalid password length") : "&7Enter the password to unlock")));
        for (int i = 0; i < 10; ++i) {
            gui.setItem(9 + i, this.createItem(Material.WHITE_STAINED_GLASS_PANE, "&b" + i, Arrays.asList("&7Click to add &e" + i + " &7to password")));
        }
        char[] letters = "ABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
        for (int i = 0; i < Math.min(26, 26); ++i) {
            int slot = 18 + i;
            if (slot >= 45) continue;
            gui.setItem(slot, this.createItem(Material.LIGHT_BLUE_STAINED_GLASS_PANE, "&b" + letters[i], Arrays.asList("&7Click to add &e" + letters[i] + " &7to password")));
        }
        gui.setItem(45, this.createItem(Material.REDSTONE, "&cClear All", Arrays.asList("&7Clear the entire password")));
        gui.setItem(46, this.createItem(Material.FEATHER, "&eBackspace", Arrays.asList("&7Remove last character")));
        String confirmText = data.isSettingPassword ? "Set this password" : "Unlock with this password";
        gui.setItem(49, this.createItem(Material.EMERALD_BLOCK, "&aConfirm Password", Arrays.asList("&7" + confirmText, "&7Current: &e" + (data.passwordBuilder.length() > 0 ? currentPassword : "(empty)"), "&7Length: &e" + data.passwordBuilder.length(), data.isSettingPassword && data.passwordBuilder.length() >= this.plugin.getConfigManager().getMinPasswordLength() && data.passwordBuilder.length() <= this.plugin.getConfigManager().getMaxPasswordLength() ? "&a\u2713 Valid password length" : (data.isSettingPassword ? "&c\u2717 Invalid password length" : ""))));
        gui.setItem(53, this.createItem(Material.BARRIER, "&cCancel", Arrays.asList("&7Cancel and close")));
        this.fillEmptySlots(gui);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        String title = event.getView().getTitle();
        if (!title.equals(MessageUtils.colorize("&6Set Password")) && !title.equals(MessageUtils.colorize("&6Enter Password"))) {
            return;
        }
        event.setCancelled(true);
        if (!this.passwordInputs.containsKey(player.getUniqueId())) {
            return;
        }
        PasswordInputData data = this.passwordInputs.get(player.getUniqueId());
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null || clicked.getType() == Material.AIR) {
            return;
        }
        int slot = event.getSlot();
        if (slot == 53) {
            player.closeInventory();
            this.passwordInputs.remove(player.getUniqueId());
            player.sendMessage(MessageUtils.colorize("&7Password input cancelled."));
            return;
        }
        if (slot == 49) {
            String password = data.passwordBuilder.toString();
            if (password.isEmpty()) {
                player.sendMessage(MessageUtils.colorize("&cPassword cannot be empty!"));
                this.updatePasswordDisplay(player, data);
                return;
            }
            if (!data.isSettingPassword) {
                UUID playerId = player.getUniqueId();
                int remainingSeconds = this.plugin.getPasswordCooldownManager().checkCooldown(playerId);
                if (remainingSeconds > 0) {
                    player.sendMessage(MessageUtils.colorize(this.plugin.getConfigManager().getPasswordCooldownMessage(remainingSeconds)));
                    this.updatePasswordDisplay(player, data);
                    return;
                }
            }
            player.closeInventory();
            this.passwordInputs.remove(player.getUniqueId());
            if (data.isSettingPassword) {
                int minLength = this.plugin.getConfigManager().getMinPasswordLength();
                int maxLength = this.plugin.getConfigManager().getMaxPasswordLength();
                if (password.length() < minLength || password.length() > maxLength) {
                    player.sendMessage(MessageUtils.colorize(this.plugin.getConfigManager().getInvalidPasswordLengthMessage(minLength, maxLength)));
                    return;
                }
                if (this.plugin.getLockManager().setPassword(data.chestLocation, player, password)) {
                    player.sendMessage(MessageUtils.colorize(this.plugin.getConfigManager().getPasswordSetMessage()));
                } else {
                    player.sendMessage(MessageUtils.colorize("&cFailed to set password!"));
                }
            } else {
                DatabaseManager.LockData lock = this.plugin.getLockManager().getLockInfo(data.chestLocation);
                if (lock == null || !lock.hasPassword()) {
                    player.sendMessage(MessageUtils.colorize("&cThis chest doesn't have a password!"));
                    return;
                }
                if (PasswordHasher.verifyPassword(password, lock.getPassword())) {
                    this.plugin.getChestListener().setPasswordAttempt(player.getUniqueId(), data.chestLocation, password);
                    this.plugin.getPasswordCooldownManager().clearCooldown(player.getUniqueId());
                    player.sendMessage(MessageUtils.colorize("&aPassword accepted! You can now open this chest."));
                } else {
                    this.plugin.getPasswordCooldownManager().setCooldown(player.getUniqueId());
                    player.sendMessage(MessageUtils.colorize(this.plugin.getConfigManager().getWrongPasswordMessage()));
                }
            }
            return;
        }
        if (slot == 45) {
            data.passwordBuilder.setLength(0);
            this.updatePasswordDisplay(player, data);
            return;
        }
        if (slot == 46) {
            if (data.passwordBuilder.length() > 0) {
                data.passwordBuilder.setLength(data.passwordBuilder.length() - 1);
            }
            this.updatePasswordDisplay(player, data);
            return;
        }
        if (slot >= 9 && slot <= 18) {
            int number = slot - 9;
            if (data.passwordBuilder.length() < this.plugin.getConfigManager().getMaxPasswordLength()) {
                data.passwordBuilder.append(number);
                this.updatePasswordDisplay(player, data);
            } else {
                player.sendMessage(MessageUtils.colorize("&cPassword is too long!"));
            }
            return;
        }
        if (slot >= 18 && slot < 45) {
            int letterIndex = slot - 18;
            if (letterIndex < 26) {
                char letter = "ABCDEFGHIJKLMNOPQRSTUVWXYZ".charAt(letterIndex);
                if (data.passwordBuilder.length() < this.plugin.getConfigManager().getMaxPasswordLength()) {
                    data.passwordBuilder.append(letter);
                    this.updatePasswordDisplay(player, data);
                } else {
                    player.sendMessage(MessageUtils.colorize("&cPassword is too long!"));
                }
            }
            return;
        }
    }

    private void updatePasswordDisplay(Player player, PasswordInputData data) {
        if (!player.getOpenInventory().getTopInventory().getViewers().contains(player)) {
            return;
        }
        Inventory gui = player.getOpenInventory().getTopInventory();
        this.updatePasswordDisplay(player, data, gui);
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        Player player;
        if (event.getInventory().getType() != InventoryType.CHEST) {
            return;
        }
        String title = event.getView().getTitle();
        if (!title.equals(MessageUtils.colorize("&6Set Password")) && !title.equals(MessageUtils.colorize("&6Enter Password"))) {
            return;
        }
        if (event.getPlayer() instanceof Player && this.passwordInputs.containsKey((player = (Player)event.getPlayer()).getUniqueId())) {
            this.passwordInputs.remove(player.getUniqueId());
        }
    }

    private ItemStack createItem(Material material, String name, List<String> lore) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(MessageUtils.colorize(name));
            meta.setLore(lore.stream().map(MessageUtils::colorize).collect(Collectors.toList()));
            item.setItemMeta(meta);
        }
        return item;
    }

    private void fillEmptySlots(Inventory inventory) {
        ItemStack filler = this.createItem(Material.GRAY_STAINED_GLASS_PANE, " ", Arrays.asList(new String[0]));
        for (int i = 0; i < inventory.getSize(); ++i) {
            if (inventory.getItem(i) != null) continue;
            inventory.setItem(i, filler);
        }
    }

    private static class PasswordInputData {
        Location chestLocation;
        StringBuilder passwordBuilder;
        boolean isSettingPassword;

        PasswordInputData(Location chestLocation, boolean isSettingPassword) {
            this.chestLocation = chestLocation;
            this.passwordBuilder = new StringBuilder();
            this.isSettingPassword = isSettingPassword;
        }
    }
}

