/*
 * Decompiled with CFR 0.152.
 */
package com.chestlocklite.gui;

import com.chestlocklite.ChestLockLitePlugin;
import com.chestlocklite.managers.DatabaseManager;
import com.chestlocklite.utils.MessageUtils;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class TrustedPlayersGUI
implements Listener {
    private final ChestLockLitePlugin plugin;
    private final Map<UUID, Location> openGUIs = new HashMap<UUID, Location>();

    public TrustedPlayersGUI(ChestLockLitePlugin plugin) {
        this.plugin = plugin;
    }

    public void openTrustedPlayersGUI(Player player, Location chestLocation) {
        DatabaseManager.LockData lock = this.plugin.getLockManager().getLockInfo(chestLocation);
        if (lock == null) {
            player.sendMessage(MessageUtils.colorize("&cThis chest is not locked!"));
            return;
        }
        if (!lock.getOwnerUUID().equals(player.getUniqueId())) {
            player.sendMessage(MessageUtils.colorize("&cYou are not the owner of this chest!"));
            return;
        }
        Inventory gui = Bukkit.createInventory(null, (int)54, (String)MessageUtils.colorize("&6Trusted Players"));
        try {
            List<DatabaseManager.TrustedPlayerData> trustedPlayers = this.plugin.getDatabaseManager().getTrustedPlayers(chestLocation);
            int slot = 0;
            for (DatabaseManager.TrustedPlayerData trusted : trustedPlayers) {
                if (slot < 45) {
                    boolean isOnline = Bukkit.getOfflinePlayer((UUID)trusted.getUUID()).isOnline();
                    String status = isOnline ? "&a[Online]" : "&7[Offline]";
                    ItemStack skull = this.createPlayerHead(trusted.getUUID(), trusted.getName());
                    ItemMeta meta = skull.getItemMeta();
                    if (meta != null) {
                        meta.setDisplayName(MessageUtils.colorize("&e" + trusted.getName() + " " + status));
                        meta.setLore(Arrays.asList("&7Click to remove trust", "&7This player can access your chest").stream().map(MessageUtils::colorize).collect(Collectors.toList()));
                        skull.setItemMeta(meta);
                    }
                    gui.setItem(slot, skull);
                    ++slot;
                    continue;
                }
                break;
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("Error loading trusted players: " + e.getMessage());
            player.sendMessage(MessageUtils.colorize("&cError loading trusted players!"));
            return;
        }
        gui.setItem(45, this.createItem(Material.EMERALD, "&aAdd Trusted Player", Arrays.asList("&7Click to add a player", "&7to your trusted list", "&7", "&7Use command:", "&e/cl trust <player>")));
        gui.setItem(49, this.createItem(Material.ARROW, "&7Back to Main Menu", Arrays.asList("&7Click to return to", "&7the chest lock menu")));
        gui.setItem(53, this.createItem(Material.BARRIER, "&cClose", Arrays.asList("&7Click to close this menu")));
        this.fillEmptySlots(gui);
        player.openInventory(gui);
        this.openGUIs.put(player.getUniqueId(), chestLocation);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        if (!event.getView().getTitle().equals(MessageUtils.colorize("&6Trusted Players"))) {
            return;
        }
        event.setCancelled(true);
        if (!this.openGUIs.containsKey(player.getUniqueId())) {
            return;
        }
        Location chestLocation = this.openGUIs.get(player.getUniqueId());
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null || clicked.getType() == Material.AIR) {
            return;
        }
        Material clickedType = clicked.getType();
        int slot = event.getSlot();
        if (clickedType == Material.BARRIER && slot == 53) {
            player.closeInventory();
            return;
        }
        if (clickedType == Material.ARROW && slot == 49) {
            player.closeInventory();
            this.plugin.getLockGUI().openGUI(player, chestLocation);
            return;
        }
        if (clickedType == Material.EMERALD && slot == 45) {
            player.closeInventory();
            player.sendMessage(MessageUtils.colorize("&7Use &e/cl trust <player> &7to add a trusted player!"));
            player.sendMessage(MessageUtils.colorize("&7Or Shift + Right-click the chest and use the GUI."));
            return;
        }
        if (clickedType == Material.PLAYER_HEAD && slot < 45) {
            ItemMeta meta = clicked.getItemMeta();
            if (meta != null && meta.getDisplayName() != null) {
                String displayName = meta.getDisplayName();
                String playerName = ChatColor.stripColor((String)displayName).split(" ")[0];
                Player targetPlayer = Bukkit.getPlayer((String)playerName);
                UUID targetUUID = null;
                if (targetPlayer != null) {
                    targetUUID = targetPlayer.getUniqueId();
                } else {
                    try {
                        List<DatabaseManager.TrustedPlayerData> trustedPlayers = this.plugin.getDatabaseManager().getTrustedPlayers(chestLocation);
                        for (DatabaseManager.TrustedPlayerData trusted : trustedPlayers) {
                            if (!trusted.getName().equalsIgnoreCase(playerName)) continue;
                            targetUUID = trusted.getUUID();
                            break;
                        }
                    }
                    catch (SQLException e) {
                        this.plugin.getLogger().warning("Error finding trusted player: " + e.getMessage());
                    }
                }
                if (targetUUID == null) {
                    player.sendMessage(MessageUtils.colorize("&cCould not find player!"));
                    return;
                }
                try {
                    this.plugin.getDatabaseManager().removeTrustedPlayer(chestLocation, targetUUID);
                    player.sendMessage(MessageUtils.colorize("&aRemoved trust from &e" + playerName + "&a!"));
                    player.closeInventory();
                    this.openTrustedPlayersGUI(player, chestLocation);
                    if (targetPlayer != null) {
                        targetPlayer.sendMessage(MessageUtils.colorize("&e" + player.getName() + " &chas removed your trust on one of their chests."));
                    }
                }
                catch (SQLException e) {
                    this.plugin.getLogger().warning("Error removing trusted player: " + e.getMessage());
                    player.sendMessage(MessageUtils.colorize("&cAn error occurred. Please try again."));
                }
            }
            return;
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (event.getPlayer() instanceof Player) {
            this.openGUIs.remove(event.getPlayer().getUniqueId());
        }
    }

    private ItemStack createItem(Material material, String name, List<String> lore) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(MessageUtils.colorize(name));
            meta.setLore(lore.stream().map(MessageUtils::colorize).collect(Collectors.toList()));
            item.setItemMeta(meta);
        }
        return item;
    }

    private ItemStack createPlayerHead(UUID uuid, String name) {
        ItemStack skull = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta meta = (SkullMeta)skull.getItemMeta();
        if (meta != null) {
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)uuid);
            meta.setOwningPlayer(offlinePlayer);
            skull.setItemMeta((ItemMeta)meta);
        }
        return skull;
    }

    private void fillEmptySlots(Inventory inventory) {
        ItemStack glass = new ItemStack(Material.GRAY_STAINED_GLASS_PANE);
        ItemMeta meta = glass.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(" ");
            glass.setItemMeta(meta);
        }
        for (int i = 0; i < inventory.getSize(); ++i) {
            if (inventory.getItem(i) != null) continue;
            inventory.setItem(i, glass);
        }
    }
}

