/*
 * Decompiled with CFR 0.152.
 */
package com.chestlocklite.listeners;

import com.chestlocklite.ChestLockLitePlugin;
import com.chestlocklite.utils.MessageUtils;
import java.sql.SQLException;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.plugin.Plugin;

public class BlockPlaceListener
implements Listener {
    private final ChestLockLitePlugin plugin;

    public BlockPlaceListener(ChestLockLitePlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockPlace(BlockPlaceEvent event) {
        if (!this.plugin.getConfigManager().isAutoLockOnPlace()) {
            return;
        }
        if (!this.plugin.getConfigManager().isLockingAllowed()) {
            return;
        }
        Player player = event.getPlayer();
        Block block = event.getBlock();
        if (!this.plugin.getLockManager().isChest(block)) {
            return;
        }
        if (!player.hasPermission("chestlocklite.lock")) {
            return;
        }
        Location chestLocation = this.plugin.getLockManager().getPrimaryChestLocation(block);
        if (this.plugin.getLockManager().getLockInfo(chestLocation) != null) {
            return;
        }
        try {
            int currentChestCount = this.plugin.getDatabaseManager().getChestCount(player.getUniqueId());
            int maxChests = this.plugin.getConfigManager().getMaxChestsPerPlayer();
            if (currentChestCount >= maxChests) {
                player.sendMessage(MessageUtils.colorize(this.plugin.getConfigManager().getMaxChestsReachedMessage(maxChests)));
                return;
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("Error checking chest count for auto-lock: " + e.getMessage());
            return;
        }
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            if (this.plugin.getLockManager().lockChest(chestLocation, player)) {
                player.sendMessage(MessageUtils.colorize(this.plugin.getConfigManager().getLockSuccessMessage()));
                if (this.plugin.getConfigManager().isPasswordsAllowed()) {
                    player.sendMessage(MessageUtils.colorize("&7Tip: Use &e/cl password <password> &7to add password protection!"));
                }
            }
        });
    }
}

