/*
 * Decompiled with CFR 0.152.
 */
package com.chestlocklite.listeners;

import com.chestlocklite.ChestLockLitePlugin;
import com.chestlocklite.managers.DatabaseManager;
import com.chestlocklite.utils.MessageUtils;
import com.chestlocklite.utils.PasswordHasher;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.BlockFadeEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.plugin.Plugin;

public class ChestListener
implements Listener {
    private final ChestLockLitePlugin plugin;
    private final Map<UUID, Map<String, String>> passwordAttempts = new HashMap<UUID, Map<String, String>>();

    public ChestListener(ChestLockLitePlugin plugin) {
        this.plugin = plugin;
    }

    private String getLocationKey(Location loc) {
        return loc.getWorld().getName() + ":" + loc.getBlockX() + ":" + loc.getBlockY() + ":" + loc.getBlockZ();
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onChestOpen(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        Player player = event.getPlayer();
        Block block = event.getClickedBlock();
        if (block == null || !this.plugin.getLockManager().isChest(block)) {
            return;
        }
        if (player.isSneaking() && player.hasPermission("chestlocklite.gui") && player.getInventory().getItemInMainHand().getType() == Material.AIR) {
            Location chestLocation = this.plugin.getLockManager().getPrimaryChestLocation(block);
            this.plugin.getLockGUI().openGUI(player, chestLocation);
            event.setCancelled(true);
            return;
        }
        if (player.hasPermission("chestlocklite.bypass")) {
            return;
        }
        Location chestLocation = this.plugin.getLockManager().getPrimaryChestLocation(block);
        DatabaseManager.LockData lock = this.plugin.getLockManager().getLockInfo(chestLocation);
        if (lock == null) {
            return;
        }
        if (lock.getOwnerUUID().equals(player.getUniqueId())) {
            return;
        }
        try {
            if (this.plugin.getDatabaseManager().isTrustedPlayer(chestLocation, player.getUniqueId())) {
                return;
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("Error checking trusted player status: " + e.getMessage());
        }
        if (lock.hasPassword()) {
            String attemptedPassword;
            Map<String, String> playerAttempts = this.passwordAttempts.get(player.getUniqueId());
            String locationKey = this.getLocationKey(chestLocation);
            if (playerAttempts != null && (attemptedPassword = playerAttempts.get(locationKey)) != null && PasswordHasher.verifyPassword(attemptedPassword, lock.getPassword())) {
                return;
            }
            event.setCancelled(true);
            player.sendMessage(MessageUtils.colorize("&cThis chest is password protected by &e" + lock.getOwnerName() + "&c!"));
            player.sendMessage(MessageUtils.colorize("&7Use &e/cl password <password> &7while looking at this chest to unlock it."));
            return;
        }
        event.setCancelled(true);
        player.sendMessage(MessageUtils.colorize(this.plugin.getConfigManager().getChestLockedMessage()));
        player.sendMessage(MessageUtils.colorize(this.plugin.getConfigManager().getLockedByOwnerMessage(lock.getOwnerName())));
        if (this.plugin.getConfigManager().isShowParticles()) {
            try {
                Particle particle = Particle.valueOf((String)this.plugin.getConfigManager().getParticleType());
                player.spawnParticle(particle, block.getLocation().add(0.5, 0.5, 0.5), 10, 0.3, 0.3, 0.3, 0.1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onChestBreak(BlockBreakEvent event) {
        Player player = event.getPlayer();
        Block block = event.getBlock();
        if (!this.plugin.getLockManager().isChest(block)) {
            return;
        }
        Location chestLocation = this.plugin.getLockManager().getPrimaryChestLocation(block);
        DatabaseManager.LockData lock = this.plugin.getLockManager().getLockInfo(chestLocation);
        if (lock == null) {
            return;
        }
        if (player.hasPermission("chestlocklite.bypass")) {
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                try {
                    this.plugin.getDatabaseManager().removeLock(chestLocation);
                    this.plugin.getLogger().info("Lock removed from database: Admin " + player.getName() + " broke chest at " + chestLocation.getWorld().getName() + " " + chestLocation.getBlockX() + "," + chestLocation.getBlockY() + "," + chestLocation.getBlockZ() + " (Owner: " + lock.getOwnerName() + ")");
                }
                catch (SQLException e) {
                    this.plugin.getLogger().warning("Error removing lock from database: " + e.getMessage());
                }
            });
            return;
        }
        if (lock.getOwnerUUID().equals(player.getUniqueId())) {
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                try {
                    this.plugin.getDatabaseManager().removeLock(chestLocation);
                    this.plugin.getLogger().info("Lock removed from database: Owner " + player.getName() + " broke chest at " + chestLocation.getWorld().getName() + " " + chestLocation.getBlockX() + "," + chestLocation.getBlockY() + "," + chestLocation.getBlockZ());
                }
                catch (SQLException e) {
                    this.plugin.getLogger().warning("Error removing lock from database: " + e.getMessage());
                }
            });
            return;
        }
        event.setCancelled(true);
        player.sendMessage(MessageUtils.colorize(this.plugin.getConfigManager().getCannotBreakChestMessage(lock.getOwnerName())));
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=false)
    public void onEntityExplode(EntityExplodeEvent event) {
        if (!this.plugin.getConfigManager().isExplosionProtectionEnabled()) {
            return;
        }
        Iterator iterator = event.blockList().iterator();
        while (iterator.hasNext()) {
            Block block = (Block)iterator.next();
            if (!this.plugin.getLockManager().isChest(block)) continue;
            Location chestLocation = this.plugin.getLockManager().getPrimaryChestLocation(block);
            DatabaseManager.LockData lock = this.plugin.getLockManager().getLockInfo(chestLocation);
            if (lock == null) continue;
            iterator.remove();
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=false)
    public void onBlockExplode(BlockExplodeEvent event) {
        if (!this.plugin.getConfigManager().isExplosionProtectionEnabled()) {
            return;
        }
        Iterator iterator = event.blockList().iterator();
        while (iterator.hasNext()) {
            Block block = (Block)iterator.next();
            if (!this.plugin.getLockManager().isChest(block)) continue;
            Location chestLocation = this.plugin.getLockManager().getPrimaryChestLocation(block);
            DatabaseManager.LockData lock = this.plugin.getLockManager().getLockInfo(chestLocation);
            if (lock == null) continue;
            iterator.remove();
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=false)
    public void onBlockBurn(BlockBurnEvent event) {
        if (!this.plugin.getConfigManager().isFireProtectionEnabled()) {
            return;
        }
        Block block = event.getBlock();
        if (!this.plugin.getLockManager().isChest(block)) {
            return;
        }
        Location chestLocation = this.plugin.getLockManager().getPrimaryChestLocation(block);
        DatabaseManager.LockData lock = this.plugin.getLockManager().getLockInfo(chestLocation);
        if (lock != null) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=false)
    public void onBlockFade(BlockFadeEvent event) {
        if (!this.plugin.getConfigManager().isFireProtectionEnabled()) {
            return;
        }
        Block block = event.getBlock();
        if (!this.plugin.getLockManager().isChest(block)) {
            return;
        }
        Location chestLocation = this.plugin.getLockManager().getPrimaryChestLocation(block);
        DatabaseManager.LockData lock = this.plugin.getLockManager().getLockInfo(chestLocation);
        if (lock != null) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=false)
    public void onPistonExtend(BlockPistonExtendEvent event) {
        if (!this.plugin.getConfigManager().isPistonProtectionEnabled()) {
            return;
        }
        List blocks = event.getBlocks();
        for (Block block : blocks) {
            if (!this.plugin.getLockManager().isChest(block)) continue;
            Location chestLocation = this.plugin.getLockManager().getPrimaryChestLocation(block);
            DatabaseManager.LockData lock = this.plugin.getLockManager().getLockInfo(chestLocation);
            if (lock == null) continue;
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=false)
    public void onPistonRetract(BlockPistonRetractEvent event) {
        if (!this.plugin.getConfigManager().isPistonProtectionEnabled()) {
            return;
        }
        List blocks = event.getBlocks();
        for (Block block : blocks) {
            if (!this.plugin.getLockManager().isChest(block)) continue;
            Location chestLocation = this.plugin.getLockManager().getPrimaryChestLocation(block);
            DatabaseManager.LockData lock = this.plugin.getLockManager().getLockInfo(chestLocation);
            if (lock == null) continue;
            event.setCancelled(true);
            return;
        }
    }

    public void setPasswordAttempt(UUID playerUUID, Location chestLocation, String password) {
        String locationKey = this.getLocationKey(chestLocation);
        this.passwordAttempts.computeIfAbsent(playerUUID, k -> new HashMap()).put(locationKey, password);
    }

    public void clearPasswordAttempt(UUID playerUUID, Location chestLocation) {
        Map<String, String> playerAttempts = this.passwordAttempts.get(playerUUID);
        if (playerAttempts != null) {
            String locationKey = this.getLocationKey(chestLocation);
            playerAttempts.remove(locationKey);
            if (playerAttempts.isEmpty()) {
                this.passwordAttempts.remove(playerUUID);
            }
        }
    }

    public void clearPasswordAttempt(UUID playerUUID) {
        this.passwordAttempts.remove(playerUUID);
    }
}

