/*
 * Decompiled with CFR 0.152.
 */
package com.chestlocklite.managers;

import com.chestlocklite.ChestLockLitePlugin;
import com.chestlocklite.managers.DatabaseManager;
import com.chestlocklite.utils.PasswordHasher;
import java.sql.SQLException;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.block.DoubleChest;
import org.bukkit.entity.Player;

public class LockManager {
    private final ChestLockLitePlugin plugin;

    public LockManager(ChestLockLitePlugin plugin) {
        this.plugin = plugin;
    }

    public boolean isChest(Block block) {
        if (block.getType() == Material.ENDER_CHEST) {
            return false;
        }
        BlockState state = block.getState();
        return state instanceof Chest;
    }

    public Chest getChest(Block block) {
        if (!this.isChest(block)) {
            return null;
        }
        BlockState state = block.getState();
        if (state instanceof Chest) {
            return (Chest)state;
        }
        return null;
    }

    public Block getDoubleChestPartner(Block chestBlock) {
        Chest chest = this.getChest(chestBlock);
        if (chest == null) {
            return null;
        }
        Chest doubleChest = null;
        try {
            doubleChest = chest.getInventory().getHolder() instanceof DoubleChest ? (Chest)((DoubleChest)chest.getInventory().getHolder()).getLeftSide() : null;
        }
        catch (Exception e) {
            return null;
        }
        if (doubleChest != null && doubleChest.getLocation().equals((Object)chestBlock.getLocation())) {
            doubleChest = (Chest)((DoubleChest)chest.getInventory().getHolder()).getRightSide();
        }
        return doubleChest != null ? doubleChest.getBlock() : null;
    }

    public Location getPrimaryChestLocation(Block chestBlock) {
        Chest chest = this.getChest(chestBlock);
        if (chest == null) {
            return chestBlock.getLocation();
        }
        try {
            if (chest.getInventory().getHolder() instanceof DoubleChest) {
                DoubleChest doubleChest = (DoubleChest)chest.getInventory().getHolder();
                Chest leftChest = (Chest)doubleChest.getLeftSide();
                return leftChest.getLocation();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return chestBlock.getLocation();
    }

    public boolean lockChest(Location location, Player player) {
        try {
            if (this.plugin.getDatabaseManager().getLock(location) != null) {
                return false;
            }
            int chestCount = this.plugin.getDatabaseManager().getChestCount(player.getUniqueId());
            if (chestCount >= this.plugin.getConfigManager().getMaxChestsPerPlayer()) {
                return false;
            }
            this.plugin.getDatabaseManager().addLock(location, player.getUniqueId(), player.getName());
            return true;
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Error locking chest: " + e.getMessage());
            return false;
        }
    }

    public boolean unlockChest(Location location, Player player) {
        try {
            DatabaseManager.LockData lock = this.plugin.getDatabaseManager().getLock(location);
            if (lock == null) {
                return false;
            }
            if (!lock.getOwnerUUID().equals(player.getUniqueId()) && !player.hasPermission("chestlocklite.admin")) {
                return false;
            }
            this.plugin.getDatabaseManager().removeLock(location);
            return true;
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Error unlocking chest: " + e.getMessage());
            return false;
        }
    }

    public boolean canOpenChest(Location location, Player player, String password) {
        try {
            DatabaseManager.LockData lock = this.plugin.getDatabaseManager().getLock(location);
            if (lock == null) {
                return true;
            }
            if (player.hasPermission("chestlocklite.bypass")) {
                return true;
            }
            if (lock.getOwnerUUID().equals(player.getUniqueId())) {
                return true;
            }
            if (this.plugin.getDatabaseManager().isTrustedPlayer(location, player.getUniqueId())) {
                return true;
            }
            if (password != null && lock.hasPassword()) {
                return PasswordHasher.verifyPassword(password, lock.getPassword());
            }
            if (lock.hasPassword()) {
                return false;
            }
            return false;
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Error checking chest access: " + e.getMessage());
            return false;
        }
    }

    public boolean setPassword(Location location, Player player, String password) {
        try {
            DatabaseManager.LockData lock = this.plugin.getDatabaseManager().getLock(location);
            if (lock == null) {
                return false;
            }
            if (!lock.getOwnerUUID().equals(player.getUniqueId())) {
                return false;
            }
            this.plugin.getDatabaseManager().setPassword(location, password);
            return true;
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Error setting password: " + e.getMessage());
            return false;
        }
    }

    public boolean removePassword(Location location, Player player) {
        try {
            DatabaseManager.LockData lock = this.plugin.getDatabaseManager().getLock(location);
            if (lock == null) {
                return false;
            }
            if (!lock.getOwnerUUID().equals(player.getUniqueId())) {
                return false;
            }
            this.plugin.getDatabaseManager().removePassword(location);
            return true;
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Error removing password: " + e.getMessage());
            return false;
        }
    }

    public DatabaseManager.LockData getLockInfo(Location location) {
        try {
            return this.plugin.getDatabaseManager().getLock(location);
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Error getting lock info: " + e.getMessage());
            return null;
        }
    }
}

