/*
 * Decompiled with CFR 0.152.
 */
package com.khazoda.basicweapons.struct;

import com.khazoda.basicweapons.item.ClubItem;
import com.khazoda.basicweapons.item.CustomAxeItem;
import com.khazoda.basicweapons.item.CustomSwordItem;
import com.khazoda.basicweapons.item.DaggerItem;
import com.khazoda.basicweapons.item.GlaiveItem;
import com.khazoda.basicweapons.item.HammerItem;
import com.khazoda.basicweapons.item.QuarterstaffItem;
import com.khazoda.basicweapons.item.SpearItem;
import com.khazoda.basicweapons.materialpack.MaterialPackLoader;
import net.minecraft.class_1792;
import net.minecraft.class_9886;

public final class WeaponType {
    public static float getDamageModifier(WeaponTypeInterface type, class_9886 material) {
        if (type instanceof BasicWeaponType) {
            BasicWeaponType basicType = (BasicWeaponType)type;
            return BasicWeaponType.getDamageModifier(basicType, material);
        }
        return 0.0f;
    }

    public static float getSpeedModifier(WeaponTypeInterface type, class_9886 material) {
        if (type instanceof BasicWeaponType) {
            BasicWeaponType basicType = (BasicWeaponType)type;
            return BasicWeaponType.getSpeedModifier(basicType, material);
        }
        return 0.0f;
    }

    public static float getReachModifier(WeaponTypeInterface type, class_9886 material) {
        if (type instanceof BasicWeaponType) {
            BasicWeaponType basicType = (BasicWeaponType)type;
            return BasicWeaponType.getReachModifier(basicType, material);
        }
        return 0.0f;
    }

    public static enum BasicWeaponType implements WeaponTypeInterface
    {
        DAGGER("dagger", 1.0f, -1.6f, 0.0, DaggerItem::new),
        HAMMER("hammer", 7.0f, -3.4f, 0.0, HammerItem::new),
        CLUB("club", 5.0f, -3.0f, 0.0, ClubItem::new),
        SPEAR("spear", 2.0f, -2.8f, 2.0, SpearItem::new),
        QUARTERSTAFF("quarterstaff", 1.0f, -2.3f, 1.0, QuarterstaffItem::new),
        GLAIVE("glaive", 5.0f, -3.2f, 1.0, GlaiveItem::new);

        private final String id;
        private final float baseDamage;
        private final float baseSpeed;
        private final double baseReach;
        private final WeaponFactory factory;

        private BasicWeaponType(String id, float baseDamage, float baseSpeed, double baseReach, WeaponFactory factory) {
            this.id = id;
            this.baseDamage = baseDamage;
            this.baseSpeed = baseSpeed;
            this.baseReach = baseReach;
            this.factory = factory;
        }

        @Override
        public String getId() {
            return this.id;
        }

        public float getBaseDamage() {
            return this.baseDamage;
        }

        public float getBaseSpeed() {
            return this.baseSpeed;
        }

        public double getBaseReach() {
            return this.baseReach;
        }

        @Override
        public class_1792 create(class_9886 material, float damageModifier, float speedModifier, float reachModifier, class_1792.class_1793 properties) {
            float extraSpeed = speedModifier + MaterialPackLoader.getAttackSpeedBonus(material);
            double extraReach = reachModifier + MaterialPackLoader.getReachBonus(material);
            float finalDamage = this.baseDamage + damageModifier;
            float finalSpeed = this.baseSpeed + extraSpeed;
            double finalReach = this.baseReach + extraReach;
            return this.factory.create(material, finalDamage, finalSpeed, finalReach, properties);
        }

        public static float getDamageModifier(BasicWeaponType type, class_9886 material) {
            if (type == DAGGER && material == class_9886.field_52589) {
                return -1.0f;
            }
            if (type == HAMMER) {
                if (material == class_9886.field_52585) {
                    return -6.0f;
                }
                if (material == class_9886.field_52586) {
                    return -3.0f;
                }
                if (material == class_9886.field_52589) {
                    return -6.0f;
                }
                return -1.0f;
            }
            return 0.0f;
        }

        public static float getSpeedModifier(BasicWeaponType type, class_9886 material) {
            if (type == DAGGER && material == class_9886.field_52589) {
                return 1.0f;
            }
            if (type == HAMMER) {
                if (material == class_9886.field_52585) {
                    return 0.4f;
                }
                if (material == class_9886.field_52586) {
                    return 0.2f;
                }
                if (material == class_9886.field_52589) {
                    return 0.6f;
                }
                if (material == class_9886.field_52590) {
                    return 0.2f;
                }
                return 0.1f;
            }
            return 0.0f;
        }

        public static float getReachModifier(BasicWeaponType type, class_9886 material) {
            return 0.0f;
        }

        @FunctionalInterface
        public static interface WeaponFactory {
            public class_1792 create(class_9886 var1, float var2, float var3, double var4, class_1792.class_1793 var6);
        }
    }

    public static enum VanillaWeaponType implements WeaponTypeInterface
    {
        SWORD("sword", 1.0f, -1.6f, 0.0, CustomSwordItem::new),
        AXE("axe", 7.0f, -3.4f, 0.0, CustomAxeItem::new);

        private final String id;
        private final float baseDamage;
        private final float baseSpeed;
        private final double baseReach;
        private final WeaponFactory factory;

        private VanillaWeaponType(String id, float baseDamage, float baseSpeed, double baseReach, WeaponFactory factory) {
            this.id = id;
            this.baseDamage = baseDamage;
            this.baseSpeed = baseSpeed;
            this.baseReach = baseReach;
            this.factory = factory;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public class_1792 create(class_9886 material, float damageModifier, float speedModifier, float reachModifier, class_1792.class_1793 properties) {
            float extraSpeed = speedModifier + MaterialPackLoader.getAttackSpeedBonus(material);
            double extraReach = reachModifier + MaterialPackLoader.getReachBonus(material);
            float finalDamage = this.baseDamage + damageModifier;
            float finalSpeed = this.baseSpeed + extraSpeed;
            double finalReach = this.baseReach + extraReach;
            return this.factory.create(material, finalDamage, finalSpeed, finalReach, properties);
        }

        @FunctionalInterface
        public static interface WeaponFactory {
            public class_1792 create(class_9886 var1, float var2, float var3, double var4, class_1792.class_1793 var6);
        }
    }

    public static interface WeaponTypeInterface {
        public String getId();

        public class_1792 create(class_9886 var1, float var2, float var3, float var4, class_1792.class_1793 var5);
    }
}

