/*
 * Decompiled with CFR 0.152.
 */
package com.khazoda.basicweapons.materialpack;

import com.khazoda.basicweapons.materialpack.MaterialPackConstants;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.RepositorySource;

public class ResourceAndDatapackCustomLoader
implements RepositorySource {
    private final File packsFolder;
    private final boolean isRequired;
    private final PackType packType;
    private static final PackSource MATERIAL = PackSource.create(Component::copy, (boolean)true);
    private static final Predicate<Path> IS_VALID_RESOURCE_PACK = pack -> Files.isDirectory(pack.resolve(MaterialPackConstants.ASSETS_PATH), new LinkOption[0]) && Files.isRegularFile(pack.resolve("pack.mcmeta"), new LinkOption[0]);
    private static final Predicate<Path> IS_VALID_DATA_PACK = pack -> Files.isDirectory(pack.resolve(MaterialPackConstants.DATA_PATH), new LinkOption[0]) && Files.isRegularFile(pack.resolve("pack.mcmeta"), new LinkOption[0]);

    public ResourceAndDatapackCustomLoader(PackType packType, boolean isRequired) {
        this.packsFolder = packType == PackType.CLIENT_RESOURCES ? new File(MaterialPackConstants.RESOURCEPACK_TARGET) : new File(MaterialPackConstants.DATAPACK_TARGET);
        this.packType = packType;
        this.isRequired = isRequired;
    }

    private String formatPackName(String folderName) {
        String[] sections = folderName.split("_");
        if (sections.length >= 2) {
            String materialName = sections[1];
            String[] materialWords = materialName.split("-");
            StringBuilder formatted = new StringBuilder();
            for (String word : materialWords) {
                if (word.isEmpty()) continue;
                formatted.append(Character.toUpperCase(word.charAt(0))).append(word.substring(1).toLowerCase()).append(" ");
            }
            return formatted.toString().trim() + (this.packType == PackType.CLIENT_RESOURCES ? " Material Resources" : " Material Data");
        }
        return folderName + (this.packType == PackType.CLIENT_RESOURCES ? " Material Resources" : " Material Data");
    }

    public void loadPacks(Consumer<Pack> packConsumer) {
        if (!this.packsFolder.exists() || !this.packsFolder.isDirectory()) {
            return;
        }
        File[] packs = this.packsFolder.listFiles(file -> (file.isDirectory() || file.getName().endsWith(".zip")) && new File(file, "pack.mcmeta").exists() && (this.packType == PackType.CLIENT_RESOURCES ? IS_VALID_RESOURCE_PACK.test(file.toPath()) : IS_VALID_DATA_PACK.test(file.toPath())));
        if (packs != null) {
            for (File packFile : packs) {
                PackSelectionConfig selectionConfig;
                Pack.ResourcesSupplier resources;
                String packId = "basicweapons:" + (packFile.getName().endsWith(".zip") ? packFile.getName().substring(0, packFile.getName().length() - 4) : packFile.getName());
                final Path packPath = packFile.toPath();
                String displayName = this.formatPackName(packFile.getName());
                PackLocationInfo location = new PackLocationInfo(packId, (Component)Component.literal((String)displayName), MATERIAL, Optional.empty());
                Pack pack = Pack.readMetaAndCreate((PackLocationInfo)location, (Pack.ResourcesSupplier)(resources = new Pack.ResourcesSupplier(){

                    public PackResources openPrimary(PackLocationInfo info) {
                        return new PathPackResources(info, packPath);
                    }

                    public PackResources openFull(PackLocationInfo info, Pack.Metadata metadata) {
                        return new PathPackResources(info, packPath);
                    }
                }), (PackType)this.packType, (PackSelectionConfig)(selectionConfig = new PackSelectionConfig(this.isRequired, Pack.Position.BOTTOM, true)));
                if (pack == null) continue;
                packConsumer.accept(pack);
            }
        }
    }
}

