/*
 * Decompiled with CFR 0.152.
 */
package com.khazoda.basicweapons.registry;

import com.khazoda.basicweapons.registry.WeaponRegistry;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ToolMaterial;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.EnchantRandomlyFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemDamageFunction;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public class LootTableModifier {
    private static final Map<ResourceKey<LootTable>, LootConfig> LOOT_TABLE_CONFIGS = new HashMap<ResourceKey<LootTable>, LootConfig>();

    public static void modifyLootTable(ResourceLocation id, LootTable.Builder tableBuilder) {
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)id);
        LootConfig config = LOOT_TABLE_CONFIGS.get(key);
        if (config != null) {
            LootTableModifier.addLootToTable(config, tableBuilder);
        }
    }

    private static void addLootToTable(LootConfig config, LootTable.Builder tableBuilder) {
        if (config.enchanted()) {
            LootPool.Builder enchantedPool = LootTableModifier.createBasePoolBuilder(config.items(), 1.0f).apply((LootItemFunction.Builder)EnchantRandomlyFunction.randomEnchantment());
            if (config.applyDamage()) {
                LootTableModifier.applyDamage(enchantedPool);
            }
            LootPool.Builder normalPool = LootTableModifier.createBasePoolBuilder(config.items(), 1.0f);
            tableBuilder.withPool(enchantedPool).withPool(normalPool);
        } else {
            LootPool.Builder pool = LootTableModifier.createBasePoolBuilder(config.items(), 2.0f);
            if (config.applyDamage()) {
                LootTableModifier.applyDamage(pool);
            }
            tableBuilder.withPool(pool);
        }
    }

    private static LootPool.Builder createBasePoolBuilder(List<Item> items, float maxRolls) {
        LootPool.Builder builder = LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)0.0f, (float)maxRolls));
        for (Item item : items) {
            builder.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)item).setWeight(2));
        }
        return builder;
    }

    private static void applyDamage(LootPool.Builder builder) {
        builder.apply((LootItemFunction.Builder)SetItemDamageFunction.setDamage((NumberProvider)UniformGenerator.between((float)0.5f, (float)0.8f))).setBonusRolls((NumberProvider)ConstantValue.exactly((float)0.5f));
    }

    static {
        LOOT_TABLE_CONFIGS.put((ResourceKey<LootTable>)BuiltInLootTables.JUNGLE_TEMPLE, new LootConfig(WeaponRegistry.getItemsByMaterial(ToolMaterial.STONE), true, false));
        LOOT_TABLE_CONFIGS.put((ResourceKey<LootTable>)BuiltInLootTables.IGLOO_CHEST, new LootConfig(WeaponRegistry.getItemsByMaterial(ToolMaterial.STONE), true, false));
        LOOT_TABLE_CONFIGS.put((ResourceKey<LootTable>)BuiltInLootTables.SHIPWRECK_SUPPLY, new LootConfig(WeaponRegistry.getItemsByMaterial(ToolMaterial.STONE), true, false));
        LOOT_TABLE_CONFIGS.put((ResourceKey<LootTable>)BuiltInLootTables.SIMPLE_DUNGEON, new LootConfig(WeaponRegistry.getItemsByMaterial(ToolMaterial.IRON), false, false));
        LOOT_TABLE_CONFIGS.put((ResourceKey<LootTable>)BuiltInLootTables.ABANDONED_MINESHAFT, new LootConfig(WeaponRegistry.getItemsByMaterial(ToolMaterial.IRON), false, false));
        LOOT_TABLE_CONFIGS.put((ResourceKey<LootTable>)BuiltInLootTables.DESERT_PYRAMID, new LootConfig(WeaponRegistry.getItemsByMaterial(ToolMaterial.IRON), false, false));
        LOOT_TABLE_CONFIGS.put((ResourceKey<LootTable>)BuiltInLootTables.PILLAGER_OUTPOST, new LootConfig(WeaponRegistry.getItemsByMaterial(ToolMaterial.IRON), false, false));
        LOOT_TABLE_CONFIGS.put((ResourceKey<LootTable>)BuiltInLootTables.BURIED_TREASURE, new LootConfig(WeaponRegistry.getItemsByMaterial(ToolMaterial.IRON), true, false));
        LOOT_TABLE_CONFIGS.put((ResourceKey<LootTable>)BuiltInLootTables.SHIPWRECK_TREASURE, new LootConfig(WeaponRegistry.getItemsByMaterial(ToolMaterial.IRON), true, false));
        LOOT_TABLE_CONFIGS.put((ResourceKey<LootTable>)BuiltInLootTables.STRONGHOLD_CORRIDOR, new LootConfig(WeaponRegistry.getItemsByMaterial(ToolMaterial.IRON), false, false));
        LOOT_TABLE_CONFIGS.put((ResourceKey<LootTable>)BuiltInLootTables.VILLAGE_WEAPONSMITH, new LootConfig(WeaponRegistry.getItemsByMaterial(ToolMaterial.IRON), false, false));
        LOOT_TABLE_CONFIGS.put((ResourceKey<LootTable>)BuiltInLootTables.RUINED_PORTAL, new LootConfig(WeaponRegistry.getItemsByMaterial(ToolMaterial.GOLD), true, true));
        LOOT_TABLE_CONFIGS.put((ResourceKey<LootTable>)BuiltInLootTables.BASTION_TREASURE, new LootConfig(WeaponRegistry.getItemsByMaterial(ToolMaterial.DIAMOND), true, true));
        LOOT_TABLE_CONFIGS.put((ResourceKey<LootTable>)BuiltInLootTables.BASTION_OTHER, new LootConfig(WeaponRegistry.getItemsByMaterial(ToolMaterial.GOLD), true, true));
        LOOT_TABLE_CONFIGS.put((ResourceKey<LootTable>)BuiltInLootTables.BASTION_BRIDGE, new LootConfig(WeaponRegistry.getItemsByMaterial(ToolMaterial.GOLD), true, true));
        LOOT_TABLE_CONFIGS.put((ResourceKey<LootTable>)BuiltInLootTables.BASTION_HOGLIN_STABLE, new LootConfig(WeaponRegistry.getItemsByMaterial(ToolMaterial.GOLD), true, true));
        LOOT_TABLE_CONFIGS.put((ResourceKey<LootTable>)BuiltInLootTables.END_CITY_TREASURE, new LootConfig(WeaponRegistry.getItemsByMaterial(ToolMaterial.DIAMOND), false, true));
    }

    private record LootConfig(List<Item> items, boolean applyDamage, boolean enchanted) {
    }
}

