/*
 * Decompiled with CFR 0.152.
 */
package com.khazoda.basicweapons.materialpack;

import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ToolMaterial;

public class EarlyLoadedMaterial {
    private final String material_name;
    private final int durability;
    private final float attack_damage_bonus;
    private final float mining_speed;
    private final float attack_speed_bonus;
    private final float reach_bonus;
    private final int enchantability;
    private final String repair_ingredient;

    public EarlyLoadedMaterial(String material_name, int durability, float attack_damage_bonus, float mining_speed, float attack_speed_bonus, float reach_bonus, int enchantability, String repair_ingredient) {
        this.material_name = material_name;
        this.durability = durability;
        this.attack_damage_bonus = attack_damage_bonus;
        this.mining_speed = mining_speed;
        this.attack_speed_bonus = attack_speed_bonus;
        this.reach_bonus = reach_bonus;
        this.enchantability = enchantability;
        this.repair_ingredient = repair_ingredient;
    }

    private TagKey<Item> createRepairIngredientTagKey(String repairIngredient) {
        Object tagReference = repairIngredient.startsWith("#") ? repairIngredient.substring(1) : "basicweapons:" + this.material_name + "_tool_materials";
        ResourceLocation identifier = ResourceLocation.bySeparator((String)tagReference, (char)':');
        return TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)identifier);
    }

    public ToolMaterial createToolMaterial() {
        return new ToolMaterial(BlockTags.INCORRECT_FOR_STONE_TOOL, this.durability, this.mining_speed, this.attack_damage_bonus, this.enchantability, this.createRepairIngredientTagKey(this.repair_ingredient));
    }

    public float getMiningSpeed() {
        return this.mining_speed;
    }

    public float getAttackSpeedBonus() {
        return this.attack_speed_bonus;
    }

    public float getReachBonus() {
        return this.reach_bonus;
    }
}

