/*
 * Decompiled with CFR 0.152.
 */
package com.khazoda.basicweapons.mixin;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemStack.class})
public abstract class ItemStackMixin {
    @Unique
    private static final ThreadLocal<DecimalFormat> COMPONENT_FORMAT = ThreadLocal.withInitial(() -> new DecimalFormat("#.##", DecimalFormatSymbols.getInstance(Locale.ROOT)));

    @Inject(method={"getTooltipLines"}, at={@At(value="RETURN")})
    private void fixDamageTooltip(Item.TooltipContext tooltipContext, @Nullable Player player, TooltipFlag tooltipFlag, CallbackInfoReturnable<List<Component>> cir) {
        ItemStack stack = (ItemStack)this;
        List tooltip = (List)cir.getReturnValue();
        if (stack.isEmpty()) {
            return;
        }
        float damageBonus = this.basicweapons$calculateDamageBonus(stack);
        if (damageBonus <= 0.0f) {
            return;
        }
        for (int i = 0; i < tooltip.size(); ++i) {
            Component line = (Component)tooltip.get(i);
            List siblings = line.getSiblings();
            for (int j = 0; j < siblings.size(); ++j) {
                Component sibling = (Component)siblings.get(j);
                ComponentContents componentContents = sibling.getContents();
                if (!(componentContents instanceof TranslatableContents)) continue;
                TranslatableContents translatable = (TranslatableContents)componentContents;
                String key = translatable.getKey();
                Object[] args = translatable.getArgs();
                if (!"attribute.modifier.plus.0".equals(key) && !"attribute.modifier.equals.0".equals(key) || args.length < 2 || !this.basicweapons$isAttackDamage(args[1])) continue;
                try {
                    String currentAmountStr = args[0].toString().replace(",", ".");
                    double currentAmount = Double.parseDouble(currentAmountStr);
                    double newAmount = currentAmount + (double)damageBonus;
                    MutableComponent newSibling = Component.translatable((String)key, (Object[])new Object[]{COMPONENT_FORMAT.get().format(newAmount), args[1]}).withStyle(ChatFormatting.DARK_GREEN);
                    MutableComponent newLine = line.plainCopy();
                    for (int k = 0; k < siblings.size(); ++k) {
                        if (k == j) {
                            newLine.append((Component)newSibling);
                            continue;
                        }
                        newLine.append((Component)siblings.get(k));
                    }
                    tooltip.set(i, newLine);
                    return;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    @Unique
    private boolean basicweapons$isAttackDamage(Object nameArg) {
        if (nameArg instanceof Component) {
            TranslatableContents tc;
            String key;
            Component nameComponent = (Component)nameArg;
            ComponentContents componentContents = nameComponent.getContents();
            if (componentContents instanceof TranslatableContents && "attribute.name.attack_damage".equals(key = (tc = (TranslatableContents)componentContents).getKey())) {
                return true;
            }
            String localizedName = Component.translatable((String)"attribute.name.attack_damage").getString();
            return nameComponent.getString().contains(localizedName);
        }
        return false;
    }

    @Unique
    private float basicweapons$calculateDamageBonus(ItemStack stack) {
        ItemEnchantments enchantments = stack.getEnchantments();
        if (enchantments.isEmpty()) {
            return 0.0f;
        }
        float totalBonus = 0.0f;
        for (Map.Entry entry : enchantments.entrySet()) {
            Optional keyOpt = ((Holder)entry.getKey()).unwrapKey();
            if (!keyOpt.isPresent()) continue;
            String id = ((ResourceKey)keyOpt.get()).location().toString();
            int level = (Integer)entry.getValue();
            if (level <= 0 || !"minecraft:sharpness".equals(id) && !"basicweapons:might".equals(id)) continue;
            totalBonus += 0.5f * (float)level + 0.5f;
        }
        return totalBonus;
    }
}

