/*
 * Decompiled with CFR 0.152.
 */
package com.khazoda.basicweapons.registry;

import com.khazoda.basicweapons.BasicWeaponsCommon;
import com.khazoda.basicweapons.Constants;
import com.khazoda.basicweapons.material.ConditionalToolMaterials;
import com.khazoda.basicweapons.materialpack.MaterialPackLoader;
import com.khazoda.basicweapons.struct.WeaponType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ToolMaterial;

public class WeaponRegistry {
    private static final Map<String, Supplier<Item>> ITEMS = new LinkedHashMap<String, Supplier<Item>>();
    private static final Map<WeaponType.WeaponTypeInterface, List<Supplier<Item>>> ALL_ITEMS_BY_TYPE = new HashMap<WeaponType.WeaponTypeInterface, List<Supplier<Item>>>();
    private static final Map<WeaponType.WeaponTypeInterface, List<Supplier<Item>>> BUILTIN_ITEMS_BY_TYPE = new HashMap<WeaponType.WeaponTypeInterface, List<Supplier<Item>>>();
    private static final Map<WeaponType.WeaponTypeInterface, List<Supplier<Item>>> MATERIALPACK_ITEMS_BY_TYPE = new HashMap<WeaponType.WeaponTypeInterface, List<Supplier<Item>>>();
    private static final Map<ToolMaterial, List<Supplier<Item>>> ITEMS_BY_MATERIAL = new HashMap<ToolMaterial, List<Supplier<Item>>>();
    public static final List<MaterialEntry> VANILLA_MATERIALS = Arrays.asList(new MaterialEntry(ToolMaterial.WOOD, "wooden"), new MaterialEntry(ToolMaterial.STONE, "stone"), new MaterialEntry(ToolMaterial.COPPER, "copper"), new MaterialEntry(ToolMaterial.IRON, "iron"), new MaterialEntry(ToolMaterial.GOLD, "golden"), new MaterialEntry(ToolMaterial.DIAMOND, "diamond"), new MaterialEntry(ToolMaterial.NETHERITE, "netherite", Item.Properties::fireResistant));
    public static final List<MaterialEntry> COMPAT_MATERIALS = Arrays.asList(new MaterialEntry(ConditionalToolMaterials.BRONZE, "bronze"), new MaterialEntry(ConditionalToolMaterials.TIN, "tin"));

    public static void init() {
        for (MaterialEntry material : VANILLA_MATERIALS) {
            WeaponRegistry.registerAllWeaponsForMaterial(material);
        }
        if (BasicWeaponsCommon.bronze_mod_loaded) {
            for (MaterialEntry material : COMPAT_MATERIALS) {
                WeaponRegistry.registerAllWeaponsForMaterial(material);
            }
        }
    }

    public static void registerWeaponForMaterial(WeaponType.WeaponTypeInterface type, MaterialEntry material) {
        String itemId = material.prefix() + "_" + type.getId();
        Item.Properties itemSettings = material.settingsModifier().apply(new Item.Properties());
        float damageModifier = WeaponType.getDamageModifier(type, material.material());
        float speedModifier = WeaponType.getSpeedModifier(type, material.material());
        float reachModifier = WeaponType.getReachModifier(type, material.material());
        ResourceKey resourceKey = ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)Constants.ID(itemId));
        Item.Properties finalProperties = itemSettings.setId(resourceKey);
        Supplier<Item> itemSupplier = BasicWeaponsCommon.ITEM_REGISTRAR.register(itemId, () -> type.create(material.material, damageModifier, speedModifier, reachModifier, finalProperties));
        ITEMS.put(itemId, itemSupplier);
        if (VANILLA_MATERIALS.contains(material) || COMPAT_MATERIALS.contains(material)) {
            BUILTIN_ITEMS_BY_TYPE.computeIfAbsent(type, k -> new ArrayList()).add(itemSupplier);
        } else {
            MATERIALPACK_ITEMS_BY_TYPE.computeIfAbsent(type, k -> new ArrayList()).add(itemSupplier);
        }
        ALL_ITEMS_BY_TYPE.computeIfAbsent(type, k -> new ArrayList()).add(itemSupplier);
        ITEMS_BY_MATERIAL.computeIfAbsent(material.material(), k -> new ArrayList()).add(itemSupplier);
    }

    public static void registerAllWeaponsForMaterial(MaterialEntry material) {
        for (WeaponType.BasicWeaponType type : WeaponType.BasicWeaponType.values()) {
            WeaponRegistry.registerWeaponForMaterial(type, material);
        }
    }

    public static void registerAllWeaponsForMaterialPackMaterial(String materialName) {
        ToolMaterial material = MaterialPackLoader.getMaterial(materialName);
        MaterialEntry materialEntry = new MaterialEntry(material, materialName);
        WeaponRegistry.registerAllWeaponsForMaterial(materialEntry);
        for (WeaponType.VanillaWeaponType type : WeaponType.VanillaWeaponType.values()) {
            if (!MaterialPackLoader.hasTextureForWeaponType(materialName, type.getId())) continue;
            WeaponRegistry.registerWeaponForMaterial(type, materialEntry);
        }
    }

    public static List<Item> getItemsByType(ITEMS_BY_TYPE selection, WeaponType.WeaponTypeInterface type) {
        switch (selection.ordinal()) {
            case 1: {
                return BUILTIN_ITEMS_BY_TYPE.getOrDefault(type, Collections.emptyList()).stream().map(Supplier::get).filter(Objects::nonNull).toList();
            }
            case 2: {
                return MATERIALPACK_ITEMS_BY_TYPE.getOrDefault(type, Collections.emptyList()).stream().map(Supplier::get).filter(Objects::nonNull).toList();
            }
        }
        return ALL_ITEMS_BY_TYPE.getOrDefault(type, Collections.emptyList()).stream().map(Supplier::get).filter(Objects::nonNull).toList();
    }

    public static List<Item> getItemsByMaterial(ToolMaterial material) {
        return ITEMS_BY_MATERIAL.getOrDefault(material, Collections.emptyList()).stream().map(Supplier::get).filter(Objects::nonNull).toList();
    }

    public record MaterialEntry(ToolMaterial material, String prefix, Function<Item.Properties, Item.Properties> settingsModifier) {
        public MaterialEntry(ToolMaterial material, String prefix) {
            this(material, prefix, settings -> settings);
        }
    }

    public static enum ITEMS_BY_TYPE {
        ALL,
        BUILTIN,
        MATERIALPACK;

    }
}

