/*
 * Decompiled with CFR 0.152.
 */
package com.khazoda.basicweapons.materialpack;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.khazoda.basicweapons.Constants;
import com.khazoda.basicweapons.materialpack.EarlyLoadedMaterial;
import com.khazoda.basicweapons.materialpack.MaterialPackConstants;
import com.khazoda.basicweapons.platform.Services;
import com.khazoda.basicweapons.registry.WeaponRegistry;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.class_9886;
import org.apache.commons.io.FileUtils;

public class MaterialPackLoader {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final Map<String, EarlyLoadedMaterial> loadedMaterials = new HashMap<String, EarlyLoadedMaterial>();
    private static final Map<class_9886, EarlyLoadedMaterial> toolMaterialMap = new HashMap<class_9886, EarlyLoadedMaterial>();
    private static final Map<String, String> materialToDatapackName = new HashMap<String, String>();
    private static final Map<String, File> materialToPackFolder = new HashMap<String, File>();
    private static final Set<String> initiallyLoadedPacks = new HashSet<String>();
    private static boolean hasInitialized = false;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void loadPacks() {
        if (hasInitialized) {
            Constants.LOG.warn("Attempted to load material packs after initialization - skipping");
            return;
        }
        File materialPacksFolder = new File(MaterialPackConstants.MATERIALPACK_SOURCE);
        File[] packFiles = materialPacksFolder.listFiles(file -> file.isDirectory() || file.getName().endsWith(".zip"));
        if (!materialPacksFolder.exists()) {
            if (!materialPacksFolder.mkdir()) {
                Constants.LOG.error("Failed to create basicweapons_materials folder. This should never happen.");
                return;
            }
            Constants.LOG.info("Created material packs folder {}", (Object)materialPacksFolder.getName());
        } else {
            File resourcepacksFolder = new File(MaterialPackConstants.RESOURCEPACK_TARGET);
            File datapacksFolder = new File(MaterialPackConstants.DATAPACK_TARGET);
            MaterialPackLoader.createFolder(resourcepacksFolder);
            MaterialPackLoader.createFolder(datapacksFolder);
            MaterialPackLoader.cleanTargetFolders();
        }
        if (packFiles == null || packFiles.length == 0) {
            Constants.LOG.info("No material packs found in {}", (Object)materialPacksFolder.getName());
            return;
        }
        File[] fileArray = packFiles;
        int n = fileArray.length;
        int n2 = 0;
        while (true) {
            if (n2 >= n) {
                Constants.LOG.info("Loaded the following material packs: [{}]", (Object)initiallyLoadedPacks.stream().map(Object::toString).collect(Collectors.joining(", ")));
                hasInitialized = true;
                return;
            }
            File packFile = fileArray[n2];
            String packName = packFile.getName();
            if (packFile.isDirectory()) {
                MaterialPackLoader.processPackFolder(packFile);
            } else {
                File extractDir = new File(materialPacksFolder, packName.substring(0, packName.length() - 4));
                try {
                    if (extractDir.exists()) {
                        FileUtils.deleteDirectory((File)extractDir);
                    }
                    MaterialPackLoader.extractZip(packFile, extractDir);
                    MaterialPackLoader.processPackFolder(extractDir);
                    FileUtils.deleteDirectory((File)extractDir);
                }
                catch (IOException e) {
                    Constants.LOG.error("Failed to process ZIP pack {}: {}.", (Object)packName, (Object)e.getMessage());
                }
            }
            ++n2;
        }
    }

    private static void processPackFolder(File packFolder) {
        if (!MaterialPackLoader.loadMaterialsFromPack(packFolder)) {
            return;
        }
        MaterialPackLoader.copyResourcePackContent(packFolder);
        MaterialPackLoader.copyDataPackContent(packFolder);
        initiallyLoadedPacks.add(packFolder.getName());
    }

    private static void extractZip(File zipFile, File targetDir) throws IOException {
        try (ZipFile zip = new ZipFile(zipFile);){
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                File entryFile = new File(targetDir, entry.getName());
                if (entry.isDirectory()) {
                    entryFile.mkdirs();
                    continue;
                }
                entryFile.getParentFile().mkdirs();
                InputStream in = zip.getInputStream(entry);
                try (FileOutputStream out = new FileOutputStream(entryFile);){
                    int len;
                    byte[] buffer = new byte[1024];
                    while ((len = in.read(buffer)) > 0) {
                        out.write(buffer, 0, len);
                    }
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
        }
    }

    private static void copyResourcePackContent(File packFolder) {
        File assetsFolder = new File(packFolder, MaterialPackConstants.ASSETS_PATH);
        if (!assetsFolder.exists()) {
            return;
        }
        File resourcepacksFolder = new File(MaterialPackConstants.RESOURCEPACK_TARGET);
        MaterialPackLoader.createFolder(resourcepacksFolder);
        File targetFolder = new File(resourcepacksFolder, packFolder.getName());
        try {
            File sourcePackMcmeta;
            File packIcon;
            File[] assetContents = assetsFolder.listFiles(file -> !file.getName().equals("pack.mcmeta"));
            if (assetContents != null) {
                for (File file2 : assetContents) {
                    if (file2.isDirectory()) {
                        MaterialPackLoader.copyDirectoryFiltered(file2, new File(targetFolder, MaterialPackConstants.ASSETS_PATH + "/" + file2.getName()), packFolder);
                        continue;
                    }
                    if (MaterialPackLoader.shouldSkipSwordAxeFile(file2.getName(), packFolder)) continue;
                    FileUtils.copyFile((File)file2, (File)new File(targetFolder, MaterialPackConstants.ASSETS_PATH + "/" + file2.getName()));
                }
            }
            if ((packIcon = new File(packFolder, "pack.png")).exists()) {
                FileUtils.copyFile((File)packIcon, (File)new File(targetFolder, "pack.png"));
            }
            if ((sourcePackMcmeta = new File(assetsFolder, "pack.mcmeta")).exists()) {
                FileUtils.copyFile((File)sourcePackMcmeta, (File)new File(targetFolder, "pack.mcmeta"));
            } else {
                Constants.LOG.warn("No pack.mcmeta found in assets folder for {}", (Object)packFolder.getName());
            }
        }
        catch (IOException e) {
            Constants.LOG.error("Failed to copy resourcepack content from {}: {}", (Object)packFolder.getName(), (Object)e.getMessage());
        }
    }

    private static void copyDataPackContent(File packFolder) {
        File dataFolder = new File(packFolder, MaterialPackConstants.DATA_PATH);
        if (!dataFolder.exists()) {
            return;
        }
        File datapacksFolder = new File(MaterialPackConstants.DATAPACK_TARGET);
        MaterialPackLoader.createFolder(datapacksFolder);
        File targetFolder = new File(datapacksFolder, packFolder.getName());
        try {
            File sourcePackMcmeta;
            File packIcon;
            File[] dataContents = dataFolder.listFiles(file -> !file.getName().equals("pack.mcmeta"));
            if (dataContents != null) {
                for (File file2 : dataContents) {
                    if (file2.isDirectory()) {
                        MaterialPackLoader.copyDirectoryFiltered(file2, new File(targetFolder, MaterialPackConstants.DATA_PATH + "/" + file2.getName()), packFolder);
                        continue;
                    }
                    if (MaterialPackLoader.shouldSkipSwordAxeFile(file2.getName(), packFolder)) continue;
                    FileUtils.copyFile((File)file2, (File)new File(targetFolder, MaterialPackConstants.DATA_PATH + "/" + file2.getName()));
                }
            }
            if ((packIcon = new File(packFolder, "pack.png")).exists()) {
                FileUtils.copyFile((File)packIcon, (File)new File(targetFolder, "pack.png"));
            }
            if ((sourcePackMcmeta = new File(dataFolder, "pack.mcmeta")).exists()) {
                FileUtils.copyFile((File)sourcePackMcmeta, (File)new File(targetFolder, "pack.mcmeta"));
            } else {
                Constants.LOG.warn("No pack.mcmeta found in data folder for {}", (Object)packFolder.getName());
            }
        }
        catch (IOException e) {
            Constants.LOG.error("Failed to copy datapack content from {}: {}", (Object)packFolder.getName(), (Object)e.getMessage());
        }
    }

    private static void copyDirectoryFiltered(File sourceDir, File targetDir, File packFolder) throws IOException {
        File[] files;
        if (!targetDir.exists()) {
            targetDir.mkdirs();
        }
        if ((files = sourceDir.listFiles()) == null) {
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                MaterialPackLoader.copyDirectoryFiltered(file, new File(targetDir, file.getName()), packFolder);
                continue;
            }
            if (MaterialPackLoader.shouldSkipSwordAxeFile(file.getName(), packFolder)) continue;
            FileUtils.copyFile((File)file, (File)new File(targetDir, file.getName()));
        }
    }

    private static boolean shouldSkipSwordAxeFile(String fileName, File packFolder) {
        if (!fileName.endsWith("_sword.json") && !fileName.endsWith("_axe.json")) {
            return false;
        }
        String itemName = fileName.substring(0, fileName.length() - 5);
        String weaponType = itemName.endsWith("_sword") ? "sword" : "axe";
        String materialName = itemName.substring(0, itemName.length() - weaponType.length() - 1);
        File textureFile = new File(packFolder, MaterialPackConstants.ASSETS_PATH + "/basicweapons/textures/item/" + materialName + "_" + weaponType + ".png");
        return !textureFile.exists();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean loadMaterialsFromPack(File packFolder) {
        File materialFolder;
        File requirementsFile = new File(packFolder, "loading_requirements.json");
        if (requirementsFile.exists()) {
            try (BufferedReader reader = new BufferedReader(new FileReader(requirementsFile));){
                String requiredMod;
                JsonObject json = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                if (json.has("requires_mod") && !(requiredMod = json.get("requires_mod").getAsString()).isEmpty() && !Services.PLATFORM.isModLoaded(requiredMod)) {
                    Constants.LOG.info("Skipping material pack {} - required mod {} is not loaded", (Object)packFolder.getName(), (Object)requiredMod);
                    boolean bl = false;
                    return bl;
                }
            }
            catch (Exception e) {
                Constants.LOG.error("Failed to read loading requirements for pack {}: {}. It won't be enabled.", (Object)packFolder.getName(), (Object)e.getMessage());
                return false;
            }
        }
        if (!(materialFolder = new File(packFolder, MaterialPackConstants.CUSTOM_MATERIALS_PATH)).exists()) {
            Constants.LOG.warn("Pack {} does not contain materials at expected path", (Object)packFolder.getName());
            return false;
        }
        File[] materialFiles = materialFolder.listFiles((dir, name) -> name.endsWith(".json"));
        if (materialFiles == null || materialFiles.length == 0) {
            Constants.LOG.warn("No material files found in pack {}", (Object)packFolder.getName());
            return false;
        }
        File[] fileArray = materialFiles;
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            try (BufferedReader reader = new BufferedReader(new FileReader(file));){
                JsonObject json = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                String material_name = json.get("material_name").getAsString();
                int durability = json.get("durability").getAsInt();
                float attack_damage_bonus = json.get("attack_damage_bonus").getAsFloat();
                boolean hasMiningSpeed = json.has("mining_speed");
                float mining_speed = hasMiningSpeed ? json.get("mining_speed").getAsFloat() : json.get("attack_speed_bonus").getAsFloat();
                float attack_speed_bonus = hasMiningSpeed && json.has("attack_speed_bonus") ? json.get("attack_speed_bonus").getAsFloat() : 0.0f;
                float reach_bonus = json.get("reach_bonus").getAsFloat();
                int enchantability = json.get("enchantability").getAsInt();
                String repair_ingredient = json.get("repair_ingredient").getAsString();
                EarlyLoadedMaterial material = new EarlyLoadedMaterial(material_name, durability, attack_damage_bonus, mining_speed, attack_speed_bonus, reach_bonus, enchantability, repair_ingredient);
                class_9886 toolMaterial = material.createToolMaterial();
                toolMaterialMap.put(toolMaterial, material);
                loadedMaterials.put(material_name, material);
                materialToDatapackName.put(material_name, packFolder.getName());
                materialToPackFolder.put(material_name, packFolder);
                Constants.LOG.info("[{}] material loaded.", (Object)material_name);
                WeaponRegistry.registerAllWeaponsForMaterialPackMaterial(material_name);
            }
            catch (Exception e) {
                Constants.LOG.error("Failed to load material file {} from pack {}: {}", new Object[]{file.getName(), packFolder.getName(), e.getMessage()});
            }
            ++n2;
        }
        return true;
    }

    public static class_9886 getMaterial(String name) {
        EarlyLoadedMaterial material = loadedMaterials.get(name);
        return material != null ? material.createToolMaterial() : null;
    }

    public static Collection<String> getMaterialNames() {
        return loadedMaterials.keySet();
    }

    public static Collection<String> getDatapackNames() {
        return materialToDatapackName.values();
    }

    public static boolean wasPackLoadedInitially(String packName) {
        return initiallyLoadedPacks.contains(packName);
    }

    public static float getMiningSpeed(class_9886 toolMaterial) {
        EarlyLoadedMaterial material = toolMaterialMap.get(toolMaterial);
        return material != null ? material.getMiningSpeed() : 0.0f;
    }

    public static float getAttackSpeedBonus(class_9886 toolMaterial) {
        EarlyLoadedMaterial material = toolMaterialMap.get(toolMaterial);
        return material != null ? material.getAttackSpeedBonus() : 0.0f;
    }

    public static float getReachBonus(class_9886 toolMaterial) {
        EarlyLoadedMaterial material = toolMaterialMap.get(toolMaterial);
        return material != null ? material.getReachBonus() : 0.0f;
    }

    public static boolean hasTextureForWeaponType(String materialName, String weaponTypeId) {
        File packFolder = materialToPackFolder.get(materialName);
        if (packFolder == null) {
            return false;
        }
        String texturePath = MaterialPackConstants.ASSETS_PATH + "/basicweapons/textures/item/" + materialName + "_" + weaponTypeId + ".png";
        File textureFile = new File(packFolder, texturePath);
        return textureFile.exists() && textureFile.isFile();
    }

    private static boolean createFolder(File folder) {
        if (!folder.exists()) {
            return folder.mkdirs();
        }
        return false;
    }

    private static void cleanTargetFolders() {
        if (!MaterialPackLoader.ableToDeleteDirectory(new File(MaterialPackConstants.RESOURCEPACK_TARGET))) {
            Constants.LOG.error("Failed to clean bwmp_resources target folder. This is probably fine but if you experience issues please report this on the Basic Weapons issue tracker.");
        }
        if (!MaterialPackLoader.ableToDeleteDirectory(new File(MaterialPackConstants.DATAPACK_TARGET))) {
            Constants.LOG.error("Failed to clean bwmp_data target folder. This is probably fine but if you experience issues please report this on the Basic Weapons issue tracker.");
        }
    }

    private static boolean ableToDeleteDirectory(File dir) {
        if (dir.exists()) {
            try {
                FileUtils.deleteDirectory((File)dir);
                return true;
            }
            catch (IOException e) {
                return false;
            }
        }
        return false;
    }
}

