/*
 * Decompiled with CFR 0.152.
 */
package com.khazoda.basicweapons.registry;

import com.khazoda.basicweapons.BasicWeaponsCommon;
import com.khazoda.basicweapons.Constants;
import com.khazoda.basicweapons.material.ConditionalToolMaterials;
import com.khazoda.basicweapons.materialpack.MaterialPackLoader;
import com.khazoda.basicweapons.struct.WeaponType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.class_9886;

public class WeaponRegistry {
    private static final Map<String, Supplier<class_1792>> ITEMS = new LinkedHashMap<String, Supplier<class_1792>>();
    private static final Map<WeaponType.WeaponTypeInterface, List<Supplier<class_1792>>> ALL_ITEMS_BY_TYPE = new HashMap<WeaponType.WeaponTypeInterface, List<Supplier<class_1792>>>();
    private static final Map<WeaponType.WeaponTypeInterface, List<Supplier<class_1792>>> BUILTIN_ITEMS_BY_TYPE = new HashMap<WeaponType.WeaponTypeInterface, List<Supplier<class_1792>>>();
    private static final Map<WeaponType.WeaponTypeInterface, List<Supplier<class_1792>>> MATERIALPACK_ITEMS_BY_TYPE = new HashMap<WeaponType.WeaponTypeInterface, List<Supplier<class_1792>>>();
    private static final Map<class_9886, List<Supplier<class_1792>>> ITEMS_BY_MATERIAL = new HashMap<class_9886, List<Supplier<class_1792>>>();
    public static final List<MaterialEntry> VANILLA_MATERIALS = Arrays.asList(new MaterialEntry(class_9886.field_52585, "wooden"), new MaterialEntry(class_9886.field_52586, "stone"), new MaterialEntry(class_9886.field_61350, "copper"), new MaterialEntry(class_9886.field_52587, "iron"), new MaterialEntry(class_9886.field_52589, "golden"), new MaterialEntry(class_9886.field_52588, "diamond"), new MaterialEntry(class_9886.field_52590, "netherite", class_1792.class_1793::method_24359));
    public static final MaterialEntry BRONZE_MATERIAL_ENTRY = new MaterialEntry(ConditionalToolMaterials.BRONZE, "bronze");

    public static void init() {
        for (MaterialEntry material : VANILLA_MATERIALS) {
            WeaponRegistry.registerAllWeaponsForMaterial(material);
        }
        if (BasicWeaponsCommon.bronze_mod_loaded) {
            WeaponRegistry.registerAllWeaponsForMaterial(BRONZE_MATERIAL_ENTRY);
        }
    }

    public static void registerWeaponForMaterial(WeaponType.WeaponTypeInterface type, MaterialEntry material) {
        String itemId = material.prefix() + "_" + type.getId();
        class_1792.class_1793 itemSettings = material.settingsModifier().apply(new class_1792.class_1793());
        float damageModifier = WeaponType.getDamageModifier(type, material.material());
        float speedModifier = WeaponType.getSpeedModifier(type, material.material());
        float reachModifier = WeaponType.getReachModifier(type, material.material());
        class_5321 resourceKey = class_5321.method_29179((class_5321)class_7924.field_41197, (class_2960)Constants.ID(itemId));
        class_1792.class_1793 finalProperties = itemSettings.method_63686(resourceKey);
        Supplier<class_1792> itemSupplier = BasicWeaponsCommon.ITEM_REGISTRAR.register(itemId, () -> type.create(material.material, damageModifier, speedModifier, reachModifier, finalProperties));
        ITEMS.put(itemId, itemSupplier);
        if (VANILLA_MATERIALS.contains(material)) {
            BUILTIN_ITEMS_BY_TYPE.computeIfAbsent(type, k -> new ArrayList()).add(itemSupplier);
        } else {
            MATERIALPACK_ITEMS_BY_TYPE.computeIfAbsent(type, k -> new ArrayList()).add(itemSupplier);
        }
        ALL_ITEMS_BY_TYPE.computeIfAbsent(type, k -> new ArrayList()).add(itemSupplier);
        ITEMS_BY_MATERIAL.computeIfAbsent(material.material(), k -> new ArrayList()).add(itemSupplier);
    }

    public static void registerAllWeaponsForMaterial(MaterialEntry material) {
        for (WeaponType.BasicWeaponType type : WeaponType.BasicWeaponType.values()) {
            WeaponRegistry.registerWeaponForMaterial(type, material);
        }
    }

    public static void registerAllWeaponsForMaterialPackMaterial(String materialName) {
        class_9886 material = MaterialPackLoader.getMaterial(materialName);
        MaterialEntry materialEntry = new MaterialEntry(material, materialName);
        WeaponRegistry.registerAllWeaponsForMaterial(materialEntry);
        for (WeaponType.VanillaWeaponType type : WeaponType.VanillaWeaponType.values()) {
            if (!MaterialPackLoader.hasTextureForWeaponType(materialName, type.getId())) continue;
            WeaponRegistry.registerWeaponForMaterial(type, materialEntry);
        }
    }

    public static List<class_1792> getItemsByType(ITEMS_BY_TYPE selection, WeaponType.WeaponTypeInterface type) {
        switch (selection.ordinal()) {
            case 1: {
                return BUILTIN_ITEMS_BY_TYPE.getOrDefault(type, Collections.emptyList()).stream().map(Supplier::get).filter(Objects::nonNull).toList();
            }
            case 2: {
                return MATERIALPACK_ITEMS_BY_TYPE.getOrDefault(type, Collections.emptyList()).stream().map(Supplier::get).filter(Objects::nonNull).toList();
            }
        }
        return ALL_ITEMS_BY_TYPE.getOrDefault(type, Collections.emptyList()).stream().map(Supplier::get).filter(Objects::nonNull).toList();
    }

    public static List<class_1792> getItemsByMaterial(class_9886 material) {
        return ITEMS_BY_MATERIAL.getOrDefault(material, Collections.emptyList()).stream().map(Supplier::get).filter(Objects::nonNull).toList();
    }

    public record MaterialEntry(class_9886 material, String prefix, Function<class_1792.class_1793, class_1792.class_1793> settingsModifier) {
        public MaterialEntry(class_9886 material, String prefix) {
            this(material, prefix, settings -> settings);
        }
    }

    public static enum ITEMS_BY_TYPE {
        ALL,
        BUILTIN,
        MATERIALPACK;

    }
}

