package com.swacky.ohmega.network.S2C;

import com.swacky.ohmega.api.AccessoryHelper;
import com.swacky.ohmega.network.BasePacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.VarInt;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.network.CustomPayloadEvent;
import org.jetbrains.annotations.NotNull;

import java.util.List;

public class SyncAccessorySlotsPacket extends BasePacket {
    public static final StreamCodec<RegistryFriendlyByteBuf, SyncAccessorySlotsPacket> CODEC = StreamCodec.composite(
            ByteBufCodecs.INT,
            inst -> inst.playerId,
            new StreamCodec<>() {
                @Override
                public int @NotNull [] decode(@NotNull RegistryFriendlyByteBuf buf) {
                    int size = VarInt.read(buf);

                    int[] values = new int[size];

                    for (int i = 0; i < size; i++) {
                        values[i] = VarInt.read(buf);
                    }

                    return values;
                }

                @Override
                public void encode(@NotNull RegistryFriendlyByteBuf buf, int @NotNull [] values) {
                    VarInt.write(buf, values.length);

                    for (int value : values) {
                        VarInt.write(buf, value);
                    }
                }
            },
            inst -> inst.slots,
            ItemStack.OPTIONAL_LIST_STREAM_CODEC,
            inst -> inst.stacks,
            SyncAccessorySlotsPacket::new
    );

    private final int playerId;
    private final int[] slots;
    private final List<ItemStack> stacks;

    public SyncAccessorySlotsPacket(int playerId, int[] slots, List<ItemStack> stacks) {
        if (slots.length != stacks.size()) {
            throw new IllegalArgumentException("Mismatched int slot array size of " + slots.length + " and ItemStack size of " + stacks.size());
        }
        this.playerId = playerId;
        this.slots = slots;
        this.stacks = stacks;
    }

    public static void handle(SyncAccessorySlotsPacket packet, CustomPayloadEvent.Context context) {
        if (packet.slots.length == 0) {
            return;
        }

        context.enqueueWork(() -> {
            ClientLevel level = Minecraft.getInstance().level;
            if (level != null) {
                if (level.getEntity(packet.playerId) instanceof Player player) {
                    for (int[] i = {0}; i[0] < packet.slots.length; i[0]++) {
                        AccessoryHelper.getContainer(player).ifPresent(a -> a.setStackInSlot(packet.slots[i[0]], packet.stacks.get(i[0])));
                    }
                }
            }
        });
    }

    @Override
    protected String getId() {
        return "sync_accessory_slots";
    }
}
