package com.swacky.ohmega.api.event;

import com.google.common.collect.ImmutableMap;
import com.swacky.ohmega.common.accessorytype.AccessoryType;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1792;
import java.util.Map;

public interface AccessoryOverrideTypesCallback {
    Event<AccessoryOverrideTypesCallback> EVENT = EventFactory.createArrayBacked(AccessoryOverrideTypesCallback.class,
        listeners -> (overrideRemaps) -> {
            ImmutableMap.Builder<class_1792, AccessoryType> builder = new ImmutableMap.Builder<>();
            for (AccessoryOverrideTypesCallback listener : listeners) {
                builder.putAll(listener.process(ImmutableMap.copyOf(overrideRemaps)));
            }
            return builder.build();
        }
    );

    Map<class_1792, AccessoryType> process(ImmutableMap<class_1792, AccessoryType> view);
}
