package com.swacky.ohmega.api.event;

import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1657;
import net.minecraft.class_1799;

@SuppressWarnings("removal")
public interface AccessoryUseCallback {
    Event<AccessoryUseCallback> EVENT = EventFactory.createArrayBacked(AccessoryUseCallback.class,
            listeners -> (player, stack) -> {
                for (AccessoryUseCallback listener : listeners) {
                    EventResult result = listener.process(player, stack);

                    if (result.isCanceled()) {
                        return result;
                    }
                }
                return EventResult.PASS;
            }
    );

    EventResult process(class_1657 player, class_1799 stack);
}
