package com.swacky.ohmega.client.screen;

import com.swacky.ohmega.config.OhmegaConfig;
import com.swacky.ohmega.network.C2S.OpenAccessoryInventoryPacket;
import com.swacky.ohmega.network.C2S.OpenInventoryPacket;
import com.swacky.ohmega.common.OhmegaCommon;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_10799;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4264;
import net.minecraft.class_465;
import net.minecraft.class_490;
import net.minecraft.class_5250;
import net.minecraft.class_6382;
import net.minecraft.class_8828;
import org.jetbrains.annotations.NotNull;

public class AccessoryInventoryButton extends class_4264 {
    protected final class_310 mc;
    private final class_465<?> screen;
    protected final int x;
    protected final int y;
    protected final int uOffs;
    protected final int vOffs;
    protected final boolean shouldUseWidthHovered;
    public AccessoryInventoryButton(OhmegaConfig.ButtonStyle style, class_465<?> screen) {
        super(screen.field_2776 + style.getX(), screen.field_2800 + style.getY(), style.getWidth(), style.getHeight(), class_5250.method_43477(class_8828.field_46625));
        this.mc = screen.field_22787;
        this.screen = screen;
        this.x = style.getX();
        this.y = style.getY();
        this.uOffs = style.getUOffs();
        this.vOffs = style.getVOffs();
        this.shouldUseWidthHovered = style.shouldUseWidthHovered();
    }

    private boolean isVisible() {
        return this.field_22764 && (this.screen instanceof AccessoryInventoryScreen || (this.screen instanceof class_490 inventoryScreen && !inventoryScreen.field_54474.method_2605()));
    }

    private void fixPos() {
        this.method_46421(this.screen.field_2776 + this.x);
        this.method_46419(this.screen.field_2800 + this.y);
    }

    @Override
    protected boolean method_25351(int button) {
        return this.isVisible() && super.method_25351(button);
    }

    @Override
    public void method_25306() {
        if (mc.field_1724 != null) {
            if (!mc.field_1724.method_68878() && !mc.field_1724.method_7325()) {
                if (mc.field_1755 instanceof AccessoryInventoryScreen) {
                    mc.field_1724.field_7512 = mc.field_1724.field_7498;
                    mc.method_1507(new class_490(mc.field_1724));
                    ClientPlayNetworking.send(new OpenInventoryPacket());
                } else {
                    ClientPlayNetworking.send(new OpenAccessoryInventoryPacket());
                }
            } else {
                mc.field_1724.field_7512 = mc.field_1724.field_7498;
                mc.method_1507(new class_490(mc.field_1724));
                ClientPlayNetworking.send(new OpenInventoryPacket());
            }
        }
    }

    @Override
    public void method_47399(@NotNull class_6382 output) {
        this.method_37021(output);
    }

    @Override
    public void method_48579(@NotNull class_332 gui, int pMouseX, int pMouseY, float pPartialTick) {
        if (this.isVisible()) {
            this.fixPos();
            int hoveredOffsX;
            int hoveredOffsY;
            if (this.method_25367()) {
                if (this.shouldUseWidthHovered) {
                    hoveredOffsX = this.field_22758;
                    hoveredOffsY = 0;
                } else {
                    hoveredOffsX = 0;
                    hoveredOffsY = this.field_22759;
                }
            } else {
                hoveredOffsX = 0;
                hoveredOffsY = 0;
            }

            gui.method_25290(class_10799.field_56883, OhmegaCommon.ACCESSORY_LOCATION, this.method_46426(), this.method_46427(), (float) this.uOffs + hoveredOffsX, (float) this.vOffs + hoveredOffsY, this.field_22758, this.field_22759, 26, 71);
        }
    }
}
