package com.swacky.ohmega.client.screen;

import com.swacky.ohmega.api.AccessoryHelper;
import com.swacky.ohmega.common.inv.AccessoryInventoryMenu;
import com.swacky.ohmega.common.inv.AccessorySlot;
import com.swacky.ohmega.config.OhmegaConfig;
import net.minecraft.class_10799;
import net.minecraft.class_1661;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_465;
import net.minecraft.class_485;
import net.minecraft.class_490;
import com.swacky.ohmega.common.OhmegaCommon;
import org.jetbrains.annotations.NotNull;

public class AccessoryInventoryScreen extends class_465<AccessoryInventoryMenu> {
    protected final class_1661 inv;
    protected final class_485 effects;
    private final int extraWidth;

    @SuppressWarnings("unused")
    public AccessoryInventoryScreen(AccessoryInventoryMenu menu, class_1661 inv, class_2561 title) {
        super(menu, inv, class_2561.method_43471("container.crafting"));
        this.inv = inv;
        this.effects = new class_485(this);
        this.field_25267 = 97;
        this.extraWidth = 2 + 4 * 2 + 18 * (int) Math.min(Math.ceil((double) AccessoryHelper.getSlotTypes().size() / Math.min(OhmegaConfig.CONFIG_CLIENT.maxColumnRenderSlots.get(), OhmegaConfig.CONFIG_CLIENT.maxColumnSlots.get())), OhmegaConfig.CONFIG_CLIENT.maxColumns.get());

        if (OhmegaConfig.CONFIG_CLIENT.side.get() == OhmegaConfig.Side.RIGHT) {
            this.field_2792 += extraWidth;
        }
    }

    @Override
    protected void method_25426() {
        this.field_33816.clear();

        AccessoryInventoryButton button = new AccessoryInventoryButton(OhmegaConfig.CONFIG_CLIENT.buttonStyle.get(), this);
        method_37063(button);

        if (OhmegaConfig.CONFIG_CLIENT.side.get() == OhmegaConfig.Side.LEFT) {
            this.field_2776 = (this.field_22789 - this.field_2792) / 2;
        } else {
            this.field_2776 = (this.field_22789 - this.field_2792 + extraWidth) / 2;
        }

        this.field_2800 = (this.field_22790 - this.field_2779) / 2;
    }

    @Override
    public void method_25394(@NotNull class_332 gui, int mx, int my, float partialTicks) {
        super.method_25394(gui, mx, my, partialTicks);
        this.effects.method_2477(gui, mx, my);
        this.method_2380(gui, mx, my);
    }

    @Override
    public boolean method_64507() {
        return this.effects.method_38934();
    }

    protected void renderAccInv(class_332 gui) {
        final int renderSlots = Math.min(OhmegaConfig.CONFIG_CLIENT.maxColumnSlots.get(), OhmegaConfig.CONFIG_CLIENT.maxColumnRenderSlots.get());
        final int renderColumns = (int) Math.min(Math.ceil((double) AccessoryHelper.getSlotTypes().size() / renderSlots), OhmegaConfig.CONFIG_CLIENT.maxColumns.get());
        final int slotsAvailable = Math.min(renderColumns * renderSlots, AccessoryHelper.getSlotTypes().size());
        final int mostSlotsPerColumn = Math.min(renderSlots, AccessoryHelper.getSlotTypes().size());

        final int x;
        if (OhmegaConfig.CONFIG_CLIENT.side.get() == OhmegaConfig.Side.LEFT) {
            // Default, 2px buffer from inv, 4 px buffer on both sides, slots columns width, 1px to align
            x = this.field_2776 - 2 - 4 * 2 - 18 * renderColumns;
        } else {
            // Default, 2px buffer from inv, 1px to align
            x = this.field_2776 + 175 + 2 + 1;
        }

        final int lastColumnSlots = slotsAvailable % mostSlotsPerColumn == 0 ? mostSlotsPerColumn : slotsAvailable % mostSlotsPerColumn;

        int index = 0;
        for (int i = 0; i < renderColumns; i++) {
            // Slots
            int slotsCreatedCurrentColumn = 0;
            for (int j = 0; true; j++) {
                gui.method_25290(class_10799.field_56883, OhmegaCommon.ACCESSORY_LOCATION, x + 4 + 18 * i, this.field_2800 + 24 + j * 18, 4, 4, 18, 18, 26, 71);
                index++;
                slotsCreatedCurrentColumn++;
                if (slotsCreatedCurrentColumn >= mostSlotsPerColumn || index >= slotsAvailable) {
                    break;
                }
            }

            // Top border
            gui.method_25290(class_10799.field_56883, OhmegaCommon.ACCESSORY_LOCATION, x + 4 + 18 * i, this.field_2800 + 20, 4, 0, 18, 4, 26, 71);

            // Bottom border
            if (i >= renderColumns - 1 && lastColumnSlots != mostSlotsPerColumn) {
                gui.method_25290(class_10799.field_56883, OhmegaCommon.ACCESSORY_LOCATION, x + 4 + 18 * i, this.field_2800 + 24 + 18 * lastColumnSlots, 4, 22, 18, 4, 26, 71);
            } else {
                gui.method_25290(class_10799.field_56883, OhmegaCommon.ACCESSORY_LOCATION, x + 4 + 18 * i, this.field_2800 + 24 + 18 * mostSlotsPerColumn, 4, 22, 18, 4, 26, 71);
            }
        }

        // Side borders
        for (int i = 0; i < mostSlotsPerColumn; i++) {
            // Left
            gui.method_25290(class_10799.field_56883, OhmegaCommon.ACCESSORY_LOCATION, x, this.field_2800 + 24 + 18 * i, 0, 4, 4, 18, 26, 71);

            // Right
            if (i >= lastColumnSlots) {
                gui.method_25290(class_10799.field_56883, OhmegaCommon.ACCESSORY_LOCATION, x + 4 + 18 * (renderColumns - 1), this.field_2800 + 24 + 18 * i, 22, 4, 4, 18, 26, 71);
            } else {
                gui.method_25290(class_10799.field_56883, OhmegaCommon.ACCESSORY_LOCATION, x + 4 + 18 * renderColumns, this.field_2800 + 24 + 18 * i, 22, 4, 4, 18, 26, 71);
            }
        }

        // Top left corner
        gui.method_25290(class_10799.field_56883, OhmegaCommon.ACCESSORY_LOCATION, x, this.field_2800 + 20, 0, 0, 4, 4, 26, 71);

        // Top right corner
        gui.method_25290(class_10799.field_56883, OhmegaCommon.ACCESSORY_LOCATION, x + 4 + 18 * renderColumns, this.field_2800 + 20, 22, 0, 4, 4, 26, 71);

        // Bottom left corner
        gui.method_25290(class_10799.field_56883, OhmegaCommon.ACCESSORY_LOCATION, x, this.field_2800 + 24 + 18 * mostSlotsPerColumn, 0, 22, 4, 4, 26, 71);

        // Bottom right corner
        gui.method_25290(class_10799.field_56883, OhmegaCommon.ACCESSORY_LOCATION, x + 4 + 18 * renderColumns, this.field_2800 + 24 + 18 * lastColumnSlots, 22, 22, 4, 4, 26, 71);
        if (lastColumnSlots != mostSlotsPerColumn) {
            gui.method_25290(class_10799.field_56883, OhmegaCommon.ACCESSORY_LOCATION, x + 4 + 18 * (renderColumns - 1), this.field_2800 + 24 + 18 * mostSlotsPerColumn, 22, 22, 4, 4, 26, 71);
        }

        // Intersecting corner
        if (lastColumnSlots != mostSlotsPerColumn) {
            gui.method_25290(class_10799.field_56883, OhmegaCommon.ACCESSORY_LOCATION, x + 5 + 18 * (renderColumns - 1), this.field_2800 + 24 + 18 * lastColumnSlots, 20, 26, 3, 3, 26, 71);
        }
    }

    @Override
    protected void method_2389(@NotNull class_332 gui, float partialTicks, int mx, int my) {
        if (this.field_22787 != null && this.field_22787.field_1724 != null) {
            // Main inventory
            gui.method_25290(class_10799.field_56883, class_490.field_2801, this.field_2776, this.field_2800, 0, 0, 176, 166, 256, 256);

            // Accessory Inventory
            this.renderAccInv(gui);

            // Entity rendering
            class_490.method_2486(gui, this.field_2776 + 26, this.field_2800 + 8, this.field_2776 + 75, this.field_2800 + 78, 30, 0.0625f, mx, my, this.field_22787.field_1724);
        }
    }

    @Override
    protected void method_2388(@NotNull class_332 gui, int mx, int my) {
        gui.method_51439(this.field_22793, this.field_22785, this.field_25267, this.field_25268, -12566464, false);
    }

    @Override
    protected void method_2380(@NotNull class_332 gui, int mx, int my) {
        if (this.field_2797.method_34255().method_7960() && this.field_2787 instanceof AccessorySlot accSlot && accSlot.getType().displayHoverText() && OhmegaConfig.CONFIG_CLIENT.tooltip.get() && !this.field_2787.method_7681() && this.field_22787 != null) {
            gui.method_71276(accSlot.getType().getTranslation(), mx, my);
        } else {
            super.method_2380(gui, mx, my);
        }
    }
}
