package com.swacky.ohmega.common.init;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.swacky.ohmega.api.AccessoryHelper;
import com.swacky.ohmega.common.accessorytype.AccessoryType;
import com.swacky.ohmega.config.OhmegaConfig;
import com.swacky.ohmega.common.OhmegaCommon;
import org.lwjgl.glfw.GLFW;

import java.util.*;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_3675;

public class OhmegaBinds {
    public static final String CATEGORY = "key.category." + OhmegaCommon.MODID + ".ohmega";

    public static final class_304 OPEN_ACC_INV = new class_304("key." + OhmegaCommon.MODID + ".open_acc_inv", class_3675.class_307.field_1668, GLFW.GLFW_KEY_UNKNOWN, CATEGORY);

    // Inner class to defer loading
    public static class Generated {
        private static ImmutableMap<AccessoryType, ImmutableList<class_304>> slotKeys;
        private static ArrayList<class_304> orderedSlotKeys;

        private static ImmutableMap<AccessoryType, ImmutableList<class_304>> createSlotKeys() {
            Generated.orderedSlotKeys = new ArrayList<>();

            ImmutableList<AccessoryType> keyBoundSlotTypes = AccessoryHelper.getKeyboundSlotTypes();

            WeakHashMap<AccessoryType, ImmutableList.Builder<class_304>> builder = new WeakHashMap<>(keyBoundSlotTypes.size());
            Map<AccessoryType, Integer> typeCountMap = new WeakHashMap<>();

            if (OhmegaConfig.CONFIG_SERVER.noAccessoryTypes.get()) {
                OhmegaTags.TagHolder holder = OhmegaTags.get(OhmegaCommon.rl("generic"));
                if (holder != null) {
                    typeCountMap.put(holder.getType(), 0);
                }
            } else {
                for (OhmegaTags.TagHolder holder : OhmegaTags.getTags()) {
                    typeCountMap.put(holder.getType(), 0);
                }
            }

            for (AccessoryType slotType : AccessoryHelper.getSlotTypes()) {
                for (AccessoryType type : keyBoundSlotTypes) {
                    if (type == slotType) {
                        int count = typeCountMap.get(type);
                        // Default bindings in ternary:
                        // Utility 1: G
                        // Utility 2: V
                        // Special 1: B
                        int key = type == AccessoryType.UTILITY.get() ? count == 0 ? GLFW.GLFW_KEY_G : count == 1 ? GLFW.GLFW_KEY_V : GLFW.GLFW_KEY_UNKNOWN : type == AccessoryType.SPECIAL.get() && count == 0 ? GLFW.GLFW_KEY_B : GLFW.GLFW_KEY_UNKNOWN;
                        builder.computeIfAbsent(type, k -> new ImmutableList.Builder<>());
                        class_2960 rl = type.getId();
                        OhmegaKeyMapping mapping = new OhmegaKeyMapping("key." + rl.method_12836() + "." + rl.method_12832() + "_" + count, class_3675.class_307.field_1668, key, CATEGORY);
                        builder.get(type).add(mapping);
                        Generated.orderedSlotKeys.add(mapping);
                        typeCountMap.put(type, count + 1);
                    }
                }
            }
            ImmutableMap.Builder<AccessoryType, ImmutableList<class_304>> map = ImmutableMap.builderWithExpectedSize(builder.size());
            for (AccessoryType key : builder.keySet()) {
                map.put(key, builder.get(key).build());
            }

            return map.build();
        }

        public static ImmutableMap<AccessoryType, ImmutableList<class_304>> getSlotKeys() {
            return Generated.slotKeys = createSlotKeys();
        }

        public static class_304 getMapping(AccessoryType type, int index) {
            ImmutableList<class_304> list = Generated.slotKeys.get(type);
            if (list != null) {
                return list.get(index);
            }
            return null;
        }

        public static ImmutableList<class_304> getMappings() {
            return ImmutableList.copyOf(Generated.orderedSlotKeys);
        }

        public static int size() {
            int runningTotal = 0;
            for (ImmutableList<class_304> list : Generated.slotKeys.values()) {
                runningTotal += list.size();
            }
            return runningTotal;
        }
    }

    // No changed behaviour, simply for identification
    public static class OhmegaKeyMapping extends class_304 {
        public OhmegaKeyMapping(String description, class_3675.class_307 inputType, int code, String category) {
            super(description, inputType, code, category);
        }
    }
}
