package com.swacky.ohmega.common.inv;

import com.swacky.ohmega.api.AccessoryHelper;
import com.swacky.ohmega.api.IAccessory;
import com.swacky.ohmega.common.dataattachment.AccessoryInvDataAttachment;
import com.swacky.ohmega.event.OhmegaHooks;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class AccessoryContainer {
    private final class_1657 player;
    private final AccessoryInvDataAttachment data;

    @ApiStatus.Internal
    public AccessoryContainer(class_1657 player, AccessoryInvDataAttachment data) {
        this.player = player;
        this.data = data;
    }

    public boolean isItemValid(int slot, @NotNull class_1799 stack) {
        if (slot >= 0 && slot < data.getSlots()) {
            class_1792 item = stack.method_7909();
            IAccessory acc = AccessoryHelper.getBoundAccessory(item);
            if (acc != null && (AccessoryHelper.compatibleWith(this.player, acc) || class_1799.method_7984(stack, this.getStackInSlot(slot)))) {
                return OhmegaHooks.accessoryCanEquipEvent(this.player, stack, acc.canEquip(this.player, stack)) && AccessoryHelper.getType(item) == AccessoryHelper.getSlotTypes().get(slot);
            }
        }
        return false;
    }

    public int getSlots() {
        return this.data.getSlots();
    }

    public void onContentsChanged(int index) {
        this.data.onContentsChanged(index);
    }

    public class_1799 getStackInSlot(int index) {
        return this.data.getStackInSlot(index);
    }

    public boolean setStackInSlot(int index, @NotNull class_1799 stack) {
        if (stack.method_7960() || this.isItemValid(index, stack) && AccessoryHelper.isItemAccessoryBound(stack.method_7909())) {
            this.data.setStackInSlot(index, stack);
            return true;
        }
        return false;
    }

    public class_1799 removeItem(int index, int amount) {
        return this.data.removeItem(index, amount);
    }

    public void tick() {
        for (int i = 0; i < getSlots(); i++) {
            class_1799 stack = getStackInSlot(i);
            IAccessory acc = AccessoryHelper.getBoundAccessory(stack.method_7909());
            if (acc != null && !OhmegaHooks.accessoryTickEventPre(this.player, stack)) {
                acc.tick(this.player, stack);
                OhmegaHooks.accessoryTickEventPost(this.player, stack);
            }
        }
        this.sync();
    }

    private void sync() {
        this.data.sync(this.player);
    }

    @ApiStatus.Internal
    public void invalidate() {
        this.data.invalidate(this.player);
    }

    @ApiStatus.Internal
    public void reloadCfg() {
        this.data.reloadCfg(this.player);
    }
}
