package com.swacky.ohmega.common.inv;

import com.google.common.collect.ImmutableList;
import com.swacky.ohmega.api.AccessoryHelper;
import com.swacky.ohmega.common.accessorytype.AccessoryType;
import com.swacky.ohmega.api.IAccessory;
import com.swacky.ohmega.common.init.OhmegaMenus;
import com.swacky.ohmega.config.OhmegaConfig;
import com.swacky.ohmega.event.OhmegaHooks;
import net.minecraft.class_1263;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1714;
import net.minecraft.class_1715;
import net.minecraft.class_1723;
import net.minecraft.class_1731;
import net.minecraft.class_1734;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_8566;
import net.minecraft.class_9692;
import net.minecraft.world.inventory.*;
import org.jetbrains.annotations.NotNull;

public class AccessoryInventoryMenu extends class_1703 {
    public static final class_2960[] ARMOR_SLOT_TEXTURES = new class_2960[]{class_1723.field_21672, class_1723.field_21671, class_1723.field_21670, class_1723.field_21669};
    private static final class_1304[] VALID_EQUIPMENT_SLOTS = new class_1304[]{class_1304.field_6169, class_1304.field_6174, class_1304.field_6172, class_1304.field_6166};

    protected static AccessorySlot[] accSlots;

    private final class_1657 player;
    protected AccessoryContainer accessories;
    private final class_8566 craftMatrix = new class_1715(this, 2, 2);
    private final class_1731 craftResult = new class_1731();

    public AccessoryInventoryMenu(int id, class_1661 inv) {
        super(OhmegaMenus.ACCESSORY_INVENTORY, id);

        AccessoryInventoryMenu.accSlots = new AccessorySlot[AccessoryHelper.getSlotTypes().size()];

        this.player = inv.field_7546;
        this.accessories = AccessoryHelper.getContainer(inv.field_7546);

        this.method_7621(new class_1734(inv.field_7546, this.craftMatrix, this.craftResult, 0, 154, 28));

        for (int i = 0; i < 2; ++i) { // Crafting Matrix Slots
            for (int j = 0; j < 2; ++j) {
                this.method_7621(new class_1735(this.craftMatrix, j + i * 2, 98 + j * 18, 18 + i * 18));
            }
        }

        for (int i = 0; i < 4; ++i) { // Armour Slots
            class_1304 equipmentSlotType = VALID_EQUIPMENT_SLOTS[i];
            this.method_7621(new class_9692(inv, this.player, equipmentSlotType, 36 + (3 - i), 8, 8 + i * 18, ARMOR_SLOT_TEXTURES[equipmentSlotType.method_5927()]));
        }

        for (int i = 0; i < 3; ++i) { // Inventory Slots
            for (int j = 0; j < 9; ++j) {
                this.method_7621(new class_1735(inv, j + (i + 1) * 9, 8 + j * 18, 84 + i * 18));
            }
        }

        for (int i = 0; i < 9; ++i) { // Hotbar Slots
            this.method_7621(new class_1735(inv, i, 8 + i * 18, 142));
        }

        this.method_7621(new OffhandSlot(inv, 40, 77, 62)); // Offhand Slot

        ImmutableList<AccessoryType> slotTypes = AccessoryHelper.getSlotTypes();

        if (!inv.field_7546.method_37908().method_8608()) {
            for (int i = 0; i < AccessoryInventoryMenu.accSlots.length; i++) {
                // Position does not matter (only in rare cases) on server
                AccessoryInventoryMenu.accSlots[i] = (AccessorySlot) this.method_7621(new AccessorySlot(inv.field_7546, this.accessories, i, 0, 0, slotTypes.get(i)));
            }
        } else {
            final int renderSlots = Math.min(OhmegaConfig.CONFIG_CLIENT.maxColumnSlots.get(), OhmegaConfig.CONFIG_CLIENT.maxColumnRenderSlots.get());
            final int renderColumns = (int) Math.min(Math.ceil((double) AccessoryHelper.getSlotTypes().size() / renderSlots), OhmegaConfig.CONFIG_CLIENT.maxColumns.get());
            final int slotsAvailable = Math.min(renderColumns * renderSlots, AccessoryHelper.getSlotTypes().size());

            final int x;
            if (OhmegaConfig.CONFIG_CLIENT.side.get() == OhmegaConfig.Side.LEFT) {
                // 2px buffer from inv, 4 px buffer on both sides, slots columns width, 1px to align
                x = - 2 - 4 * 2 - 18 * renderColumns + 1;
            } else {
                // Default, 2px buffer from inv, 2px to align
                x = 175 + 2 + 2;
            }

            boolean stop = false;
            int index = 0;
            for (int i = 0; i < renderColumns; i++) {
                if (stop) {
                    break;
                }

                int slotsCreatedCurrentColumn = 0;
                for (int j = 0; true; j++) {
                    AccessoryInventoryMenu.accSlots[j] = (AccessorySlot) this.method_7621(new AccessorySlot(inv.field_7546, this.accessories, index, x + 4 + 18 * i, 25 + j * 18, slotTypes.get(index)));
                    index++;
                    slotsCreatedCurrentColumn++;

                    if (slotsCreatedCurrentColumn >= renderSlots) {
                        break;
                    }

                    if (index >= slotsAvailable) {
                        stop = true;
                        break;
                    }
                }
            }
        }
    }

    @Override
    public boolean method_7597(@NotNull class_1657 player) {
        return true;
    }

    @Override
    public void method_7609(@NotNull class_1263 container) {
        if (this.player.method_37908() instanceof class_3218 level) {
            class_1714.method_17399(this, level, this.player, this.craftMatrix, this.craftResult, null);
        }
    }

    @Override
    public void method_7595(@NotNull class_1657 player) {
        super.method_7595(player);
        this.craftResult.method_5448();

        if (!player.method_37908().method_8608()) {
            this.method_7607(player, this.craftMatrix);
        }
    }

    @Override
    public boolean method_7613(@NotNull class_1799 stack, class_1735 slot) {
        return slot.field_7871 != this.craftResult && super.method_7613(stack, slot);
    }

    @Override
    public @NotNull class_1799 method_7601(@NotNull class_1657 player, int index) {
        class_1799 stack = class_1799.field_8037;
        class_1735 slot = this.field_7761.get(index);
        if (slot.method_7681()) {
            class_1799 stack0 = slot.method_7677();
            stack = stack0.method_7972();
            class_1304 equipmentSlot = player.method_32326(stack);
            if (index == 0) {
                if (!this.method_7616(stack0, 9, 45, true)) { // Crafting result out
                    return class_1799.field_8037;
                }
                slot.method_7670(stack0, stack);
            } else if (index >= 1 && index < 5) {
                if (!this.method_7616(stack0, 9, 45, false)) { // Crafting out
                    return class_1799.field_8037;
                }
            } else if (index >= 5 && index < 9) {
                if (!this.method_7616(stack0, 9, 45, false)) { // Armour out
                    return class_1799.field_8037;
                }
            } else {
                class_1792 item = stack0.method_7909();
                IAccessory acc = AccessoryHelper.getBoundAccessory(item);
                AccessoryType type = AccessoryHelper.getType(item);
                if (acc != null && index > 8 && index < 45 && AccessoryHelper.getFirstOpenSlot(player, type) != -1 && method_7611(46 + AccessoryHelper.getFirstOpenSlot(player, type)).method_7680(stack)) { // Accessory in
                    int accSlot = AccessoryHelper.getFirstOpenSlot(player, type);
                    stack0.method_7934(1);
                    stack.method_7939(1);
                    method_7611(46 + accSlot).method_7673(stack);
                } else if (equipmentSlot.method_5925() == class_1304.class_1305.field_6178 && !this.field_7761.get(8 - equipmentSlot.method_5927()).method_7681()) {
                    int i = 8 - equipmentSlot.method_5927();
                    if (!this.method_7616(stack0, i, i + 1, false)) { // Armour in
                        return class_1799.field_8037;
                    }
                } else if (equipmentSlot == class_1304.field_6171 && !this.field_7761.get(45).method_7681()) {
                    if (!this.method_7616(stack0, 45, 46, false)) { // Offhand in
                        return class_1799.field_8037;
                    }
                } else if (index >= 9 && index < 36) {
                    if (!this.method_7616(stack0, 36, 45, false)) { // Top part of inv in
                        return class_1799.field_8037;
                    }
                } else if (index > 35 && index < 45) {
                    if (!this.method_7616(stack0, 9, 36, false)) { // Hotbar out
                        return class_1799.field_8037;
                    }
                } else if (index > 45 && index < 52 && acc != null) {
                    AccessoryHelper.changeModifiers(player, AccessoryHelper.getModifiers(stack0).getPassive(), false);

                    if (!OhmegaHooks.accessoryUnequipEvent(this.player, stack0)) {
                        acc.onUnequip(this.player, stack0);
                    }

                    AccessoryHelper.setSlot(stack0, -1);
                    if (this.method_7616(stack0, 9, 45, false)) { // Accessory out
                        return class_1799.field_8037;
                    }
                } else if (!this.method_7616(stack0, 9, 45, false)) { // Etc into the top part of inv
                    return class_1799.field_8037;
                }
            }

            if (stack0.method_7960()) {
                slot.method_48931(class_1799.field_8037, stack);
            } else {
                slot.method_7668();
            }

            if (stack0.method_7947() == stack.method_7947()) {
                return class_1799.field_8037;
            }

            slot.method_7667(player, stack0);
            if (index == 0) {
                player.method_7328(stack0, false);
            }
        }

        return stack;
    }

    private static class OffhandSlot extends class_1735 {
        public OffhandSlot(class_1263 inventoryIn, int index, int xPosition, int yPosition) {
            super(inventoryIn, index, xPosition, yPosition);
        }

        @Override
        public boolean method_7680(@NotNull class_1799 stack) {
            return super.method_7680(stack);
        }

        @Override
        public class_2960 method_7679() {
            return class_1723.field_21673;
        }
    }
}
