package com.swacky.ohmega.common.inv;

import com.swacky.ohmega.api.AccessoryHelper;
import com.swacky.ohmega.common.accessorytype.AccessoryType;
import com.swacky.ohmega.api.IAccessory;
import com.swacky.ohmega.api.event.AccessoryEquipCallback;
import com.swacky.ohmega.event.OhmegaHooks;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_2960;
import net.minecraft.class_9701;
import org.jetbrains.annotations.NotNull;

public class AccessorySlot extends class_1735 {
    private static final class_1263 EMPTY_CONTAINER = new class_1277(0);

    protected final class_1657 player;
    protected final AccessoryContainer handler;
    protected final int slot;
    protected final AccessoryType type;

    public AccessorySlot(class_1657 player, AccessoryContainer handler, int index, int x, int y, AccessoryType type) {
        super(EMPTY_CONTAINER, index, x, y);
        this.player = player;
        this.handler = handler;
        this.slot = index;
        this.type = type;
    }

    @Override
    public boolean method_7680(@NotNull class_1799 stack) {
        if (stack.method_7960()) {
            return false;
        }

        class_1792 item = stack.method_7909();
        IAccessory acc = AccessoryHelper.getBoundAccessory(item);
        if (acc != null) {
            return this.handler.isItemValid(this.slot, stack) && AccessoryHelper.getType(item) == this.type;
        }
        return false;
    }

    @Override
    public boolean method_7674(class_1657 player) {
        class_1799 stack = method_7677();
        if (stack.method_7960()) {
            return false;
        }

        boolean original = !class_1890.method_60142(stack, class_9701.field_51656);
        IAccessory acc = AccessoryHelper.getBoundAccessory(stack.method_7909());
        if (acc != null) {
            original &= acc.canUnequip(player, method_7677());
        }

        return OhmegaHooks.accessoryCanUnequipEvent(player, method_7677(), original);
    }

    @Override
    public @NotNull class_1799 method_7677() {
        return this.handler.getStackInSlot(this.slot);
    }

    @Override
    public void method_7670(class_1799 oldStack, class_1799 newStack) {}

    @Override
    public int method_7675() {
        return 1;
    }

    @Override
    public int method_7676(class_1799 stack) {
        return method_7675();
    }

    @Override
    public @NotNull class_1799 method_7671(int amount) {
        return this.handler.removeItem(this.slot, amount);
    }

    @Override
    public void method_7667(@NotNull class_1657 player, @NotNull class_1799 stack) {
        IAccessory acc = AccessoryHelper.getBoundAccessory(stack.method_7909());
        if (!method_7681() && acc != null) {
            AccessoryHelper.changeModifiers(player, AccessoryHelper.getModifiers(stack).getPassive(), false);

            if (!OhmegaHooks.accessoryUnequipEvent(this.player, stack)) {
                acc.onUnequip(this.player, stack);
            }
            AccessoryHelper.setSlot(stack, -1);
        }
        super.method_7667(player, stack);
    }

    @Override
    public void method_7673(@NotNull class_1799 stack) {
        IAccessory acc = AccessoryHelper.getBoundAccessory(method_7677().method_7909());
        if (method_7681() && stack != method_7677() && acc != null) {
            AccessoryHelper.changeModifiers(this.player, AccessoryHelper.getModifiers(method_7677()).getPassive(), false);

            if (!OhmegaHooks.accessoryUnequipEvent(this.player, method_7677())) {
                acc.onUnequip(this.player, method_7677());
            }

            AccessoryHelper.setSlot(method_7677(), -1);
            this.method_7668();
        }

        class_1799 old = method_7677().method_7972();
        this.handler.setStackInSlot(this.slot, stack);
        this.method_7668();

        acc = AccessoryHelper.getBoundAccessory(method_7677().method_7909());
        if (method_7681() && old != method_7677() && acc != null) {
            AccessoryHelper.setSlot(stack, this.slot);

            AccessoryHelper.changeModifiers(this.player, AccessoryHelper.getModifiers(stack).getPassive(), true);

            if (!OhmegaHooks.accessoryEquipEvent(this.player, stack, AccessoryEquipCallback.Context.SLOT_PLACE)) {
                acc.onEquip(this.player, stack);
            }
            this.method_7668();
        }
    }

    @Override
    public class_2960 method_7679() {
        return this.type.getEmptySlotLocation();
    }

    public AccessoryType getType() {
        return this.type;
    }
}