package com.swacky.ohmega.common.item;

import com.swacky.ohmega.api.AccessoryHelper;
import com.swacky.ohmega.api.IAccessory;
import com.swacky.ohmega.api.ModifierHolder;
import com.swacky.ohmega.common.OhmegaCommon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.function.Consumer;
import net.minecraft.class_10712;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_5134;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

/**
 * This is simply a test and example accessory; its code may be used as a reference to create your own
 * <p>
 * You may also add a recipe to this if desired for survival use, or change how it functions through the use of events provided by the API
 */
public class AngelRing extends class_1792 implements IAccessory {
    public AngelRing(class_1793 properties) {
        super(properties);
    }

    // This method uses the utility class to easily add tooltips onto the accessory
    @SuppressWarnings("deprecation")
    @Override
    public void method_67187(class_1799 stack, class_9635 context, class_10712 tooltipDisplay, Consumer<class_2561> tooltip, class_1836 flag) {
        tooltip.accept(AccessoryHelper.getBindTooltip(new class_2588(this.method_7876() + ".tooltip.keybind", null, class_2588.field_24367), stack, new class_2588(this.method_7876() + ".tooltip", null, class_2588.field_24367)));
        class_2561 component = AccessoryHelper.getTypeTooltip(this);
        if (component != null) {
            tooltip.accept(component);
        }
    }

    // Activates the accessory when you equip it
    @Override
    public void onEquip(class_1657 player, class_1799 stack) {
        AccessoryHelper.activate(player, stack);
    }

    // Deactivates when unequipped, also this makes it not force a creative player to stop flying when taking off the accessory
    @Override
    public void onUnequip(class_1657 player, class_1799 stack) {
        if (!(player.method_68878() || player.method_7325())) {
            player.method_31549().field_7478 = false;
            player.method_31549().field_7479 = false;
        }
        AccessoryHelper.deactivate(player, stack);
    }

    // Tick method is needed here as there are so many edge cases to account for, it is easier to just use the tick method
    @Override
    public void tick(class_1657 player, class_1799 stack) {
        if (!(player.method_68878() || player.method_7325())) {
            if (AccessoryHelper.isActive(stack)) {
                player.method_31549().field_7478 = true;
            } else {
                player.method_31549().field_7478 = false;
                player.method_31549().field_7479 = false;
            }
        }
    }

    // Toggle the accessory being active when the keybind is pressed
    @Override
    public void onUse(class_1657 player, class_1799 stack) {
        AccessoryHelper.toggle(player, stack);
    }

    // Makes the accessory have the enchanted glint when equipped
    // No super as it may be confusing if active when enchanted, also it is not intended to be enchantable.
    @Override
    public boolean method_7886(@NotNull class_1799 stack) {
        return AccessoryHelper.isActive(stack);
    }

    // Adds modifiers to be applied when the accessory is equipped
    @Override
    public void addDefaultAttributeModifiers(ModifierHolder.Builder builder) {
        // This modifier is only applied when the accessory is active
        builder.addPassive(class_5134.field_23721, new class_1322(OhmegaCommon.rl(class_7923.field_41178.method_10221(this).method_42094() + ".effect.strength"), 1, class_1322.class_1323.field_6328));

        // This modifier is always applied
        builder.addActive(class_5134.field_23716, new class_1322(OhmegaCommon.rl(class_7923.field_41178.method_10221(this).method_42094() + ".effect.health_boost"), 4, class_1322.class_1323.field_6328));
    }

    // The sound to be played when equipped using a right click
    @Nullable
    @Override
    public class_6880<class_3414> getEquipSound() {
        return class_3417.field_14761;
    }
}
