package com.swacky.ohmega.event;

import com.google.common.collect.ImmutableList;
import com.swacky.ohmega.api.AccessoryHelper;
import com.swacky.ohmega.client.screen.AccessoryInventoryButton;
import com.swacky.ohmega.common.init.OhmegaBinds;
import com.swacky.ohmega.common.inv.AccessoryInventoryMenu;
import com.swacky.ohmega.config.OhmegaConfig;
import com.swacky.ohmega.network.C2S.OpenAccessoryInventoryPacket;
import com.swacky.ohmega.network.C2S.ResizeCapPacket;
import com.swacky.ohmega.common.OhmegaCommon;
import fuzs.forgeconfigapiport.fabric.api.v5.ModConfigEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.minecraft.class_2815;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_490;
import net.neoforged.fml.config.ModConfig;
import org.apache.commons.lang3.ArrayUtils;

import java.util.ArrayList;
import java.util.Arrays;

public class OhmegaClientEvents {
    private static boolean bootstrapped = false;
    public static void bootstrap() {
        if (!bootstrapped) {
            bootstrapped = true;

            ScreenEvents.AFTER_INIT.register(OhmegaClientEvents::addToScreens);
            ModConfigEvents.loading(OhmegaCommon.MODID).register(OhmegaClientEvents::onConfigLoad);
            ModConfigEvents.unloading(OhmegaCommon.MODID).register(OhmegaClientEvents::onConfigUnload);
            ModConfigEvents.reloading(OhmegaCommon.MODID).register(OhmegaClientEvents::onConfigReload);
        }
    }

    private static void addToScreens(class_310 mc, class_437 screen, int width, int height) {
        if (screen instanceof class_490 && OhmegaConfig.CONFIG_CLIENT.buttonStyle.get() != OhmegaConfig.ButtonStyle.HIDDEN) {
            if (mc != null && mc.field_1724 != null && !mc.field_1724.method_68878() && !mc.field_1724.method_7325()) {
                screen.method_37063(new AccessoryInventoryButton(OhmegaConfig.CONFIG_CLIENT.buttonStyle.get(), (class_465<?>) screen));
            }
        }
    }

    private static void onConfigLoad(ModConfig config) {
        if (config.getSpec() == OhmegaConfig.SPEC_SERVER) {
            ArrayList<class_304> list = new ArrayList<>();
            for (ImmutableList<class_304> immutableList : OhmegaBinds.Generated.getSlotKeys().values()) {
                list.addAll(immutableList);
            }

            class_310 mc = class_310.method_1551();
            mc.field_1690.field_1839 = ArrayUtils.addAll(Arrays.stream(mc.field_1690.field_1839).filter(v -> !(v instanceof OhmegaBinds.OhmegaKeyMapping)).toList().toArray(new class_304[0]), list.toArray(new class_304[0]));
            mc.field_1690.method_1636();
        }
    }

    private static void onConfigUnload(ModConfig config) {
        if (OhmegaConfig.SPEC_CLIENT.isLoaded() && config.getSpec() == OhmegaConfig.SPEC_SERVER) {
            class_310 mc = class_310.method_1551();
            mc.field_1690.field_1839 = Arrays.stream(mc.field_1690.field_1839).filter(v -> !(v instanceof OhmegaBinds.OhmegaKeyMapping)).toList().toArray(new class_304[0]);
            mc.field_1690.method_1636();
        }
    }

    private static void onConfigReload(ModConfig config) {
        if (OhmegaConfig.SPEC_CLIENT.isLoaded() && OhmegaConfig.SPEC_SERVER.isLoaded()) {
            class_310 mc = class_310.method_1551();
            if (config.getSpec() == OhmegaConfig.SPEC_CLIENT && !OhmegaConfig.CONFIG_CLIENT.compatibilityMode.get()) {
                if (mc.field_1724 != null && mc.field_1724.field_7512 instanceof AccessoryInventoryMenu) {
                    ClientPlayNetworking.send(new OpenAccessoryInventoryPacket());
                }
            } else if (config.getSpec() == OhmegaConfig.SPEC_SERVER) {
                ArrayList<class_304> list = new ArrayList<>();
                for (ImmutableList<class_304> immutableList : OhmegaBinds.Generated.getSlotKeys().values()) {
                    list.addAll(immutableList);
                }

                mc.field_1690.field_1839 = ArrayUtils.addAll(Arrays.stream(mc.field_1690.field_1839).filter(v -> !(v instanceof OhmegaBinds.OhmegaKeyMapping)).toList().toArray(new class_304[0]), list.toArray(new class_304[0]));
                mc.field_1690.method_1636();

                if (mc.field_1724 != null) {
                    AccessoryHelper.getContainer(mc.field_1724).reloadCfg();
                    ClientPlayNetworking.send(new ResizeCapPacket());

                    if (!OhmegaConfig.CONFIG_CLIENT.compatibilityMode.get() && mc.field_1724.field_7512 instanceof AccessoryInventoryMenu) {
                        mc.field_1755 = null;
                        mc.field_1724.field_3944.method_52787(new class_2815(mc.field_1724.field_7512.field_7763));
                        ClientPlayNetworking.send(new OpenAccessoryInventoryPacket());
                    }
                }
            }
        }
    }
}
