package com.swacky.ohmega.event;

import com.swacky.ohmega.api.AccessoryHelper;
import com.swacky.ohmega.api.IAccessory;
import com.swacky.ohmega.api.event.AccessoryEquipCallback;
import com.swacky.ohmega.common.inv.AccessoryContainer;
import com.swacky.ohmega.config.OhmegaConfig;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.fabricmc.fabric.api.networking.v1.EntityTrackingEvents;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;
import java.util.Collections;
import java.util.List;

public class OhmegaCommonEvents {
    private static boolean bootstrapped = false;
    public static void bootstrap() {
        if (!bootstrapped) {
            bootstrapped = true;
            ServerPlayConnectionEvents.JOIN.register(OhmegaCommonEvents::onPlayerJoin);
            EntityTrackingEvents.START_TRACKING.register(OhmegaCommonEvents::onPlayerTrack);
            ServerPlayerEvents.COPY_FROM.register(OhmegaCommonEvents::onClonePlayer);
            UseItemCallback.EVENT.register(OhmegaCommonEvents::onItemRightClick);
        }
    }

    private static void onPlayerJoin(class_3244 handler, PacketSender sender, MinecraftServer server) {
        class_3222 player = handler.method_32311();
        List<class_3222> receivers = player.method_51469().method_18456();

        receivers.add(player);
        AccessoryHelper.syncAllSlots(player, receivers);
    }

    private static void onPlayerTrack(class_1297 tracked, class_3222 tracker) {
        if (tracked instanceof class_3222 player) {
            AccessoryHelper.syncAllSlots(player, Collections.singletonList(tracker));
        }
    }

    private static void onClonePlayer(class_3222 oldPlayer, class_3222 newPlayer, boolean alive) {
        boolean flag = switch (OhmegaConfig.CONFIG_SERVER.keepAccessories.get()) { // Inverse
            case ON -> false;
            case OFF -> true;
            case DEFAULT -> oldPlayer.method_5682() == null || !oldPlayer.method_5682().method_3767().method_8355(class_1928.field_19389);
        };

        if (!alive || flag) {
            AccessoryContainer oldA = AccessoryHelper.getContainer(oldPlayer);
            AccessoryContainer newA = AccessoryHelper.getContainer(newPlayer);

            for (int i = 0; i < newA.getSlots(); i++) {
                class_1799 stack = oldA.getStackInSlot(i);
                newA.setStackInSlot(i, stack);
                IAccessory acc = AccessoryHelper.getBoundAccessory(stack.method_7909());
                if (acc != null) {
                    AccessoryHelper.changeModifiers(newPlayer, AccessoryHelper.getModifiers(stack).getPassive(), true);

                    if (!OhmegaHooks.accessoryEquipEvent(newPlayer, stack, AccessoryEquipCallback.Context.GENERIC)) {
                        acc.onEquip(newPlayer, stack);
                    }
                    AccessoryHelper.setSlot(stack, i);
                }
            }
        }
    }

    private static class_1269 onItemRightClick(class_1657 player, class_1937 level, class_1268 hand) {
        class_1269 result = AccessoryHelper.tryEquip(player, hand);
        if (result == class_1269.field_5812) {
            return result;
        }
        return class_1269.field_5811;
    }
}
