package com.swacky.ohmega.event;

import com.google.common.collect.ImmutableMap;
import com.swacky.ohmega.api.ModifierHolder;
import com.swacky.ohmega.api.event.*;
import com.swacky.ohmega.common.accessorytype.AccessoryType;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;

@SuppressWarnings("removal")
public class OhmegaHooks {
    public static ImmutableMap<class_1792, AccessoryType> accessoryOverrideTypesEvent() {
        return (ImmutableMap<class_1792, AccessoryType>) AccessoryOverrideTypesCallback.EVENT.invoker().process(ImmutableMap.of());
    }

    public static boolean accessoryTickEventPre(class_1657 player, class_1799 stack) {
        return AccessoryTickPreCallback.EVENT.invoker().process(player, stack).isCanceled();
    }

    public static void accessoryTickEventPost(class_1657 player, class_1799 stack) {
        AccessoryTickPostCallback.EVENT.invoker().process(player, stack);
    }

    public static boolean accessoryEquipEvent(class_1657 player, class_1799 stack, AccessoryEquipCallback.Context context) {
        return AccessoryEquipCallback.EVENT.invoker().process(player, stack, context).isCanceled();
    }

    public static boolean accessoryUnequipEvent(class_1657 player, class_1799 stack) {
        return AccessoryUnequipCallback.EVENT.invoker().process(player, stack).isCanceled();
    }

    public static boolean accessoryCanEquipEvent(class_1657 player, class_1799 stack, boolean flag) {
        return AccessoryCanEquipCallback.EVENT.invoker().process(player, stack, flag);
    }

    public static boolean accessoryCanUnequipEvent(class_1657 player, class_1799 stack, boolean flag) {
        return AccessoryCanUnequipCallback.EVENT.invoker().process(player, stack, flag);
    }

    public static boolean accessoryUseEvent(class_1657 player, class_1799 stack) {
        return AccessoryUseCallback.EVENT.invoker().process(player, stack).isCanceled();
    }

    public static void accessoryAttributeModifiersEvent(class_1792 item, ModifierHolder.Builder builder) {
        AccessoryAttributeModifiersCallback.EVENT.invoker().process(item, builder);
    }
}
