package com.swacky.ohmega.mixin;

import com.swacky.ohmega.api.AccessoryHelper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_9274;
import net.minecraft.class_9304;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.minecraft.class_9699;

@Mixin(class_1890.class)
public class EnchantmentHelperMixin {
    @Inject(method = "getRandomItemWith", at = @At(value = "RETURN"), cancellable = true)
    private static void getRandomItemWith(class_9331<?> dataType, class_1309 entity, Predicate<class_1799> filter, CallbackInfoReturnable<Optional<class_9699>> cir) {
        int original = 0;

        for (class_1304 slot : class_1304.values()) {
            class_1799 stack = entity.method_6118(slot);
            if (filter.test(stack)) {
                for (class_6880<class_1887> holder : stack.method_58695(class_9334.field_49633, class_9304.field_49385).method_57534()) {
                    class_1887 enchantment = holder.comp_349();
                    if (enchantment.comp_2689().method_57832(dataType) && enchantment.method_60026(slot)) {
                        original++;
                    }
                }
            }
        }

        ArrayList<class_9699> list = new ArrayList<>();
        if (entity instanceof class_1657 player) {
            for (class_1799 stack : AccessoryHelper.getStacks(player)) {
                if (filter.test(stack)) {
                    for (class_6880<class_1887> holder : stack.method_58695(class_9334.field_49633, class_9304.field_49385).method_57534()) {
                        class_1887 enchantment = holder.comp_349();
                        if (enchantment.comp_2689().method_57832(dataType) && ohmega$checkSlots(enchantment.comp_2687().comp_2513())) {
                            list.add(new class_9699(stack, class_1304.field_6173, entity));
                        }
                    }
                }
            }

            if (!list.isEmpty()) {
                class_5819 random = entity.method_59922();
                if (random.method_43048(list.size() + original) >= original) {
                    cir.setReturnValue(class_156.method_40083(list, random));
                }
            }
        }
    }

    @Unique
    private static final class_1304[] HUMANOID_ARMOUR = new class_1304[]{class_1304.field_6166, class_1304.field_6172, class_1304.field_6174, class_1304.field_6169};

    @Unique
    private static boolean ohmega$checkSlots(List<class_9274> groups) {
        for (class_9274 group : groups) {
            for (class_1304 slot : HUMANOID_ARMOUR) {
                if (group.method_57286(slot)){
                    return true;
                }
            }
        }
        return false;
    }
}
