package com.swacky.ohmega.mixin;

import com.swacky.ohmega.api.AccessoryHelper;
import com.swacky.ohmega.api.IAccessory;
import com.swacky.ohmega.api.ModifierHolder;
import com.swacky.ohmega.common.datacomponent.AccessoryItemDataComponent;
import com.swacky.ohmega.event.OhmegaHooks;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_9335;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_1799.class)
public class ItemStackMixin {
    @Inject(method = "<init>(Lnet/minecraft/world/level/ItemLike;ILnet/minecraft/core/component/PatchedDataComponentMap;)V", at = @At(value = "RETURN"))
    private void ItemStack(class_1935 itemLike, int count, class_9335 components, CallbackInfo ci) {
        if (itemLike instanceof class_1792 item) {
            IAccessory acc = AccessoryHelper.getBoundAccessory(item);
            if (acc != null) {
                AccessoryItemDataComponent data = AccessoryHelper._getInternalData((class_1799) (Object) this);
                if (data != null) {
                    ModifierHolder.Builder builder = new ModifierHolder.Builder();
                    acc.addDefaultAttributeModifiers(builder);
                    OhmegaHooks.accessoryAttributeModifiersEvent(itemLike.method_8389(), builder);
                    data.setModifiers(builder.build());
                }
            }
        }
    }
}
