package com.swacky.ohmega.mixin;

import com.swacky.ohmega.common.accessorytype.AccessoryTypeManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_3302;
import net.minecraft.class_5350;

@Mixin(class_5350.class)
public class ReloadableServerResourcesMixin {
    @Inject(method = "listeners", at = @At(value = "RETURN"), cancellable = true)
    public void listeners(CallbackInfoReturnable<List<class_3302>> cir) {
        ArrayList<class_3302> list = new ArrayList<>(cir.getReturnValue());
        list.add(AccessoryTypeManager.getInstance());
        cir.setReturnValue(list);
    }
}
