package com.swacky.ohmega.mixin.client;

import com.google.common.collect.ImmutableList;
import com.swacky.ohmega.api.AccessoryHelper;
import com.swacky.ohmega.api.IAccessory;
import com.swacky.ohmega.common.init.OhmegaBinds;
import com.swacky.ohmega.common.inv.AccessoryContainer;
import com.swacky.ohmega.event.OhmegaHooks;
import com.swacky.ohmega.network.C2S.OpenAccessoryInventoryPacket;
import com.swacky.ohmega.network.C2S.UseAccessoryKbPacket;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1799;
import net.minecraft.class_304;
import net.minecraft.class_309;
import net.minecraft.class_310;
import net.minecraft.class_490;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_309.class)
public class KeyboardHandlerMixin {
    @Inject(method = "keyPress", at = @At(value = "TAIL"))
    public void keyPress(long windowPointer, int key, int scanCode, int action, int modifiers, CallbackInfo ci) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1755 == null) {
            while (OhmegaBinds.OPEN_ACC_INV.method_1436() && mc.field_1724 != null) {
                if (mc.field_1761 != null && mc.field_1761.method_2895()) {
                    mc.field_1724.method_3132();
                } else if (!mc.field_1724.method_68878() && !mc.field_1724.method_7325()) {
                    ClientPlayNetworking.send(new OpenAccessoryInventoryPacket());
                } else {
                    mc.method_1507(new class_490(mc.field_1724));
                }
            }

            ImmutableList<class_304> mappings = OhmegaBinds.Generated.getMappings();
            ImmutableList<String> slotTypes = AccessoryHelper.getSlotTypesStr();
            if (mappings.isEmpty() || slotTypes.isEmpty()) {
                return;
            }

            // Never ever touch this again; wrote 2 months ago, I now consider it dark magic.
            AccessoryContainer a = AccessoryHelper.getContainer(mc.field_1724);
            for (int i = 0; i < OhmegaBinds.Generated.size(); i++) {
                int j = 0;
                class_304 mapping = mappings.get(i);
                if (mapping.method_1436()) {
                    // Client handling
                    if (mc.field_1724 != null) {
                        for (int k = 0; true; j++) {
                            if (AccessoryHelper.getKeyboundSlotTypesStr().contains(slotTypes.get(j)) && ++k > i) {
                                break;
                            }
                        }

                        class_1799 stack = a.getStackInSlot(j);

                        IAccessory acc = AccessoryHelper.getBoundAccessory(stack.method_7909());
                        if (acc != null && !OhmegaHooks.accessoryUseEvent(mc.field_1724, stack)) {
                            acc.onUse(mc.field_1724, stack);
                        }
                    }

                    // Server handling
                    ClientPlayNetworking.send(new UseAccessoryKbPacket(j));
                }
            }
        }
    }
}
