package com.swacky.ohmega.network.C2S;

import com.swacky.ohmega.api.AccessoryHelper;
import com.swacky.ohmega.api.IAccessory;
import com.swacky.ohmega.common.inv.AccessoryContainer;
import com.swacky.ohmega.event.OhmegaHooks;
import com.swacky.ohmega.common.OhmegaCommon;
import io.netty.buffer.ByteBuf;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1799;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

public record UseAccessoryKbPacket(int slot) implements class_8710 {
    public static final class_9154<UseAccessoryKbPacket> TYPE = new class_9154<>(OhmegaCommon.rl("use_accessory_keybind_packet"));

    public static final class_9139<ByteBuf, UseAccessoryKbPacket> CODEC = class_9139.method_56434(
            class_9135.field_48550,
            UseAccessoryKbPacket::slot,
            UseAccessoryKbPacket::new
    );

    public static void handle(UseAccessoryKbPacket packet, ServerPlayNetworking.Context context) {
        if (packet.slot < AccessoryHelper.getSlotTypes().size()) {
            class_3222 player = context.player();
            AccessoryContainer a = AccessoryHelper.getContainer(player);
            IAccessory acc = AccessoryHelper.getBoundAccessory(a.getStackInSlot(packet.slot).method_7909());

            if (acc != null) {
                class_1799 stack = a.getStackInSlot(packet.slot);

                if (!OhmegaHooks.accessoryUseEvent(player, stack)) {
                    acc.onUse(player, stack);
                }
            }
        }
    }

    @Override
    public @NotNull class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }
}
