package com.swacky.ohmega.network.S2C;

import com.swacky.ohmega.api.AccessoryHelper;
import com.swacky.ohmega.common.OhmegaCommon;
import io.netty.buffer.ByteBuf;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_8703;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

import java.util.List;

public class SyncAccessorySlotsPacket implements class_8710 {
    public static final class_9154<SyncAccessorySlotsPacket> TYPE = new class_9154<>(OhmegaCommon.rl("sync_accessory_slots_packet"));

    public static final class_9139<class_9129, SyncAccessorySlotsPacket> CODEC = class_9139.method_56436(
            class_9135.field_49675,
            inst -> inst.playerId,
            new class_9139<ByteBuf, int[]>() {
                public int @NotNull [] decode(@NotNull ByteBuf buf) {
                    int size = class_8703.method_53016(buf);
                    int[] values = new int[size];

                    for (int i = 0; i < size; i++) {
                        values[i] = class_8703.method_53016(buf);
                    }
                    return values;
                }

                public void encode(@NotNull ByteBuf buf, int @NotNull [] values) {
                    class_8703.method_53017(buf, values.length);

                    for (int value : values) {
                        class_8703.method_53017(buf, value);
                    }
                }
            },
            inst -> inst.slots,
            class_1799.field_49269,
            inst -> inst.stacks,
            SyncAccessorySlotsPacket::new
    );

    private final int playerId;
    private final int[] slots;
    private final List<class_1799> stacks;

    public SyncAccessorySlotsPacket(int playerId, int[] slots, List<class_1799> stacks) {
        if (slots.length != stacks.size()) {
            throw new IllegalArgumentException("Mismatched int slot array size of " + slots.length + " and ItemStack size of " + stacks.size());
        }
        this.playerId = playerId;
        this.slots = slots;
        this.stacks = stacks;
    }

    public static void handle(SyncAccessorySlotsPacket packet, ClientPlayNetworking.Context context) {
        if (packet.slots.length == 0) {
            return;
        }

        context.client().execute(() -> {
            class_638 level = class_310.method_1551().field_1687;
            if (level != null) {
                if (level.method_8469(packet.playerId) instanceof class_1657 player) {
                    for (int i = 0; i < packet.slots.length; i++) {
                        AccessoryHelper.getContainer(player).setStackInSlot(packet.slots[i], packet.stacks.get(i));
                    }
                }
            }
        });
    }

    @Override
    public @NotNull class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }
}
