package com.swacky.ohmega.network.S2C;

import com.google.common.collect.ImmutableList;
import com.swacky.ohmega.common.accessorytype.AccessoryType;
import com.swacky.ohmega.common.accessorytype.AccessoryTypeManager;
import com.swacky.ohmega.common.OhmegaCommon;
import io.netty.buffer.ByteBuf;
import net.fabricmc.fabric.api.client.networking.v1.ClientConfigurationNetworking;
import net.minecraft.class_8703;
import net.minecraft.class_8710;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

public class SyncAccessoryTypesPacket implements class_8710 {
    public static final class_9154<SyncAccessoryTypesPacket> TYPE = new class_9154<>(OhmegaCommon.rl("sync_accessory_types_packet"));

    public static final class_9139<ByteBuf, SyncAccessoryTypesPacket> CODEC = class_9139.method_56434(
            new class_9139<>() {
                @Override
                public @NotNull ImmutableList<AccessoryType> decode(@NotNull ByteBuf buf) {
                    int size = class_8703.method_53016(buf);
                    ImmutableList.Builder<AccessoryType> builder = ImmutableList.builderWithExpectedSize(size);
                    for (int i = 0; i < size; i++) {
                        builder.add(AccessoryType.CODEC.decode(buf));
                    }
                    return builder.build();
                }

                @Override
                public void encode(@NotNull ByteBuf buf, @NotNull ImmutableList<AccessoryType> values) {
                    class_8703.method_53017(buf, values.size());
                    for (AccessoryType value : values) {
                        AccessoryType.CODEC.encode(buf, value);
                    }
                }
            },
            inst -> inst.types,
            SyncAccessoryTypesPacket::new
    );

    public ImmutableList<AccessoryType> types;

    public SyncAccessoryTypesPacket(ImmutableList<AccessoryType> types) {
        this.types = types;
    }

    public static void handle(SyncAccessoryTypesPacket packet, ClientConfigurationNetworking.Context context) {
        AccessoryTypeManager.getInstance().apply(packet.types);
    }

    @Override
    public @NotNull class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }
}
