/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.materials;

import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.class_1047;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_2960;
import net.minecraft.class_4730;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;

public class MaterialRenderInfo {
    private final MaterialVariantId identifier;
    @Nullable
    private final class_2960 texture;
    private final String[] fallbacks;
    private final int vertexColor;
    private final int luminosity;

    @Nullable
    private class_1058 trySprite(class_4730 base, String suffix, Function<class_4730, class_1058> spriteGetter) {
        class_1058 sprite = spriteGetter.apply(MaterialRenderInfo.getMaterial(base.method_24147(), suffix));
        if (!class_1047.method_4539().equals((Object)sprite.method_45851().method_45816())) {
            return sprite;
        }
        return null;
    }

    public TintedSprite getSprite(class_4730 base, Function<class_4730, class_1058> spriteGetter) {
        class_1058 sprite;
        if (this.texture != null && (sprite = this.trySprite(base, MaterialRenderInfo.getSuffix(this.texture), spriteGetter)) != null) {
            return new TintedSprite(sprite, -1);
        }
        for (String fallback : this.fallbacks) {
            sprite = this.trySprite(base, fallback, spriteGetter);
            if (sprite == null) continue;
            return new TintedSprite(sprite, this.vertexColor);
        }
        return new TintedSprite(spriteGetter.apply(base), this.vertexColor);
    }

    public void getTextureDependencies(Predicate<class_4730> textures, class_4730 base) {
        if (this.texture != null) {
            textures.test(MaterialRenderInfo.getMaterial(base.method_24147(), MaterialRenderInfo.getSuffix(this.texture)));
        }
        for (String fallback : this.fallbacks) {
            textures.test(MaterialRenderInfo.getMaterial(base.method_24147(), fallback));
        }
    }

    public static String getSuffix(class_2960 material) {
        if ("minecraft".equals(material.method_12836())) {
            return material.method_12832();
        }
        return material.method_12836() + "_" + material.method_12832();
    }

    private static class_4730 getMaterial(class_2960 texture, String suffix) {
        return new class_4730(class_1059.field_5275, new class_2960(texture.method_12836(), texture.method_12832() + "_" + suffix));
    }

    public MaterialRenderInfo(MaterialVariantId identifier, @Nullable class_2960 texture, String[] fallbacks, int vertexColor, int luminosity) {
        this.identifier = identifier;
        this.texture = texture;
        this.fallbacks = fallbacks;
        this.vertexColor = vertexColor;
        this.luminosity = luminosity;
    }

    public MaterialVariantId getIdentifier() {
        return this.identifier;
    }

    @Nullable
    public class_2960 getTexture() {
        return this.texture;
    }

    public String[] getFallbacks() {
        return this.fallbacks;
    }

    public int getVertexColor() {
        return this.vertexColor;
    }

    public int getLuminosity() {
        return this.luminosity;
    }

    public record TintedSprite(class_1058 sprite, int color) {
    }
}

