/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.data.material;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.resource.conditions.v1.ConditionJsonProvider;
import net.fabricmc.fabric.api.resource.conditions.v1.DefaultResourceConditions;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7403;
import net.minecraft.class_7924;
import slimeknights.mantle.client.book.data.JsonCondition;
import slimeknights.mantle.data.GenericDataProvider;
import slimeknights.tconstruct.common.json.ConfigEnabledCondition;
import slimeknights.tconstruct.library.json.JsonRedirect;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.Material;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.definition.MaterialManager;
import slimeknights.tconstruct.library.materials.json.MaterialJson;

public abstract class AbstractMaterialDataProvider
extends GenericDataProvider {
    public static final int ORDER_GENERAL = 0;
    public static final int ORDER_HARVEST = 1;
    public static final int ORDER_WEAPON = 2;
    public static final int ORDER_SPECIAL = 3;
    public static final int ORDER_RANGED = 4;
    public static final int ORDER_COMPAT = 5;
    public static final int ORDER_NETHER = 10;
    public static final int ORDER_END = 15;
    public static final int ORDER_BINDING = 20;
    public static final int ORDER_REPAIR = 25;
    private final Map<MaterialId, DataMaterial> allMaterials = new HashMap<MaterialId, DataMaterial>();
    private boolean addMaterialsRun = false;

    public AbstractMaterialDataProvider(FabricDataOutput output) {
        super(output, "tinkering/materials/definition", MaterialManager.GSON);
    }

    protected abstract void addMaterials();

    private void ensureAddMaterialsRun() {
        if (this.addMaterialsRun) {
            return;
        }
        this.addMaterialsRun = true;
        this.addMaterials();
    }

    public CompletableFuture<?> method_10319(class_7403 cache) {
        this.ensureAddMaterialsRun();
        ArrayList futures = new ArrayList();
        this.allMaterials.forEach((id, data) -> futures.add(this.saveThing(cache, (class_2960)id, this.convert((DataMaterial)data))));
        return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
    }

    public Set<MaterialId> getAllMaterials() {
        this.ensureAddMaterialsRun();
        return this.allMaterials.values().stream().map(DataMaterial::material).filter(Objects::nonNull).map(IMaterial::getIdentifier).collect(Collectors.toSet());
    }

    protected void addMaterial(IMaterial material, @Nullable ConditionJsonProvider condition, JsonRedirect ... redirect) {
        this.allMaterials.put(material.getIdentifier(), new DataMaterial(material, condition, redirect));
    }

    protected void addRedirect(MaterialId id, @Nullable ConditionJsonProvider condition, JsonRedirect ... redirect) {
        this.allMaterials.put(id, new DataMaterial(null, condition, redirect));
    }

    protected void addRedirect(MaterialId id, JsonRedirect ... redirect) {
        this.addRedirect(id, (ConditionJsonProvider)null, redirect);
    }

    protected static ConditionJsonProvider tagExistsCondition(String name) {
        return DefaultResourceConditions.itemTagsPopulated((class_6862[])new class_6862[]{class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)new class_2960("c", name))});
    }

    protected void addMaterial(MaterialId location, int tier, int order, boolean craftable, boolean hidden, @Nullable ConditionJsonProvider condition, JsonRedirect ... redirect) {
        this.addMaterial(new Material(location, tier, order, craftable, hidden), condition, redirect);
    }

    protected void addMaterial(MaterialId location, int tier, int order, boolean craftable) {
        this.addMaterial(location, tier, order, craftable, false, null, new JsonRedirect[0]);
    }

    protected void addCompatMaterial(MaterialId location, int tier, int order, String tagName, boolean craftable) {
        ConditionJsonProvider condition = DefaultResourceConditions.or((ConditionJsonProvider[])new ConditionJsonProvider[]{ConfigEnabledCondition.FORCE_INTEGRATION_MATERIALS, AbstractMaterialDataProvider.tagExistsCondition(tagName)});
        this.addMaterial(location, tier, order, craftable, false, condition, new JsonRedirect[0]);
    }

    protected void addCompatMetalMaterial(MaterialId location, int tier, int order, String ingotName) {
        this.addCompatMaterial(location, tier, order, ingotName + "_ingots", false);
    }

    protected void addCompatMetalMaterial(MaterialId location, int tier, int order) {
        this.addCompatMetalMaterial(location, tier, order, location.method_12832());
    }

    protected JsonRedirect conditionalRedirect(MaterialId id, @Nullable ConditionJsonProvider condition) {
        return new JsonRedirect(id, condition, null);
    }

    protected JsonRedirect redirect(MaterialId id) {
        return this.conditionalRedirect(id, null);
    }

    private MaterialJson convert(DataMaterial data) {
        IMaterial material = data.material;
        JsonRedirect[] redirect = data.redirect;
        if (redirect != null && redirect.length == 0) {
            redirect = null;
        }
        if (material == null) {
            return new MaterialJson(new JsonCondition(data.condition), null, null, null, null, redirect);
        }
        return new MaterialJson(new JsonCondition(data.condition), material.isCraftable(), material.getTier(), material.getSortOrder(), material.isHidden(), redirect);
    }

    private record DataMaterial(@Nullable IMaterial material, @Nullable ConditionJsonProvider condition, JsonRedirect[] redirect) {
    }
}

