/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.materials.definition;

import javax.annotation.Nullable;
import net.minecraft.class_1799;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.LazyMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;

public class MaterialVariant
extends LazyMaterial {
    public static final MaterialVariant UNKNOWN = MaterialVariant.of(IMaterial.UNKNOWN);
    private final MaterialVariantId variant;

    protected MaterialVariant(MaterialVariantId variant) {
        super(variant.getId());
        this.variant = variant;
    }

    protected MaterialVariant(IMaterial material, String variant) {
        super(material);
        this.variant = MaterialVariantId.create(material.getIdentifier(), variant);
    }

    public static MaterialVariant of(MaterialVariantId variantId) {
        return new MaterialVariant(variantId);
    }

    public static MaterialVariant of(MaterialId id, String variant) {
        return MaterialVariant.of(MaterialVariantId.create(id, variant));
    }

    public static MaterialVariant of(IMaterial material, String variant) {
        return new MaterialVariant(material, variant);
    }

    public static MaterialVariant of(IMaterial material) {
        return MaterialVariant.of(material, "");
    }

    public boolean matchesVariant(MaterialVariantId variantId) {
        return this.variant.matchesVariant(variantId);
    }

    public boolean matchesVariant(MaterialVariant variant) {
        return this.variant.matchesVariant(variant);
    }

    public boolean matchesVariant(class_1799 stack) {
        return this.variant.matchesVariant(stack);
    }

    public boolean sameVariant(MaterialVariantId variantId) {
        return this.variant.sameVariant(variantId);
    }

    @Override
    public String toString() {
        return "MaterialVariant{" + String.valueOf(this.variant) + "}";
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        return this.variant.sameVariant(((MaterialVariant)other).variant);
    }

    @Override
    public int hashCode() {
        return this.variant.hashCode();
    }

    public MaterialVariantId getVariant() {
        return this.variant;
    }
}

