/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.dynamic;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.fabricators_of_create.porting_lib.tool.ToolAction;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.class_1304;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1792;
import net.minecraft.class_1814;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_6862;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.impl.IncrementalModifier;
import slimeknights.tconstruct.library.modifiers.util.ModifierAttribute;
import slimeknights.tconstruct.library.modifiers.util.ModifierLevelDisplay;
import slimeknights.tconstruct.library.modifiers.util.ModifierStatBoost;
import slimeknights.tconstruct.library.tools.context.ToolRebuildContext;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.stat.INumericToolStat;
import slimeknights.tconstruct.library.tools.stat.IToolStat;
import slimeknights.tconstruct.library.tools.stat.ModifierStatsBuilder;

@Deprecated
public class StatBoostModifier
extends IncrementalModifier {
    @Nullable
    private final class_1814 rarity;
    private final List<ModifierStatBoost> stats;
    private final List<ModifierAttribute> attributes;
    private final List<class_2960> flags;
    private final ModifierLevelDisplay levelDisplay;
    private final ModifierDisplay modifierDisplay;
    private final Set<ToolAction> actions;
    public static final GenericLoaderRegistry.IGenericLoader<StatBoostModifier> LOADER = new GenericLoaderRegistry.IGenericLoader<StatBoostModifier>(){

        public StatBoostModifier deserialize(JsonObject json) {
            class_1814 rarity = null;
            if (json.has("rarity")) {
                rarity = (class_1814)JsonHelper.getAsEnum((JsonObject)json, (String)"rarity", class_1814.class);
            }
            List stats = Collections.emptyList();
            if (json.has("stats")) {
                stats = JsonHelper.parseList((JsonObject)json, (String)"stats", ModifierStatBoost::fromJson);
            }
            List attributes = Collections.emptyList();
            if (json.has("attributes")) {
                attributes = JsonHelper.parseList((JsonObject)json, (String)"attributes", ModifierAttribute::fromJson);
            }
            List flags = Collections.emptyList();
            if (json.has("flags")) {
                flags = JsonHelper.parseList((JsonObject)json, (String)"flags", JsonHelper::convertToResourceLocation);
            }
            ModifierLevelDisplay display = (ModifierLevelDisplay)ModifierLevelDisplay.LOADER.getAndDeserialize(json, "level_display");
            ModifierDisplay modifierDisplay = ModifierDisplay.ALWAYS;
            if (json.has("modifier_display")) {
                modifierDisplay = (ModifierDisplay)JsonHelper.getAsEnum((JsonObject)json, (String)"modifier_display", ModifierDisplay.class);
            }
            ImmutableSet actions = Collections.emptySet();
            if (json.has("tool_actions")) {
                actions = ImmutableSet.copyOf((Collection)JsonHelper.parseList((JsonObject)json, (String)"tool_actions", (element, name) -> ToolAction.get((String)class_3518.method_15287((JsonElement)element, (String)name))));
            }
            return new StatBoostModifier(rarity, stats, attributes, flags, display, modifierDisplay, (Set<ToolAction>)actions);
        }

        public void serialize(StatBoostModifier object, JsonObject json) {
            JsonArray stats;
            json.add("level_display", ModifierLevelDisplay.LOADER.serialize((GenericLoaderRegistry.IHaveLoader)object.levelDisplay));
            if (object.rarity != null) {
                json.addProperty("rarity", object.rarity.name().toLowerCase(Locale.ROOT));
            }
            if (!object.stats.isEmpty()) {
                stats = new JsonArray();
                for (ModifierStatBoost boost : object.stats) {
                    stats.add((JsonElement)boost.toJson());
                }
                json.add("stats", (JsonElement)stats);
            }
            if (!object.attributes.isEmpty()) {
                JsonArray attributes = new JsonArray();
                for (ModifierAttribute attribute : object.attributes) {
                    attributes.add((JsonElement)attribute.toJson());
                }
                json.add("attributes", (JsonElement)attributes);
            }
            if (!object.flags.isEmpty()) {
                stats = new JsonArray();
                for (class_2960 flag : object.flags) {
                    stats.add(flag.toString());
                }
                json.add("flags", (JsonElement)stats);
            }
            if (object.modifierDisplay != ModifierDisplay.ALWAYS) {
                json.addProperty("modifier_display", object.modifierDisplay.getName());
            }
            if (!object.actions.isEmpty()) {
                JsonArray actions = new JsonArray();
                for (ToolAction action : object.actions) {
                    actions.add(action.name());
                }
                json.add("tool_actions", (JsonElement)actions);
            }
        }

        public StatBoostModifier fromNetwork(class_2540 buffer) {
            class_1814 rarity = null;
            if (buffer.readBoolean()) {
                rarity = (class_1814)buffer.method_10818(class_1814.class);
            }
            int size = buffer.method_10816();
            ImmutableList.Builder stats = ImmutableList.builder();
            for (int i = 0; i < size; ++i) {
                stats.add((Object)ModifierStatBoost.fromNetwork(buffer));
            }
            size = buffer.method_10816();
            ImmutableList.Builder attributes = ImmutableList.builder();
            for (int i = 0; i < size; ++i) {
                attributes.add((Object)ModifierAttribute.fromNetwork(buffer));
            }
            size = buffer.method_10816();
            ImmutableList.Builder flags = ImmutableList.builder();
            for (int i = 0; i < size; ++i) {
                flags.add((Object)buffer.method_10810());
            }
            ModifierLevelDisplay levelDisplay = (ModifierLevelDisplay)ModifierLevelDisplay.LOADER.fromNetwork(buffer);
            ModifierDisplay modifierDisplay = (ModifierDisplay)buffer.method_10818(ModifierDisplay.class);
            size = buffer.method_10816();
            ImmutableSet.Builder actions = ImmutableSet.builder();
            for (int i = 0; i < size; ++i) {
                actions.add((Object)ToolAction.get((String)buffer.method_10800(Short.MAX_VALUE)));
            }
            return new StatBoostModifier(rarity, (List<ModifierStatBoost>)stats.build(), (List<ModifierAttribute>)attributes.build(), (List<class_2960>)flags.build(), levelDisplay, modifierDisplay, (Set<ToolAction>)actions.build());
        }

        public void toNetwork(StatBoostModifier object, class_2540 buffer) {
            if (object.rarity != null) {
                buffer.writeBoolean(true);
                buffer.method_10817((Enum)object.rarity);
            } else {
                buffer.writeBoolean(false);
            }
            buffer.method_10804(object.stats.size());
            for (ModifierStatBoost boost : object.stats) {
                boost.toNetwork(buffer);
            }
            buffer.method_10804(object.attributes.size());
            for (ModifierAttribute attribute : object.attributes) {
                attribute.toNetwork(buffer);
            }
            buffer.method_10804(object.flags.size());
            for (class_2960 flag : object.flags) {
                buffer.method_10812(flag);
            }
            ModifierLevelDisplay.LOADER.toNetwork((GenericLoaderRegistry.IHaveLoader)object.levelDisplay, buffer);
            buffer.method_10817((Enum)object.modifierDisplay);
            buffer.method_10804(object.actions.size());
            for (ToolAction action : object.actions) {
                buffer.method_10814(action.name());
            }
        }
    };

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public class_2561 getDisplayName(int level) {
        return this.levelDisplay.nameForLevel(this, level);
    }

    @Override
    public void addVolatileData(ToolRebuildContext context, int level, ModDataNBT volatileData) {
        if (this.rarity != null) {
            IModifiable.setRarity(volatileData, this.rarity);
        }
        for (class_2960 flag : this.flags) {
            volatileData.putBoolean(flag, true);
        }
    }

    @Override
    public void addToolStats(ToolRebuildContext context, int level, ModifierStatsBuilder builder) {
        float scaledLevel = this.getScaledLevel(context, level);
        for (ModifierStatBoost boost : this.stats) {
            boost.apply(context, scaledLevel, builder);
        }
    }

    @Override
    public void addAttributes(IToolStackView tool, int level, class_1304 slot, BiConsumer<class_1320, class_1322> consumer) {
        float scaledLevel = this.getScaledLevel(tool, level);
        for (ModifierAttribute attribute : this.attributes) {
            attribute.apply(tool, scaledLevel, slot, consumer);
        }
    }

    @Override
    public boolean canPerformAction(IToolStackView tool, int level, ToolAction toolAction) {
        return this.actions.contains(toolAction);
    }

    @Override
    public GenericLoaderRegistry.IGenericLoader<? extends Modifier> getLoader() {
        return LOADER;
    }

    @Override
    public boolean shouldDisplay(boolean advanced) {
        return this.modifierDisplay.shouldDisplay(advanced);
    }

    protected StatBoostModifier(@Nullable class_1814 rarity, List<ModifierStatBoost> stats, List<ModifierAttribute> attributes, List<class_2960> flags, ModifierLevelDisplay levelDisplay, ModifierDisplay modifierDisplay, Set<ToolAction> actions) {
        this.rarity = rarity;
        this.stats = stats;
        this.attributes = attributes;
        this.flags = flags;
        this.levelDisplay = levelDisplay;
        this.modifierDisplay = modifierDisplay;
        this.actions = actions;
    }

    public static class Builder {
        private class_1814 rarity = null;
        private final ImmutableList.Builder<ModifierStatBoost> boosts = ImmutableList.builder();
        private final ImmutableList.Builder<ModifierAttribute> attributes = ImmutableList.builder();
        private final ImmutableList.Builder<class_2960> flags = ImmutableList.builder();
        private final ImmutableSet.Builder<ToolAction> actions = ImmutableSet.builder();
        private ModifierLevelDisplay display = ModifierLevelDisplay.DEFAULT;
        private ModifierDisplay modifierDisplay = ModifierDisplay.ALWAYS;

        @SafeVarargs
        public final <T> Builder update(IToolStat<T> stat, T value, class_6862<class_1792> ... tagRequirements) {
            this.boosts.add(new ModifierStatBoost.StatUpdate<T>(stat, value, List.of(tagRequirements)));
            return this;
        }

        private Builder boost(INumericToolStat<?> stat, ModifierStatBoost.BoostType type, float amount, class_6862<class_1792>[] tagRequirements) {
            this.boosts.add((Object)new ModifierStatBoost.StatBoost(stat, type, amount, List.of(tagRequirements)));
            return this;
        }

        @SafeVarargs
        public final Builder add(INumericToolStat<?> stat, float amount, class_6862<class_1792> ... tagRequirements) {
            return this.boost(stat, ModifierStatBoost.BoostType.ADD, amount, tagRequirements);
        }

        @SafeVarargs
        public final Builder multiplyBase(INumericToolStat<?> stat, float amount, class_6862<class_1792> ... tagRequirements) {
            return this.boost(stat, ModifierStatBoost.BoostType.MULTIPLY_BASE, amount, tagRequirements);
        }

        @SafeVarargs
        public final Builder multiplyConditional(INumericToolStat<?> stat, float amount, class_6862<class_1792> ... tagRequirements) {
            return this.boost(stat, ModifierStatBoost.BoostType.MULTIPLY_CONDITIONAL, amount, tagRequirements);
        }

        @SafeVarargs
        public final Builder multiplyAll(INumericToolStat<?> stat, float amount, class_6862<class_1792> ... tagRequirements) {
            return this.boost(stat, ModifierStatBoost.BoostType.MULTIPLY_ALL, amount, tagRequirements);
        }

        public Builder attribute(String unique, class_1320 attribute, class_1322.class_1323 operation, float amount, class_1304 ... slots) {
            this.attributes.add((Object)new ModifierAttribute(unique, attribute, operation, amount, slots));
            return this;
        }

        public Builder addFlag(class_2960 flag) {
            this.flags.add((Object)flag);
            return this;
        }

        public Builder addAction(ToolAction action) {
            this.actions.add((Object)action);
            return this;
        }

        public StatBoostModifier build() {
            return new StatBoostModifier(this.rarity, (List<ModifierStatBoost>)this.boosts.build(), (List<ModifierAttribute>)this.attributes.build(), (List<class_2960>)this.flags.build(), this.display, this.modifierDisplay, (Set<ToolAction>)this.actions.build());
        }

        public Builder rarity(class_1814 rarity) {
            this.rarity = rarity;
            return this;
        }

        public Builder display(ModifierLevelDisplay display) {
            this.display = display;
            return this;
        }

        public Builder modifierDisplay(ModifierDisplay modifierDisplay) {
            this.modifierDisplay = modifierDisplay;
            return this;
        }
    }

    public static enum ModifierDisplay {
        ALWAYS(true, true),
        TABLE(true, false),
        NEVER(false, false);

        private final boolean normal;
        private final boolean advanced;
        private final String name = this.name().toLowerCase(Locale.ROOT);

        public boolean shouldDisplay(boolean isAdvanced) {
            return isAdvanced ? this.advanced : this.normal;
        }

        private ModifierDisplay(boolean normal, boolean advanced) {
            this.normal = normal;
            this.advanced = advanced;
        }

        public String getName() {
            return this.name;
        }
    }
}

