/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.impl;

import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import java.util.List;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.util.ModifierHookMap;
import slimeknights.tconstruct.library.recipe.tinkerstation.ValidatedResult;
import slimeknights.tconstruct.library.tools.capability.ToolFluidCapability;
import slimeknights.tconstruct.library.tools.context.ToolRebuildContext;
import slimeknights.tconstruct.library.tools.nbt.IModDataView;
import slimeknights.tconstruct.library.tools.nbt.IToolContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.utils.TooltipKey;

public class TankModifier
extends Modifier {
    private static final String FILLED_KEY = TConstruct.makeTranslationKey("modifier", "tank.filled");
    private static final String CAPACITY_KEY = TConstruct.makeTranslationKey("modifier", "tank.capacity");
    private static final class_2960 OWNER = TConstruct.getResource("tank_owner");
    private static final class_2960 CAPACITY = TConstruct.getResource("tank_capacity");
    private static final class_2960 FLUID = TConstruct.getResource("tank_fluid");
    public static final BiFunction<class_2487, String, FluidStack> PARSE_FLUID = (nbt, key) -> FluidStack.loadFluidStackFromNBT((class_2487)nbt.method_10562(key));
    private ModifierTank tank;
    private final long capacity;

    @Override
    protected void registerHooks(ModifierHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        this.tank = new ModifierTank();
        hookBuilder.addHook(this.tank, ToolFluidCapability.HOOK);
    }

    @Override
    public void addVolatileData(ToolRebuildContext context, int level, ModDataNBT volatileData) {
        class_2960 ownerKey = this.getOwnerKey();
        if (ownerKey != null && !volatileData.contains(ownerKey, 8)) {
            volatileData.putString(ownerKey, this.getId().toString());
        }
        ToolFluidCapability.addTanks(context, this, volatileData, this.tank);
        if (this.capacity > 0L) {
            this.addCapacity(volatileData, this.capacity * (long)level);
        }
    }

    @Override
    public void addInformation(IToolStackView tool, int level, @Nullable class_1657 player, List<class_2561> tooltip, TooltipKey tooltipKey, class_1836 tooltipFlag) {
        if (this.isOwner(tool)) {
            FluidStack current = this.getFluid(tool);
            if (!current.isEmpty()) {
                tooltip.add((class_2561)class_2561.method_43469((String)FILLED_KEY, (Object[])new Object[]{current.getAmount(), current.getDisplayName()}));
            }
            tooltip.add((class_2561)class_2561.method_43469((String)CAPACITY_KEY, (Object[])new Object[]{this.getCapacity(tool)}));
        }
    }

    @Override
    public ValidatedResult validate(IToolStackView tool, int level) {
        FluidStack fluidStack;
        if (level > 0 && this.isOwner(tool) && !(fluidStack = this.getFluid(tool)).isEmpty()) {
            int capacity = this.getCapacity(tool);
            if (fluidStack.getAmount() > (long)capacity) {
                fluidStack.setAmount((long)capacity);
                this.setFluid(tool, fluidStack);
            }
        }
        return ValidatedResult.PASS;
    }

    @Override
    public void onRemoved(IToolStackView tool) {
        ModDataNBT persistentData = tool.getPersistentData();
        if (!persistentData.contains(OWNER, 8)) {
            persistentData.remove(this.getFluidKey());
        }
    }

    @Nullable
    public class_2960 getOwnerKey() {
        return OWNER;
    }

    public class_2960 getCapacityKey() {
        return CAPACITY;
    }

    public class_2960 getFluidKey() {
        return FLUID;
    }

    public boolean isOwner(IModDataView volatileData) {
        class_2960 key = this.getOwnerKey();
        if (key == null) {
            return true;
        }
        return this.getId().toString().equals(volatileData.getString(key));
    }

    public boolean isOwner(IToolStackView tool) {
        return this.isOwner(tool.getVolatileData());
    }

    public int getCapacity(IModDataView volatileData) {
        return volatileData.getInt(this.getCapacityKey());
    }

    public int getCapacity(IToolStackView tool) {
        return tool.getVolatileData().getInt(this.getCapacityKey());
    }

    public void addCapacity(ModDataNBT volatileNBT, long amount) {
        class_2960 key = this.getCapacityKey();
        if (volatileNBT.contains(key, 99)) {
            amount += (long)volatileNBT.getInt(key);
        }
        volatileNBT.putLong(key, amount);
    }

    public FluidStack getFluid(IToolStackView tool) {
        return tool.getPersistentData().get(this.getFluidKey(), PARSE_FLUID);
    }

    public FluidStack setFluid(ContainerItemContext context, IToolStackView tool, FluidStack fluid, TransactionContext tx) {
        int capacity = this.getCapacity(tool);
        if (fluid.getAmount() > (long)capacity) {
            fluid.setAmount((long)capacity);
        }
        class_1799 newStack = context.getItemVariant().toStack();
        ToolStack toolStackCopy = ToolStack.copyFrom(newStack);
        toolStackCopy.getPersistentData().put(this.getFluidKey(), (class_2520)fluid.writeToNBT(new class_2487()));
        newStack.method_7980(toolStackCopy.getNbt());
        if (context.exchange(ItemVariant.of((class_1799)newStack), 1L, tx) != 1L) {
            TConstruct.LOG.error("Failed to set fluid for tank modifier!");
        }
        return fluid;
    }

    public FluidStack setFluid(IToolStackView tool, FluidStack fluid) {
        if (fluid.isEmpty()) {
            tool.getPersistentData().remove(this.getFluidKey());
            return fluid;
        }
        int capacity = this.getCapacity(tool);
        if (fluid.getAmount() > (long)capacity) {
            fluid.setAmount((long)capacity);
        }
        tool.getPersistentData().put(this.getFluidKey(), (class_2520)fluid.writeToNBT(new class_2487()));
        return fluid;
    }

    public FluidStack fill(ContainerItemContext context, IToolStackView tool, FluidStack current, FluidStack resource, long amount, TransactionContext tx) {
        int capacity = this.getCapacity(tool);
        if (current.isEmpty()) {
            resource.setAmount(Math.min(amount, (long)capacity));
            return this.setFluid(context, tool, resource, tx);
        }
        if (current.isFluidEqual(resource)) {
            current.setAmount(Math.min(current.getAmount() + amount, (long)capacity));
            return this.setFluid(context, tool, current, tx);
        }
        return FluidStack.EMPTY;
    }

    public FluidStack fill(IToolStackView tool, FluidStack current, FluidStack resource, long amount) {
        int capacity = this.getCapacity(tool);
        if (current.isEmpty()) {
            resource.setAmount(Math.min(amount, (long)capacity));
            return this.setFluid(tool, resource);
        }
        if (current.isFluidEqual(resource)) {
            current.setAmount(Math.min(current.getAmount() + amount, (long)capacity));
            return this.setFluid(tool, current);
        }
        return FluidStack.EMPTY;
    }

    public FluidStack drain(ContainerItemContext context, IToolStackView tool, FluidStack current, long amount, TransactionContext tx) {
        if (current.getAmount() < amount) {
            return this.setFluid(context, tool, FluidStack.EMPTY, tx);
        }
        current.shrink(amount);
        return this.setFluid(context, tool, current, tx);
    }

    public FluidStack drain(IToolStackView tool, FluidStack current, long amount) {
        if (current.getAmount() < amount) {
            return this.setFluid(tool, FluidStack.EMPTY);
        }
        current.shrink(amount);
        return this.setFluid(tool, current);
    }

    public TankModifier(long capacity) {
        this.capacity = capacity;
    }

    public class ModifierTank
    implements ToolFluidCapability.IFluidModifier,
    ToolFluidCapability.FluidModifierHook {
        @Override
        public int getTanks(IModDataView volatileData) {
            return TankModifier.this.isOwner(volatileData) ? 1 : 0;
        }

        @Override
        public FluidStack getFluidInTank(IToolStackView tool, int level, int tank) {
            return TankModifier.this.isOwner(tool) ? TankModifier.this.getFluid(tool) : FluidStack.EMPTY;
        }

        @Override
        public long getTankCapacity(IToolStackView tool, int level, int tank) {
            return TankModifier.this.isOwner(tool) ? (long)TankModifier.this.getCapacity(tool) : 0L;
        }

        @Override
        public long fill(ContainerItemContext context, IToolStackView tool, int level, FluidVariant resource, long maxAmount, TransactionContext tx) {
            if (!resource.isBlank() && TankModifier.this.isOwner(tool)) {
                FluidStack current = TankModifier.this.getFluid(tool);
                long remaining = (long)TankModifier.this.getCapacity(tool) - current.getAmount();
                if (remaining <= 0L) {
                    return 0L;
                }
                if (!current.isEmpty() && !current.isFluidEqual(resource)) {
                    return 0L;
                }
                long filled = Math.min(remaining, maxAmount);
                if (filled > 0L) {
                    TankModifier.this.fill(context, tool, current, new FluidStack(resource, maxAmount), filled, tx);
                }
                return filled;
            }
            return 0L;
        }

        @Override
        public long drain(ContainerItemContext context, IToolStackView tool, int level, FluidVariant resource, long maxAmount, TransactionContext tx) {
            if (!resource.isBlank() && TankModifier.this.isOwner(tool)) {
                FluidStack current = TankModifier.this.getFluid(tool);
                if (current.isEmpty() || !current.isFluidEqual(resource)) {
                    return 0L;
                }
                long drainedAmount = Math.min(current.getAmount(), maxAmount);
                FluidStack drained = new FluidStack(current, drainedAmount);
                TankModifier.this.drain(context, tool, current, drainedAmount, tx);
                return drained.getAmount();
            }
            return 0L;
        }

        @Override
        public int getTanks(IToolContext tool, Modifier modifier) {
            return this.getTanks(tool.getVolatileData());
        }

        @Override
        public SingleSlotStorage<FluidVariant> getSlot(IToolStackView tool, ModifierEntry modifier, int slot) {
            throw new RuntimeException("TODO: Not supported yet");
        }

        @Override
        public FluidStack getFluidInTank(IToolStackView tool, ModifierEntry modifier, int tank) {
            return this.getFluidInTank(tool, modifier.getLevel(), tank);
        }

        @Override
        public long getTankCapacity(IToolStackView tool, ModifierEntry modifier, int tank) {
            return this.getTankCapacity(tool, modifier.getLevel(), tank);
        }

        @Override
        public boolean isFluidValid(IToolStackView tool, ModifierEntry modifier, int tank, FluidStack fluid) {
            return this.isFluidValid(tool, modifier.getLevel(), tank, fluid);
        }

        @Override
        public long fill(ContainerItemContext context, IToolStackView tool, ModifierEntry modifier, FluidVariant resource, long maxAmount, TransactionContext tx) {
            return this.fill(context, tool, modifier.getLevel(), resource, maxAmount, tx);
        }

        @Override
        public long drain(ContainerItemContext context, IToolStackView tool, ModifierEntry modifier, FluidVariant resource, long maxAmount, TransactionContext tx) {
            return this.drain(context, tool, modifier.getLevel(), resource, maxAmount, tx);
        }
    }
}

